/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.Serializable;
import net.openhft.lang.Maths;

public interface HashSplitting
extends Serializable {
    public int segmentIndex(long var1);

    public long segmentHash(long var1);

    public static class ForNonPowerOf2Segments
    implements HashSplitting {
        private static final long serialVersionUID = 0L;
        private static final int MASK = Integer.MAX_VALUE;
        private static final int BITS = 31;
        private final int segments;

        public ForNonPowerOf2Segments(int segments) {
            this.segments = segments;
        }

        @Override
        public int segmentIndex(long hash) {
            return ((int)hash & Integer.MAX_VALUE) % this.segments;
        }

        @Override
        public long segmentHash(long hash) {
            return hash >>> 31;
        }
    }

    public static class ForPowerOf2Segments
    implements HashSplitting {
        private static final long serialVersionUID = 0L;
        private final int mask;
        private final int bits;

        ForPowerOf2Segments(int segments) {
            this.mask = segments - 1;
            this.bits = Integer.numberOfTrailingZeros(segments);
        }

        @Override
        public int segmentIndex(long hash) {
            return (int)hash & this.mask;
        }

        @Override
        public long segmentHash(long hash) {
            return hash >>> this.bits;
        }
    }

    public static enum ForSingleSegment implements HashSplitting
    {
        INSTANCE;


        @Override
        public int segmentIndex(long hash) {
            return 0;
        }

        @Override
        public long segmentHash(long hash) {
            return hash;
        }
    }

    public static class Splitting {
        static HashSplitting forSegments(int segments) {
            assert (segments > 0);
            if (segments == 1) {
                return ForSingleSegment.INSTANCE;
            }
            if (Maths.isPowerOf2((int)segments)) {
                return new ForPowerOf2Segments(segments);
            }
            return new ForNonPowerOf2Segments(segments);
        }
    }
}

