/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public interface Replica
extends Closeable {
    public byte identifier();

    public ModificationIterator acquireModificationIterator(byte var1, ModificationNotifier var2);

    public long lastModificationTime(byte var1);

    public static abstract class EntryCallback {
        public abstract boolean onEntry(Bytes var1, int var2);

        public void onAfterEntry() {
        }

        public void onBeforeEntry() {
        }

        public abstract boolean shouldBeIgnored(Bytes var1, int var2);
    }

    public static interface EntryResolver<K, V> {
        public K key(@NotNull Bytes var1, K var2);

        public V value(@NotNull Bytes var1, V var2);

        public boolean wasRemoved(@NotNull Bytes var1);
    }

    public static interface EntryExternalizable {
        public int sizeOfEntry(@NotNull Bytes var1, int var2);

        public boolean identifierCheck(@NotNull Bytes var1, int var2);

        public void writeExternalEntry(@NotNull Bytes var1, @NotNull Bytes var2, int var3);

        public void readExternalEntry(@NotNull ReplicatedChronicleMap.BytesReplicatedContext var1, @NotNull Bytes var2);
    }

    public static interface ModificationIterator {
        public boolean hasNext();

        public boolean nextEntry(@NotNull EntryCallback var1, int var2);

        public void dirtyEntries(long var1);
    }

    public static interface ModificationNotifier {
        public static final ModificationNotifier NOP = new ModificationNotifier(){

            @Override
            public void onChange() {
            }
        };

        public void onChange();
    }
}

