/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.map.FPMEvent;
import org.jetbrains.annotations.NotNull;

public class FilePerKeyMap
implements Map<String, String> {
    private final Path dirPath;
    private final Map<File, Long> lastModifiedByProgram = new ConcurrentHashMap<File, Long>();
    private final Map<File, String> lastUpdate = new ConcurrentHashMap<File, String>();
    private final List<Consumer<FPMEvent>> listeners = new ArrayList<Consumer<FPMEvent>>();
    private final FPMWatcher fileFpmWatcher = new FPMWatcher();

    public FilePerKeyMap(String dir) {
        this.dirPath = Paths.get(dir, new String[0]);
        try {
            Files.createDirectories(this.dirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.fileFpmWatcher.start();
    }

    public void registerForEvents(Consumer<FPMEvent> listener) {
        this.listeners.add(listener);
    }

    public void unregisterForEvents(Consumer<FPMEvent> listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(FPMEvent event) {
        for (Consumer<FPMEvent> listener : this.listeners) {
            listener.accept(event);
        }
    }

    @Override
    public int size() {
        return (int)this.getFiles().count();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getFiles().anyMatch(p -> p.getFileName().toString().equals(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getFiles().anyMatch(p -> this.getFileContents((Path)p).equals(value));
    }

    @Override
    public String get(Object key) {
        Path path = this.dirPath.resolve((String)key);
        return this.getFileContents(path);
    }

    @Override
    public String put(String key, String value) {
        Path path = this.dirPath.resolve(key);
        String existingValue = this.getFileContents(path);
        this.writeToFile(path, value);
        return existingValue;
    }

    @Override
    public String remove(Object key) {
        String existing = this.get(key);
        if (existing != null) {
            this.deleteFile(this.dirPath.resolve((String)key));
        }
        return existing;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        m.entrySet().stream().forEach((? super T e) -> this.put((String)e.getKey(), (String)e.getValue()));
    }

    @Override
    public void clear() {
        this.getFiles().forEach(this::deleteFile);
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.getFiles().map(p -> p.getFileName().toString()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<String> values() {
        return this.getFiles().map(p -> this.getFileContents((Path)p)).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getFiles().map(p -> new FPMEntry<String>(p.getFileName().toString(), this.getFileContents((Path)p))).collect(Collectors.toSet());
    }

    private Stream<Path> getFiles() {
        try {
            return Files.walk(this.dirPath, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFileContents(Path path) {
        String existingValue = null;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                existingValue = Files.readAllLines(path).stream().collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return existingValue;
    }

    private void writeToFile(Path path, String value) {
        try {
            Files.write(path, value.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            this.lastModifiedByProgram.put(path.toFile(), path.toFile().lastModified());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void deleteFile(Path path) {
        try {
            Files.delete(path);
            this.lastModifiedByProgram.put(path.toFile(), path.toFile().lastModified());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void close() {
        this.fileFpmWatcher.interrupt();
    }

    private boolean isProgrammaticUpdate(File file) {
        return this.lastModifiedByProgram.containsKey(file) && file.lastModified() == this.lastModifiedByProgram.get(file).longValue();
    }

    private class FPMWatcher
    extends Thread {
        private FPMWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WatchService watcher = FileSystems.getDefault().newWatchService();
                FilePerKeyMap.this.dirPath.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
                block6: while (true) {
                    WatchKey key = null;
                    try {
                        key = watcher.take();
                        Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                        while (true) {
                            String mapVal;
                            Path p;
                            if (!iterator.hasNext()) continue block6;
                            WatchEvent<?> event = iterator.next();
                            WatchEvent.Kind<?> kind = event.kind();
                            WatchEvent<?> ev = event;
                            Path fileName = (Path)ev.context();
                            String mapKey = fileName.toString();
                            if (mapKey.startsWith(".") || kind == StandardWatchEventKinds.OVERFLOW) continue;
                            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                p = FilePerKeyMap.this.dirPath.resolve(fileName);
                                mapVal = FilePerKeyMap.this.getFileContents(p);
                                FilePerKeyMap.this.lastUpdate.put(p.toFile(), mapVal);
                                if (FilePerKeyMap.this.isProgrammaticUpdate(p.toFile())) {
                                    FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.NEW, true, mapKey, null, mapVal));
                                    continue;
                                }
                                FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.NEW, false, mapKey, null, mapVal));
                                continue;
                            }
                            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                p = FilePerKeyMap.this.dirPath.resolve(fileName);
                                String lastVal = (String)FilePerKeyMap.this.lastUpdate.get(p.toFile());
                                FilePerKeyMap.this.lastUpdate.remove(p.toFile());
                                if (FilePerKeyMap.this.isProgrammaticUpdate(p.toFile())) {
                                    FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.DELETE, true, mapKey, lastVal, null));
                                    continue;
                                }
                                FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.DELETE, false, mapKey, lastVal, null));
                                continue;
                            }
                            if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                            p = FilePerKeyMap.this.dirPath.resolve(fileName);
                            mapVal = FilePerKeyMap.this.getFileContents(p);
                            String lastVal = null;
                            if (mapVal != null) {
                                lastVal = FilePerKeyMap.this.lastUpdate.put(p.toFile(), mapVal);
                            }
                            if (lastVal != null && lastVal.equals(mapVal)) continue;
                            if (FilePerKeyMap.this.isProgrammaticUpdate(p.toFile())) {
                                FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.UPDATE, true, mapKey, lastVal, mapVal));
                                continue;
                            }
                            FilePerKeyMap.this.fireEvent(new FPMEvent(FPMEvent.EventType.UPDATE, false, mapKey, lastVal, mapVal));
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    finally {
                        if (key == null) continue;
                        key.reset();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FPMEntry<String>
    implements Map.Entry<String, String> {
        private String key;
        private String value;

        public FPMEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            String lastValue = this.value;
            this.value = value;
            return lastValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FPMEntry fpmEntry = (FPMEntry)o;
            if (this.key != null ? !this.key.equals(fpmEntry.key) : fpmEntry.key != null) {
                return false;
            }
            return !(this.value == null ? fpmEntry.value != null : !this.value.equals(fpmEntry.value));
        }

        @Override
        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

