/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.hash.ChronicleHashStatelessClientBuilder;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapBuilder;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.lang.MemoryUnit;

public final class ChronicleMapStatelessClientBuilder<K, V>
implements ChronicleHashStatelessClientBuilder<ChronicleMapStatelessClientBuilder<K, V>, ChronicleMap<K, V>>,
MapBuilder<ChronicleMapStatelessClientBuilder<K, V>> {
    private final InetSocketAddress remoteAddress;
    private final AtomicBoolean used = new AtomicBoolean(false);
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private long timeoutMs = TimeUnit.SECONDS.toMillis(10L);
    private String name;
    private int tcpBufferSize = (int)MemoryUnit.KILOBYTES.toBytes(64L);

    ChronicleMapStatelessClientBuilder(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    static <K, V> ChronicleMapStatelessClientBuilder<K, V> of(InetSocketAddress serverAddress) {
        return new ChronicleMapStatelessClientBuilder<K, V>(serverAddress);
    }

    public static <K, V> ChronicleMap<K, V> createClientOf(InetSocketAddress serverAddress) throws IOException {
        return ChronicleMapStatelessClientBuilder.of(serverAddress).create();
    }

    InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public ChronicleMapStatelessClientBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    @Override
    public ChronicleMapStatelessClientBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public ChronicleMapStatelessClientBuilder<K, V> timeout(long timeout, TimeUnit units) {
        this.timeoutMs = units.toMillis(timeout);
        return this;
    }

    long timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public ChronicleMapStatelessClientBuilder<K, V> name(String name) {
        this.name = name;
        return this;
    }

    String name() {
        return this.name;
    }

    @Override
    public ChronicleMapStatelessClientBuilder<K, V> tcpBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
        return this;
    }

    int tcpBufferSize() {
        return this.tcpBufferSize;
    }

    @Override
    public ChronicleMap<K, V> create() throws IOException {
        if (!this.used.getAndSet(true)) {
            return new StatelessChronicleMap(this);
        }
        throw new IllegalStateException("A stateless client has already been created using this builder. Create a new ChronicleMapStatelessClientBuilder to create a new stateless client");
    }
}

