/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;

public enum DoubleMarshaller implements BytesInterop<Double>,
BytesReader<Double>,
SizeMarshaller
{
    INSTANCE;


    @Override
    public long size(Double e) {
        return 8L;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public long minEncodableSize() {
        return 8L;
    }

    @Override
    public int minSizeEncodingSize() {
        return 0;
    }

    @Override
    public int maxSizeEncodingSize() {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
    }

    @Override
    public boolean startsWith(Bytes bytes, Double e) {
        return Double.doubleToLongBits(e) == bytes.readLong(bytes.position());
    }

    @Override
    public long hash(Double e) {
        return Hasher.hash(Double.doubleToLongBits(e));
    }

    @Override
    public void write(Bytes bytes, Double e) {
        bytes.writeLong(Double.doubleToLongBits(e));
    }

    @Override
    public long readSize(Bytes bytes) {
        return 8L;
    }

    @Override
    public Double read(Bytes bytes, long size) {
        return Double.longBitsToDouble(bytes.readLong());
    }

    @Override
    public Double read(Bytes bytes, long size, Double toReuse) {
        return this.read(bytes, size);
    }
}

