/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.internal.BasicCopyingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.ByteableMarshaller;
import net.openhft.chronicle.hash.serialization.internal.DirectBytesBuffer;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.DataValueGenerator;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.DataValueModels;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

public abstract class DataValueMetaBytesInterop<E>
extends BasicCopyingMetaBytesInterop<E, BytesWriter<E>> {
    private static final long serialVersionUID = 0L;

    protected DataValueMetaBytesInterop(DirectBytesBuffer buffer) {
        super(buffer);
    }

    void init(BytesWriter<E> writer, E e, long size) {
        Bytes buffer = this.buffer.obtain(size, true);
        writer.write(buffer, e);
        buffer.flip();
        assert (buffer.remaining() == size);
        this.size = size;
        this.hash = 0L;
    }

    public static <E> MetaBytesInterop<E, BytesWriter<E>> forIdentity(Serializable bufferIdentity) {
        return new DirectBytesBuffer((Serializable)bufferIdentity).forDataValueWriter;
    }

    public static <E> MetaProvider<E, BytesWriter<E>, MetaBytesInterop<E, BytesWriter<E>>> interopProvider(Class<E> eClass) {
        return new InteropProvider(eClass);
    }

    private static class InteropProvider<E>
    extends BasicCopyingMetaBytesInterop.BasicCopyingMetaBytesInteropProvider<E, BytesWriter<E>, MetaBytesInterop<E, BytesWriter<E>>> {
        private static final long serialVersionUID = 0L;
        private final Class<E> eClass;
        transient long size;
        transient MetaBytesInterop metaByteableInterop;

        private InteropProvider(Class<E> eClass) {
            this.eClass = eClass;
            this.initTransients();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.initTransients();
        }

        private void initTransients() {
            DataValueModel model = DataValueModels.acquireModel(this.eClass);
            this.size = DataValueGenerator.computeNonScalarOffset((DataValueModel)model, this.eClass);
            this.metaByteableInterop = ByteableMarshaller.of(DataValueClasses.directClassFor(this.eClass));
        }

        @Override
        public MetaBytesInterop<E, BytesWriter<E>> get(ThreadLocalCopies copies, MetaBytesInterop<E, BytesWriter<E>> originalMetaWriter, BytesWriter<E> writer, E e) {
            if (e instanceof Byteable) {
                return this.metaByteableInterop;
            }
            DirectBytesBuffer.ForDataValueWriter forDataValueWriter = ((DirectBytesBuffer)BasicCopyingMetaBytesInterop.provider.get((ThreadLocalCopies)copies, (Object)((DataValueMetaBytesInterop)originalMetaWriter).buffer)).forDataValueWriter;
            forDataValueWriter.init(writer, e, this.size);
            return forDataValueWriter;
        }
    }
}

