/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.MultiMapFactory;
import net.openhft.chronicle.map.SearchState;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

class ShortShortMultiMap
implements MultiMap {
    static final long MAX_CAPACITY = 65536L;
    private static final int ENTRY_SIZE = 4;
    private static final int ENTRY_SIZE_SHIFT = 2;
    private static final int UNSET_KEY = 0;
    private static final long MASK = 65535L;
    private static final long HASH_INSTEAD_OF_UNSET_KEY = 65535L;
    private static final int UNSET_ENTRY = 0;
    private final int capacity;
    private final int capacityMask;
    private final int capacityMask2;
    private final Bytes bytes;
    private ATSDirectBitSet positions;

    public ShortShortMultiMap(long minCapacity) {
        assert (minCapacity <= 65536L);
        long capacity = MultiMapFactory.multiMapCapacity(minCapacity);
        assert (Maths.isPowerOf2((long)capacity));
        this.capacity = (int)capacity;
        this.capacityMask = (int)(capacity - 1L);
        this.capacityMask2 = this.capacityMask * 4;
        this.bytes = DirectStore.allocateLazy((long)(capacity * 4L)).bytes();
        this.positions = MultiMapFactory.newPositions(capacity);
        this.clear();
    }

    public ShortShortMultiMap(Bytes multiMapBytes, Bytes multiMapBitSetBytes) {
        long capacity = multiMapBytes.capacity() / 4L;
        assert (Maths.isPowerOf2((long)capacity));
        assert (capacity / 2L <= 65536L);
        this.capacity = (int)capacity;
        this.capacityMask = (int)(capacity - 1L);
        this.capacityMask2 = this.capacityMask * 4;
        this.bytes = multiMapBytes;
        this.positions = new ATSDirectBitSet(multiMapBitSetBytes);
    }

    public static long sizeInBytes(long minCapacity) {
        return MultiMapFactory.multiMapCapacity(minCapacity) * 4L;
    }

    private void checkValueForPut(long value) {
        assert ((value & 0xFFFFFFFFFFFF0000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isClear(value)) : "Shouldn't put existing value";
    }

    private void checkValueForRemove(long value) {
        assert ((value & 0xFFFFFFFFFFFF0000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isSet(value)) : "Shouldn't remove absent value";
    }

    private static long maskUnsetKey(long key) {
        return (key &= 0xFFFFL) != 0L ? key : 65535L;
    }

    private int step(int pos) {
        return pos + 4 & this.capacityMask2;
    }

    private long stepBack(long pos) {
        return pos - 4L & (long)this.capacityMask2;
    }

    private int pos(long key) {
        return ((int)key & this.capacityMask) << 2;
    }

    private static int entry(long key, long value) {
        return (int)(key << 16 | value);
    }

    private static long key(int entry) {
        return entry >>> 16;
    }

    private static long value(int entry) {
        return entry & 0xFFFF;
    }

    @Override
    public void putPosition(long value) {
        this.checkValueForPut(value);
        this.positions.set(value);
    }

    @Override
    public void put(long key, long value) {
        key = ShortShortMultiMap.maskUnsetKey(key);
        this.checkValueForPut(value);
        int pos = this.pos(key);
        while (true) {
            int entry;
            if ((entry = this.bytes.readInt((long)pos)) == 0) {
                this.bytes.writeInt((long)pos, ShortShortMultiMap.entry(key, value));
                this.positions.set(value);
                return;
            }
            pos = this.step(pos);
        }
    }

    @Override
    public void removePosition(long value) {
        this.checkValueForRemove(value);
        this.positions.clear(value);
    }

    @Override
    public void remove(long key, long value) {
        key = ShortShortMultiMap.maskUnsetKey(key);
        this.checkValueForRemove(value);
        int limit = this.capacity;
        int pos = this.pos(key);
        while (true) {
            int entry;
            if (ShortShortMultiMap.key(entry = this.bytes.readInt((long)pos)) == key && ShortShortMultiMap.value(entry) == value) break;
            if (limit-- < 0) {
                throw new IllegalStateException();
            }
            pos = this.step(pos);
        }
        long posToRemove = pos;
        this.positions.clear(value);
        this.removePos(posToRemove);
    }

    @Override
    public void replace(long key, long oldValue, long newValue) {
        key = ShortShortMultiMap.maskUnsetKey(key);
        this.checkValueForRemove(oldValue);
        this.checkValueForPut(newValue);
        int pos = this.pos(key);
        while (true) {
            int entry;
            if (ShortShortMultiMap.key(entry = this.bytes.readInt((long)pos)) == key && ShortShortMultiMap.value(entry) == oldValue) {
                this.positions.clear(oldValue);
                this.positions.set(newValue);
                this.bytes.writeInt((long)pos, ShortShortMultiMap.entry(key, newValue));
                return;
            }
            pos = this.step(pos);
        }
    }

    private void removePos(long posToRemove) {
        int entryToShift;
        int posToShift = (int)posToRemove;
        while ((entryToShift = this.bytes.readInt((long)(posToShift = this.step(posToShift)))) != 0) {
            boolean cond2;
            long insertPos = this.pos(ShortShortMultiMap.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= (long)posToShift;
            if ((!cond1 || !cond2) && ((long)posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.bytes.writeInt(posToRemove, entryToShift);
            posToRemove = posToShift;
        }
        this.bytes.writeInt(posToRemove, 0);
    }

    @Override
    public void startSearch(long key, SearchState searchStateToReuse) {
        key = ShortShortMultiMap.maskUnsetKey(key);
        searchStateToReuse.searchPos = this.pos(key);
        searchStateToReuse.searchHash = key;
        searchStateToReuse.putAfterFailedSearch = false;
    }

    @Override
    public long size() {
        int pos = 0;
        int size = 0;
        for (int count = this.capacity; count > 0; --count) {
            int entry = this.bytes.readInt((long)pos);
            pos = this.step(pos);
            if (entry == 0) continue;
            ++size;
        }
        return size;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long nextPos(SearchState searchState) {
        int pos = (int)searchState.searchPos;
        for (int count = this.capacity; count > 0; --count) {
            int entry = this.bytes.readInt((long)pos);
            if (entry == 0) {
                searchState.searchPos = pos;
                return -1L;
            }
            pos = this.step(pos);
            if (ShortShortMultiMap.key(entry) != searchState.searchHash) continue;
            searchState.searchPos = pos;
            return ShortShortMultiMap.value(entry);
        }
        throw new IllegalStateException();
    }

    @Override
    public void removePrevPos(SearchState searchState) {
        long prevPos = this.stepBack(searchState.searchPos);
        int entry = this.bytes.readInt(prevPos);
        this.positions.clear(ShortShortMultiMap.value(entry));
        this.removePos(prevPos);
    }

    @Override
    public void replacePrevPos(SearchState searchState, long newValue, boolean oldValueInPositions) {
        this.checkValueForPut(newValue);
        long prevPos = searchState.searchPos;
        if (!searchState.putAfterFailedSearch) {
            prevPos = this.stepBack(prevPos);
        }
        if (oldValueInPositions) {
            int oldEntry = this.bytes.readInt(prevPos);
            long oldValue = ShortShortMultiMap.value(oldEntry);
            this.checkValueForRemove(oldValue);
            this.positions.clear(oldValue);
        }
        this.positions.set(newValue);
        this.bytes.writeInt(prevPos, ShortShortMultiMap.entry(searchState.searchHash, newValue));
    }

    @Override
    public void putAfterFailedSearch(SearchState searchState, long value) {
        this.checkValueForPut(value);
        this.positions.set(value);
        this.bytes.writeInt(searchState.searchPos, ShortShortMultiMap.entry(searchState.searchHash, value));
        searchState.putAfterFailedSearch = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        long pos = 0L;
        int i = 0;
        while (i < this.capacity) {
            int entry = this.bytes.readInt(pos);
            if (entry != 0) {
                sb.append(ShortShortMultiMap.key(entry)).append('=').append(ShortShortMultiMap.value(entry)).append(", ");
            }
            ++i;
            pos += 4L;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
            return sb.append(" }").toString();
        }
        return "{ }";
    }

    @Override
    public void forEach(MultiMap.EntryConsumer action) {
        long pos = 0L;
        int i = 0;
        while (i < this.capacity) {
            int entry = this.bytes.readInt(pos);
            if (entry != 0) {
                action.accept(ShortShortMultiMap.key(entry), ShortShortMultiMap.value(entry));
            }
            ++i;
            pos += 4L;
        }
    }

    @Override
    public DirectBitSet getPositions() {
        return this.positions;
    }

    @Override
    public void clear() {
        this.positions.clear();
        this.bytes.zeroOut();
    }
}

