/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.ChronicleHashInstanceBuilder;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValue;
import net.openhft.chronicle.set.DummyValueMarshaller;
import net.openhft.chronicle.set.SetFromMap;
import net.openhft.chronicle.set.SetInstanceBuilder;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import org.jetbrains.annotations.NotNull;

public final class ChronicleSetBuilder<E>
implements ChronicleHashBuilder<E, ChronicleSet<E>, ChronicleSetBuilder<E>> {
    private ChronicleMapBuilder<E, DummyValue> chronicleMapBuilder;

    ChronicleSetBuilder(Class<E> keyClass) {
        this.chronicleMapBuilder = ChronicleMapBuilder.of(keyClass, DummyValue.class).valueMarshallers(DummyValueMarshaller.INSTANCE, DummyValueMarshaller.INSTANCE).valueSizeMarshaller(DummyValueMarshaller.INSTANCE);
    }

    public static <K> ChronicleSetBuilder<K> of(Class<K> keyClass) {
        return new ChronicleSetBuilder<K>(keyClass);
    }

    @Override
    public ChronicleSetBuilder<E> clone() {
        try {
            ChronicleSetBuilder result = (ChronicleSetBuilder)super.clone();
            result.chronicleMapBuilder = this.chronicleMapBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleSetBuilder<E> actualSegments(int actualSegments) {
        this.chronicleMapBuilder.actualSegments(actualSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> minSegments(int minSegments) {
        this.chronicleMapBuilder.minSegments(minSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> entriesPerSegment(long entriesPerSegment) {
        this.chronicleMapBuilder.entriesPerSegment(entriesPerSegment);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> actualChunksPerSegment(long actualChunksPerSegment) {
        this.chronicleMapBuilder.actualChunksPerSegment(actualChunksPerSegment);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> averageKeySize(double averageKeySize) {
        this.chronicleMapBuilder.averageKeySize(averageKeySize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> constantKeySizeBySample(E sampleKey) {
        this.chronicleMapBuilder.constantKeySizeBySample((Object)sampleKey);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> actualChunkSize(int actualChunkSize) {
        this.chronicleMapBuilder.actualChunkSize(actualChunkSize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> maxChunksPerEntry(int maxChunksPerEntry) {
        this.chronicleMapBuilder.maxChunksPerEntry(maxChunksPerEntry);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> entries(long entries) {
        this.chronicleMapBuilder.entries(entries);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.chronicleMapBuilder.lockTimeOut(lockTimeOut, unit);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> errorListener(ChronicleHashErrorListener errorListener) {
        this.chronicleMapBuilder.errorListener(errorListener);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> metaDataBytes(int metaDataBytes) {
        this.chronicleMapBuilder.metaDataBytes(metaDataBytes);
        return this;
    }

    public String toString() {
        return " ChronicleSetBuilder{chronicleMapBuilder=" + this.chronicleMapBuilder + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChronicleSetBuilder)) {
            return false;
        }
        return this.chronicleMapBuilder.equals(((ChronicleSetBuilder)o).chronicleMapBuilder);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleSetBuilder<E> timeProvider(TimeProvider timeProvider) {
        this.chronicleMapBuilder.timeProvider(timeProvider);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.chronicleMapBuilder.bytesMarshallerFactory(bytesMarshallerFactory);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> objectSerializer(ObjectSerializer objectSerializer) {
        this.chronicleMapBuilder.objectSerializer(objectSerializer);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> keyMarshaller(@NotNull BytesMarshaller<? super E> keyMarshaller) {
        this.chronicleMapBuilder.keyMarshaller((BytesMarshaller)keyMarshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> keyMarshallers(@NotNull BytesWriter<E> keyWriter, @NotNull BytesReader<E> keyReader) {
        this.chronicleMapBuilder.keyMarshallers((BytesWriter)keyWriter, (BytesReader)keyReader);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.chronicleMapBuilder.keySizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> keyDeserializationFactory(@NotNull ObjectFactory<E> keyDeserializationFactory) {
        this.chronicleMapBuilder.keyDeserializationFactory((ObjectFactory)keyDeserializationFactory);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> immutableKeys() {
        this.chronicleMapBuilder.immutableKeys();
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> replication(SingleChronicleHashReplication replication) {
        this.chronicleMapBuilder.replication(replication);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> replication(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        this.chronicleMapBuilder.replication(identifier, tcpTransportAndNetwork);
        return this;
    }

    @Override
    public ChronicleSetBuilder<E> replication(byte identifier) {
        this.chronicleMapBuilder.replication(identifier);
        return this;
    }

    @Override
    public ChronicleHashInstanceBuilder<ChronicleSet<E>> instance() {
        return new SetInstanceBuilder<E>(this.chronicleMapBuilder.instance());
    }

    @Override
    public ChronicleSet<E> create() {
        ChronicleHash map = this.chronicleMapBuilder.create();
        return new SetFromMap(map);
    }

    @Override
    public ChronicleSet<E> createPersistedTo(File file) throws IOException {
        ChronicleHash map = this.chronicleMapBuilder.createPersistedTo(file);
        return new SetFromMap(map);
    }
}

