/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Serializable;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapEventListener<K, V>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <K, V> MapEventListener<K, V> logging(String prefix) {
        return new LoggingMapEventListener(prefix);
    }

    public void onPut(K key, V newValue, @Nullable V replacedValue, boolean replicationEvent, boolean added, boolean hasValueChanged, byte identifier, byte replacedIdentifier, long timeStamp, long replacedTimeStamp) {
    }

    public void onGetFound(K key, V foundValue) {
    }

    public void onRemove(K key, V value, boolean replicationEvent, byte identifier, byte replacedIdentifier, long timestamp, long replacedTimeStamp) {
    }

    public boolean isActive() {
        return true;
    }

    public boolean usesValue() {
        return true;
    }

    private static class LoggingMapEventListener
    extends MapEventListener {
        public static final Logger LOGGER = LoggerFactory.getLogger(LoggingMapEventListener.class);
        private static final long serialVersionUID = 0L;
        private final String prefix;

        private LoggingMapEventListener(String prefix) {
            this.prefix = prefix;
        }

        public void onGetFound(Object key, Object value) {
            LOGGER.info("get {} => {}", new Object[]{this.prefix, key, value});
        }

        public void onPut(Object key, Object value, Object replacedValue, boolean replicationEvent, boolean updateResult, boolean hasValueChanged, byte identifier, byte replacedIdentifier, long timeStamp, long replacedTimeStamp) {
            LOGGER.info("{} put {} => {}", new Object[]{this.prefix, key, value});
        }

        public void onRemove(Object key, Object value, boolean replicationEvent, byte identifier, byte replacedIdentifier, long timestamp, long replacedTimeStamp) {
            LOGGER.info("{} remove {} was {}", new Object[]{this.prefix, key, value});
        }
    }
}

