/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.Nullable;

final class ReaderWithSize<T> {
    private final SizeMarshaller sizeMarshaller;
    private final BytesReader<T> originalReader;
    private final Provider<BytesReader<T>> readerProvider;

    ReaderWithSize(SerializationBuilder<T> serializationBuilder) {
        this.sizeMarshaller = serializationBuilder.sizeMarshaller();
        this.originalReader = serializationBuilder.reader();
        this.readerProvider = Provider.of(this.originalReader.getClass());
    }

    public ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
        return this.readerProvider.getCopies(copies);
    }

    public T read(Bytes in, @Nullable ThreadLocalCopies copies, @Nullable T using) {
        long size = this.sizeMarshaller.readSize(in);
        copies = this.readerProvider.getCopies(copies);
        BytesReader reader = (BytesReader)this.readerProvider.get(copies, this.originalReader);
        return reader.read(in, size, using);
    }

    public T readNullable(Bytes in, @Nullable ThreadLocalCopies copies, T using) {
        if (in.readBoolean()) {
            return null;
        }
        return this.read(in, copies, using);
    }

    public BytesReader<T> readerForLoop(@Nullable ThreadLocalCopies copies) {
        copies = this.readerProvider.getCopies(copies);
        return (BytesReader)this.readerProvider.get(copies, this.originalReader);
    }

    public T readInLoop(Bytes in, BytesReader<T> reader) {
        long size = this.sizeMarshaller.readSize(in);
        return reader.read(in, size);
    }

    public T readNullableInLoop(Bytes in, BytesReader<T> reader) {
        if (in.readBoolean()) {
            return null;
        }
        return this.readInLoop(in, reader);
    }
}

