/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.StatelessClientConfig;
import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.ChronicleMap;

class StatelessMapConfig<K, V>
implements StatelessClientConfig<ChronicleMap<K, V>> {
    private final AbstractChronicleMapBuilder<K, V, ?> mapBuilder;
    private final InetSocketAddress remoteAddress;
    private long timeoutMs = TimeUnit.SECONDS.toMillis(10L);

    StatelessMapConfig(AbstractChronicleMapBuilder<K, V, ?> mapBuilder, InetSocketAddress remoteAddress) {
        this.mapBuilder = mapBuilder;
        this.remoteAddress = remoteAddress;
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public StatelessMapConfig<K, V> timeout(long timeout, TimeUnit units) {
        this.timeoutMs = units.toMillis(timeout);
        return this;
    }

    @Override
    public ChronicleMap<K, V> create() throws IOException {
        return this.mapBuilder.createStatelessMap(this);
    }
}

