/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.util.concurrent.TimeUnit;

public class ThrottlingConfig {
    private static final long DEFAULT_BUCKET_INTERVAL = 100L;
    private static final TimeUnit DEFAULT_BUCKET_INTERVAL_UNIT = TimeUnit.MILLISECONDS;
    private static final ThrottlingConfig NO_THROTTLING = ThrottlingConfig.create(0L, TimeUnit.MILLISECONDS, 100L, DEFAULT_BUCKET_INTERVAL_UNIT);
    private final long throttle;
    private final TimeUnit throttlePerUnit;
    private final long bucketInterval;
    private final TimeUnit bucketIntervalUnit;

    ThrottlingConfig(long throttle, TimeUnit throttlePerUnit, long bucketInterval, TimeUnit bucketIntervalUnit) {
        this.throttle = throttle;
        if (throttlePerUnit == null) {
            throw new NullPointerException("Null throttlePerUnit");
        }
        this.throttlePerUnit = throttlePerUnit;
        this.bucketInterval = bucketInterval;
        if (bucketIntervalUnit == null) {
            throw new NullPointerException("Null bucketIntervalUnit");
        }
        this.bucketIntervalUnit = bucketIntervalUnit;
    }

    public static ThrottlingConfig noThrottling() {
        return NO_THROTTLING;
    }

    public static ThrottlingConfig throttle(long maxBits, TimeUnit perUnit) {
        if (maxBits <= 0L) {
            throw new IllegalArgumentException();
        }
        return ThrottlingConfig.create(maxBits, perUnit, 100L, DEFAULT_BUCKET_INTERVAL_UNIT);
    }

    static void checkMillisecondBucketInterval(ThrottlingConfig config, String replicator) {
        if (config.bucketInterval(TimeUnit.MILLISECONDS) < 1L) {
            throw new IllegalArgumentException("Minimum throttle bucketing interval of 1 millisecond is supported by " + replicator + " replicator");
        }
    }

    static ThrottlingConfig create(long throttle, TimeUnit throttlePerUnit, long throttleBucketInterval, TimeUnit throttleBucketIntervalUnit) {
        return new ThrottlingConfig(throttle, throttlePerUnit, throttleBucketInterval, throttleBucketIntervalUnit);
    }

    public final long throttling(TimeUnit perUnit) {
        return this.throttlePerUnit.convert(this.throttle, perUnit);
    }

    public long bucketInterval(TimeUnit unit) {
        return unit.convert(this.bucketInterval, this.bucketIntervalUnit);
    }

    public ThrottlingConfig bucketInterval(long throttleBucketInterval, TimeUnit unit) {
        if (throttleBucketInterval <= 0L) {
            throw new IllegalArgumentException();
        }
        return ThrottlingConfig.create(this.throttle, this.throttlePerUnit, throttleBucketInterval, unit);
    }

    public String toString() {
        return "ThrottlingConfig{throttle=" + this.throttle + ", throttlePerUnit=" + (Object)((Object)this.throttlePerUnit) + ", bucketInterval=" + this.bucketInterval + ", bucketIntervalUnit=" + (Object)((Object)this.bucketIntervalUnit) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ThrottlingConfig) {
            ThrottlingConfig that = (ThrottlingConfig)o;
            return this.throttle == that.throttle && this.throttlePerUnit.equals((Object)that.throttlePerUnit) && this.bucketInterval == that.bucketInterval && this.bucketIntervalUnit.equals((Object)that.bucketIntervalUnit);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.throttle >>> 32 ^ this.throttle));
        h *= 1000003;
        h ^= this.throttlePerUnit.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.bucketInterval >>> 32 ^ this.bucketInterval));
        h *= 1000003;
        return h ^= this.bucketIntervalUnit.hashCode();
    }
}

