/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.map.KeyValueSerializer;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.Work;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatelessServerConnector<K, V> {
    public static final int TRANSACTION_ID_OFFSET = 5;
    public static final boolean MAP_SUPPORTS_BYTES = Boolean.valueOf(System.getProperty("mapSupportsBytes"));
    private static final Logger LOG = LoggerFactory.getLogger((String)StatelessServerConnector.class.getName());
    private final KeyValueSerializer<K, V> keyValueSerializer;
    private final VanillaChronicleMap<K, ?, ?, V, ?, ?> map;
    private double maxEntrySizeBytes;

    StatelessServerConnector(@NotNull KeyValueSerializer<K, V> keyValueSerializer, @NotNull VanillaChronicleMap<K, ?, ?, V, ?, ?> map, int maxEntrySizeBytes) {
        this.keyValueSerializer = keyValueSerializer;
        this.map = map;
        this.maxEntrySizeBytes = maxEntrySizeBytes;
    }

    Work processStatelessEvent(byte eventId, @NotNull Bytes writer, @NotNull ByteBufferBytes reader) {
        StatelessChronicleMap.EventId event = StatelessChronicleMap.EventId.values()[eventId];
        switch (event) {
            case KEY_SET: {
                return this.keySet((Bytes)reader, writer);
            }
            case VALUES: {
                return this.values((Bytes)reader, writer);
            }
            case ENTRY_SET: {
                return this.entrySet((Bytes)reader, writer);
            }
            case PUT_WITHOUT_ACC: {
                return this.put((Bytes)reader);
            }
            case PUT_ALL_WITHOUT_ACC: {
                return this.putAll((Bytes)reader);
            }
            case REMOVE_WITHOUT_ACC: {
                return this.remove((Bytes)reader);
            }
        }
        long sizeLocation = this.reflectTransactionId((Bytes)reader, writer);
        switch (event) {
            case LONG_SIZE: {
                return this.longSize((Bytes)reader, writer, sizeLocation);
            }
            case IS_EMPTY: {
                return this.isEmpty((Bytes)reader, writer, sizeLocation);
            }
            case CONTAINS_KEY: {
                return this.containsKey((Bytes)reader, writer, sizeLocation);
            }
            case CONTAINS_VALUE: {
                return this.containsValue((Bytes)reader, writer, sizeLocation);
            }
            case GET: {
                return this.get((Bytes)reader, writer, sizeLocation);
            }
            case PUT: {
                return this.put((Bytes)reader, writer, sizeLocation);
            }
            case REMOVE: {
                return this.remove((Bytes)reader, writer, sizeLocation);
            }
            case CLEAR: {
                return this.clear((Bytes)reader, writer, sizeLocation);
            }
            case REPLACE: {
                return this.replace((Bytes)reader, writer, sizeLocation);
            }
            case REPLACE_WITH_OLD_AND_NEW_VALUE: {
                return this.replaceWithOldAndNew((Bytes)reader, writer, sizeLocation);
            }
            case PUT_IF_ABSENT: {
                return this.putIfAbsent((Bytes)reader, writer, sizeLocation);
            }
            case REMOVE_WITH_VALUE: {
                return this.removeWithValue((Bytes)reader, writer, sizeLocation);
            }
            case TO_STRING: {
                return this.toString((Bytes)reader, writer, sizeLocation);
            }
            case PUT_ALL: {
                return this.putAll((Bytes)reader, writer, sizeLocation);
            }
            case HASH_CODE: {
                return this.hashCode((Bytes)reader, writer, sizeLocation);
            }
        }
        throw new IllegalStateException("unsupported event=" + (Object)((Object)event));
    }

    private Work removeWithValue(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.removeWithValue(reader, writer);
        } else {
            boolean result;
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K key = this.readKey(reader, local);
            V readValue = this.readValue(reader, local);
            try {
                result = this.map.remove(key, readValue);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
            writer.writeBoolean(result);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work replaceWithOldAndNew(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.replaceWithOldAndNew(reader, writer);
        } else {
            boolean replaced;
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K key = this.readKey(reader, local);
            V oldValue = this.readValue(reader, local);
            V newValue = this.readValue(reader, local);
            try {
                replaced = this.map.replace(key, oldValue, newValue);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
            writer.writeBoolean(replaced);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work longSize(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeLong(this.map.longSize());
        }
        catch (RuntimeException e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work hashCode(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeInt(this.map.hashCode());
        }
        catch (RuntimeException e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work toString(Bytes reader, Bytes writer, long sizeLocation) {
        String str;
        long remaining = writer.remaining();
        try {
            str = this.map.toString();
        }
        catch (RuntimeException e) {
            return this.sendException(writer, sizeLocation, e);
        }
        assert (remaining > 4L);
        String result = (long)str.length() < remaining ? str : str.substring(0, (int)(remaining - 4L)) + "...";
        writer.writeObject((Object)result);
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work sendException(Bytes writer, long sizeLocation, RuntimeException e) {
        this.writeException(e, writer);
        this.writeSizeAndFlags(sizeLocation, true, writer);
        return null;
    }

    private Work isEmpty(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            writer.writeBoolean(this.map.isEmpty());
        }
        catch (RuntimeException e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work containsKey(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.containsKey(reader, writer);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K k = this.readKey(reader, local);
            try {
                writer.writeBoolean(this.map.containsKey(k));
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work containsValue(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.containsValue(reader, writer);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            V v = this.readValue(reader, local);
            try {
                writer.writeBoolean(this.map.containsValue(v));
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work get(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.get(reader, writer);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K k = this.readKey(reader, local);
            try {
                this.writeValue(this.map.get(k), writer, local);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work put(Bytes reader) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.put(reader);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K k = this.readKey(reader, local);
            V v = this.readValue(reader, local);
            this.map.put(k, v);
        }
        return null;
    }

    private Work put(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.put(reader, writer);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K k = this.readKey(reader, local);
            V v = this.readValue(reader, local);
            try {
                this.writeValue(this.map.put(k, v), writer, local);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work remove(Bytes reader) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.removeWithBytes(reader);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K key = this.readKey(reader, local);
            this.map.remove(key);
        }
        return null;
    }

    private Work remove(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.remove(reader, writer);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K key = this.readKey(reader, local);
            try {
                this.writeValue(this.map.remove(key), writer, local);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work putAll(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.putAll(reader, writer);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            Map<K, V> m = this.readEntries(reader, local);
            try {
                this.map.putAll(m);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work putAll(Bytes reader) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.putAll(reader);
        } else {
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            this.map.putAll(this.readEntries(reader, local));
        }
        return null;
    }

    private Work clear(Bytes reader, Bytes writer, long sizeLocation) {
        try {
            this.map.clear();
        }
        catch (RuntimeException e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work values(Bytes reader, Bytes writer) {
        Collection values;
        final long transactionId = reader.readLong();
        try {
            values = this.map.values();
        }
        catch (RuntimeException e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator iterator = values.iterator();
        final ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        return new Work(){

            @Override
            public boolean doWork(Bytes writer) {
                long sizeLocation = StatelessServerConnector.this.header(writer, transactionId);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)writer.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(writer, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    StatelessServerConnector.this.writeValue(iterator.next(), writer, local);
                }
                StatelessServerConnector.this.writeHeader(writer, sizeLocation, count, false);
                return true;
            }
        };
    }

    private Work keySet(Bytes reader, Bytes writer) {
        Set ks;
        final long transactionId = reader.readLong();
        try {
            ks = this.map.keySet();
        }
        catch (RuntimeException e) {
            return this.sendException(reader, writer, e);
        }
        final ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        final Iterator iterator = ks.iterator();
        return new Work(){

            @Override
            public boolean doWork(Bytes writer) {
                long sizeLocation = StatelessServerConnector.this.header(writer, transactionId);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)writer.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(writer, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Object key = iterator.next();
                    StatelessServerConnector.this.writeKey(key, writer, local);
                }
                StatelessServerConnector.this.writeHeader(writer, sizeLocation, count, false);
                return true;
            }
        };
    }

    private Work entrySet(Bytes reader, Bytes writer) {
        Set<Map.Entry<K, V>> entries;
        final long transactionId = reader.readLong();
        try {
            entries = this.map.entrySet();
        }
        catch (RuntimeException e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator<Map.Entry<K, V>> iterator = entries.iterator();
        final ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        return new Work(){

            @Override
            public boolean doWork(Bytes writer) {
                if ((double)writer.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                    return false;
                }
                long sizeLocation = StatelessServerConnector.this.header(writer, transactionId);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)writer.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(writer, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Map.Entry next = (Map.Entry)iterator.next();
                    StatelessServerConnector.this.writeKey(next.getKey(), writer, local);
                    StatelessServerConnector.this.writeValue(next.getValue(), writer, local);
                }
                StatelessServerConnector.this.writeHeader(writer, sizeLocation, count, false);
                return true;
            }
        };
    }

    private Work putIfAbsent(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.putIfAbsent(reader, writer);
        } else {
            V result;
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K key = this.readKey(reader, local);
            V v = this.readValue(reader, local);
            try {
                result = this.map.putIfAbsent(key, v);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
            this.writeValue(result, writer, local);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private Work replace(Bytes reader, Bytes writer, long sizeLocation) {
        if (MAP_SUPPORTS_BYTES) {
            this.map.replaceKV(reader, writer);
        } else {
            V replaced;
            ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
            K k = this.readKey(reader, local);
            V v = this.readValue(reader, local);
            try {
                replaced = this.map.replace(k, v);
            }
            catch (RuntimeException e) {
                return this.sendException(writer, sizeLocation, e);
            }
            this.writeValue(replaced, writer, local);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private void writeKey(K key, Bytes writer, ThreadLocalCopies local) {
        this.keyValueSerializer.writeKey(key, writer, local);
    }

    private long reflectTransactionId(Bytes reader, Bytes writer) {
        long sizeLocation = writer.position();
        writer.skip(5L);
        long transactionId = reader.readLong();
        writer.writeLong(transactionId);
        return sizeLocation;
    }

    private void writeValue(V value, Bytes writer, ThreadLocalCopies local) {
        this.keyValueSerializer.writeValue(value, writer, local);
    }

    private K readKey(Bytes reader, ThreadLocalCopies local) {
        return this.keyValueSerializer.readKey(reader, local);
    }

    private V readValue(Bytes reader, ThreadLocalCopies local) {
        return this.keyValueSerializer.readValue(reader, local);
    }

    private void writeSizeAndFlags(long locationOfSize, boolean isException, Bytes out) {
        long currentPosition = out.position();
        long size = out.position() - locationOfSize;
        out.writeInt(locationOfSize, (int)size);
        out.writeBoolean(locationOfSize + 4L, isException);
        out.position(currentPosition);
    }

    private void writeException(RuntimeException e, Bytes out) {
        out.writeObject((Object)e);
    }

    private Map<K, V> readEntries(Bytes reader, ThreadLocalCopies local) {
        long numberOfEntries = reader.readStopBit();
        HashMap<K, V> result = new HashMap<K, V>();
        for (long i = 0L; i < numberOfEntries; ++i) {
            K key = this.readKey(reader, local);
            V value = this.readValue(reader, local);
            result.put(key, value);
        }
        return result;
    }

    private Work sendException(Bytes reader, Bytes writer, RuntimeException e) {
        long sizeLocation = this.reflectTransactionId(reader, writer);
        return this.sendException(writer, sizeLocation, e);
    }

    private long header(Bytes writer, long transactionId) {
        long sizeLocation = writer.position();
        writer.skip(5L);
        writer.writeLong(transactionId);
        writer.skip(1L);
        writer.skip(4L);
        return sizeLocation;
    }

    private void writeHeader(Bytes writer, long sizeLocation, int count, boolean hasAnotherChunk) {
        long end = writer.position();
        int size = (int)(end - sizeLocation);
        writer.position(sizeLocation);
        writer.writeInt(size);
        writer.writeBoolean(false);
        writer.skip(8L);
        writer.writeBoolean(hasAnotherChunk);
        writer.writeInt(count);
        writer.position(end);
    }
}

