/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ThrottlingConfig;
import net.openhft.chronicle.map.CloseablesManager;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.thread.NamedThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractChannelReplicator
implements Closeable {
    public static final int BITS_IN_A_BYTE = 8;
    public static final int SIZE_OF_SIZE = 4;
    public static final int SIZE_OF_TRANSACTIONID = 8;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractChannelReplicator.class);
    final Selector selector;
    final CloseablesManager closeables = new CloseablesManager();
    private final ExecutorService executorService;
    private final Queue<Runnable> pendingRegistrations = new ConcurrentLinkedQueue<Runnable>();
    @Nullable
    private final Throttler throttler;
    volatile boolean isClosed = false;

    AbstractChannelReplicator(String name, ThrottlingConfig throttlingConfig, int maxEntrySizeBytes) throws IOException {
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(name, Boolean.valueOf(true)));
        this.selector = AbstractChannelReplicator.openSelector(this.closeables);
        this.throttler = throttlingConfig.throttling(TimeUnit.DAYS) > 0L ? new Throttler(this.selector, throttlingConfig.bucketInterval(TimeUnit.MILLISECONDS), maxEntrySizeBytes, throttlingConfig.throttling(TimeUnit.DAYS)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Selector openSelector(CloseablesManager closeables) throws IOException {
        Selector result = null;
        try {
            result = Selector.open();
        }
        finally {
            if (result != null) {
                closeables.add(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SocketChannel openSocketChannel(CloseablesManager closeables) throws IOException {
        SocketChannel result = null;
        try {
            result = SocketChannel.open();
        }
        finally {
            if (result != null) {
                try {
                    closeables.add(result);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return result;
    }

    void addPendingRegistration(Runnable registration) {
        this.pendingRegistrations.add(registration);
    }

    void registerPendingRegistrations() throws ClosedChannelException {
        Runnable runnable = this.pendingRegistrations.poll();
        while (runnable != null) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.info("", (Throwable)e);
            }
            runnable = this.pendingRegistrations.poll();
        }
    }

    abstract void process() throws IOException;

    final void start() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractChannelReplicator.this.process();
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.closeables.closeQuietly();
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("", (Throwable)e);
        }
    }

    void closeEarlyAndQuietly(SelectableChannel channel) {
        if (this.throttler != null) {
            this.throttler.remove(channel);
        }
        this.closeables.closeQuietly(channel);
    }

    void checkThrottleInterval() throws ClosedChannelException {
        if (this.throttler != null) {
            this.throttler.checkThrottleInterval();
        }
    }

    void contemplateThrottleWrites(int bytesJustWritten) throws ClosedChannelException {
        if (this.throttler != null) {
            this.throttler.contemplateThrottleWrites(bytesJustWritten);
        }
    }

    void throttle(SelectableChannel channel) {
        if (this.throttler != null) {
            this.throttler.add(channel);
        }
    }

    abstract class AbstractConnector {
        private final String name;
        private int connectionAttempts = 0;
        private volatile SelectableChannel socketChannel;

        public AbstractConnector(String name) {
            this.name = name;
        }

        abstract SelectableChannel doConnect() throws IOException, InterruptedException;

        public final void connectLater() {
            if (this.socketChannel != null) {
                AbstractChannelReplicator.this.closeables.closeQuietly(this.socketChannel);
                this.socketChannel = null;
            }
            long reconnectionInterval = this.connectionAttempts * 100;
            if (this.connectionAttempts < 5) {
                ++this.connectionAttempts;
            }
            this.doConnect(reconnectionInterval);
        }

        public void connect() {
            this.doConnect(0L);
        }

        private void doConnect(final long reconnectionInterval) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SelectableChannel socketChannel = null;
                    try {
                        if (reconnectionInterval > 0L) {
                            Thread.sleep(reconnectionInterval);
                        }
                        socketChannel = AbstractConnector.this.doConnect();
                        try {
                            AbstractChannelReplicator.this.closeables.add(socketChannel);
                        }
                        catch (IllegalStateException e) {
                            this.closeQuietly(socketChannel);
                            return;
                        }
                        AbstractConnector.this.socketChannel = socketChannel;
                    }
                    catch (Exception e) {
                        this.closeQuietly(socketChannel);
                        LOG.debug("", (Throwable)e);
                    }
                }

                private void closeQuietly(SelectableChannel socketChannel) {
                    if (socketChannel == null) {
                        return;
                    }
                    try {
                        socketChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            thread.setName(this.name);
            thread.setDaemon(true);
            thread.start();
        }

        public void setSuccessfullyConnected() {
            this.connectionAttempts = 0;
        }
    }

    static class EntryCallback
    extends Replica.EntryCallback {
        private final Replica.EntryExternalizable externalizable;
        private final ByteBufferBytes in;

        EntryCallback(@NotNull Replica.EntryExternalizable externalizable, @NotNull ByteBufferBytes in) {
            this.externalizable = externalizable;
            this.in = in;
        }

        @Override
        public boolean onEntry(Bytes entry, int chronicleId) {
            long pos0 = this.in.position();
            this.in.writeByte(StatelessChronicleMap.EventId.STATEFUL_UPDATE.ordinal());
            long sizeLocation = this.in.position();
            this.in.skip(4L);
            long start = this.in.position();
            this.externalizable.writeExternalEntry(entry, (Bytes)this.in, chronicleId);
            if (this.in.position() == start) {
                this.in.position(pos0);
                return false;
            }
            long entrySize = (int)(this.in.position() - start);
            if (entrySize > Integer.MAX_VALUE) {
                throw new IllegalStateException("entry too large, the entry size=" + entrySize + ", " + "entries are limited to a size of " + Integer.MAX_VALUE);
            }
            int entrySize1 = (int)entrySize;
            if (LOG.isDebugEnabled()) {
                LOG.debug("sending entry of entrySize=" + entrySize1);
            }
            this.in.writeInt(sizeLocation, entrySize1);
            return true;
        }
    }

    static class Details {
        private final InetSocketAddress address;
        private final byte localIdentifier;

        Details(@NotNull InetSocketAddress address, byte localIdentifier) {
            this.address = address;
            this.localIdentifier = localIdentifier;
        }

        public InetSocketAddress address() {
            return this.address;
        }

        public byte localIdentifier() {
            return this.localIdentifier;
        }

        public String toString() {
            return "Details{address=" + this.address + ", localIdentifier=" + this.localIdentifier + '}';
        }
    }

    static class Throttler {
        private final Selector selector;
        private final Set<SelectableChannel> channels = new CopyOnWriteArraySet<SelectableChannel>();
        private final long throttleInterval;
        private final long maxBytesInInterval;
        private long lastTime = System.currentTimeMillis();
        private long bytesWritten;

        Throttler(@NotNull Selector selector, long throttleIntervalInMillis, long serializedEntrySize, long bitsPerDay) {
            this.selector = selector;
            this.throttleInterval = throttleIntervalInMillis;
            double bytesPerMs = (double)bitsPerDay / (double)TimeUnit.DAYS.toMillis(1L) / 8.0;
            this.maxBytesInInterval = Math.round(bytesPerMs * (double)this.throttleInterval) - serializedEntrySize;
        }

        public void add(SelectableChannel selectableChannel) {
            this.channels.add(selectableChannel);
        }

        public void remove(SelectableChannel socketChannel) {
            this.channels.remove(socketChannel);
        }

        public void checkThrottleInterval() throws ClosedChannelException {
            long time = System.currentTimeMillis();
            if (this.lastTime + this.throttleInterval >= time) {
                return;
            }
            this.lastTime = time;
            this.bytesWritten = 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Restoring OP_WRITE on all channels");
            }
            for (SelectableChannel selectableChannel : this.channels) {
                SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
                if (selectionKey == null) continue;
                selectionKey.interestOps(selectionKey.interestOps() | 4);
            }
        }

        public void contemplateThrottleWrites(int bytesJustWritten) throws ClosedChannelException {
            this.bytesWritten += (long)bytesJustWritten;
            if (this.bytesWritten > this.maxBytesInInterval) {
                for (SelectableChannel channel : this.channels) {
                    SelectionKey selectionKey = channel.keyFor(this.selector);
                    if (selectionKey != null) {
                        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Throttling UDP writes");
                }
            }
        }
    }
}

