/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import com.sun.jdi.connect.spi.ClosedConnectionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.hash.StatelessBuilder;
import net.openhft.chronicle.hash.exceptions.IORuntimeException;
import net.openhft.chronicle.hash.exceptions.TimeoutRuntimeException;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.CloseablesManager;
import net.openhft.chronicle.map.KeyValueSerializer;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatelessChronicleMap<K, V>
implements ChronicleMap<K, V>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(StatelessChronicleMap.class);
    public static final byte STATELESS_CLIENT_IDENTIFIER = -127;
    private final byte[] connectionByte = new byte[1];
    private final ByteBuffer connectionOutBuffer = ByteBuffer.wrap(this.connectionByte);
    private ByteBuffer buffer;
    private ByteBufferBytes bytes;
    private final KeyValueSerializer<K, V> keyValueSerializer;
    private volatile SocketChannel clientChannel;
    private CloseablesManager closeables;
    private final StatelessBuilder builder;
    private int maxEntrySize;
    private final Class<K> kClass;
    private final Class<V> vClass;
    private long transactionID;

    StatelessChronicleMap(KeyValueSerializer<K, V> keyValueSerializer, StatelessBuilder builder, int maxEntrySize, Class<K> kClass, Class<V> vClass) throws IOException {
        this.keyValueSerializer = keyValueSerializer;
        this.builder = builder;
        this.maxEntrySize = maxEntrySize;
        this.kClass = kClass;
        this.vClass = vClass;
        this.attemptConnect(builder.remoteAddress());
        this.buffer = ByteBuffer.allocateDirect(maxEntrySize).order(ByteOrder.nativeOrder());
        this.bytes = new ByteBufferBytes(this.buffer.slice());
    }

    private SocketChannel lazyConnect(long timeoutMs, InetSocketAddress remoteAddress) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("attempting to connect to " + remoteAddress);
        }
        SocketChannel result = null;
        long timeoutAt = System.currentTimeMillis() + timeoutMs;
        while (true) {
            this.checkTimeout(timeoutAt);
            this.closeExisting();
            try {
                result = AbstractChannelReplicator.openSocketChannel(this.closeables);
                result.connect(this.builder.remoteAddress());
                this.doHandShaking(result);
            }
            catch (IOException e) {
                this.closeables.closeQuietly();
                continue;
            }
            catch (Exception e) {
                this.closeables.closeQuietly();
                throw e;
            }
            break;
        }
        return result;
    }

    private void attemptConnect(InetSocketAddress remoteAddress) throws IOException {
        this.closeExisting();
        try {
            this.clientChannel = AbstractChannelReplicator.openSocketChannel(this.closeables);
            this.clientChannel.connect(remoteAddress);
            this.doHandShaking(this.clientChannel);
        }
        catch (IOException e) {
            this.closeables.closeQuietly();
        }
    }

    private void closeExisting() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = new CloseablesManager();
    }

    private void doHandShaking(@NotNull SocketChannel clientChannel) throws IOException {
        this.connectionByte[0] = -127;
        this.connectionOutBuffer.clear();
        long timeoutTime = System.currentTimeMillis() + this.builder.timeoutMs();
        while (this.connectionOutBuffer.hasRemaining()) {
            clientChannel.write(this.connectionOutBuffer);
            this.checkTimeout(timeoutTime);
        }
        this.connectionOutBuffer.clear();
        while (this.connectionOutBuffer.position() <= 0) {
            clientChannel.read(this.connectionOutBuffer);
            this.checkTimeout(timeoutTime);
        }
        byte remoteIdentifier = this.connectionByte[0];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attached to a map with a remote identifier=" + remoteIdentifier);
        }
    }

    @Override
    public File file() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = null;
    }

    private long nextUniqueTransaction(long time) {
        this.transactionID = time == this.transactionID ? time + 1L : time;
        return this.transactionID;
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        long sizeLocation = this.writeEvent(EventId.PUT_IF_ABSENT);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        this.writeKey(key, local);
        this.writeValue(value, local);
        return this.readKey(sizeLocation, local);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        long sizeLocation = this.writeEvent(EventId.REMOVE_WITH_VALUE);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        this.writeKey(key, local);
        this.writeValue(value, local);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        long sizeLocation = this.writeEvent(EventId.REPLACE_WITH_OLD_AND_NEW_VALUE);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        this.writeKey(key, local);
        this.writeValue(oldValue, local);
        this.writeValue(newValue, local);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    @Override
    public synchronized V replace(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        long sizeLocation = this.writeEvent(EventId.REPLACE);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        this.writeKey(key, local);
        this.writeValue(value, local);
        return this.readKey(sizeLocation, local);
    }

    @Override
    public synchronized int size() {
        return (int)this.longSize();
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass().isAssignableFrom(Map.class)) {
            return false;
        }
        Map that = (Map)object;
        int size = this.size();
        if (that.size() != size) {
            return false;
        }
        Set<Map.Entry<K, V>> entries = this.entrySet();
        return that.entrySet().equals(entries);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        long sizeLocation = this.writeEvent(EventId.PUT_ALL);
        this.writeEntries(map);
        this.blockingFetch(sizeLocation);
    }

    @Override
    public synchronized int hashCode() {
        return this.blockingFetch(this.writeEvent(EventId.HASH_CODE)).readInt();
    }

    public synchronized String toString() {
        return (String)this.blockingFetch(this.writeEvent(EventId.TO_STRING)).readObject(String.class);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.blockingFetch(this.writeEvent(EventId.IS_EMPTY)).readBoolean();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        long sizeLocation = this.writeEvent(EventId.CONTAINS_KEY);
        this.writeKey(key);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        long sizeLocation = this.writeEvent(EventId.CONTAINS_VALUE);
        this.writeValue(value);
        return this.blockingFetch(sizeLocation).readBoolean();
    }

    @Override
    public synchronized long longSize() {
        return this.blockingFetch(this.writeEvent(EventId.LONG_SIZE)).readLong();
    }

    @Override
    public synchronized V get(Object key) {
        long sizeLocation = this.writeEvent(EventId.GET);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        this.writeKey(key, local);
        return this.readKey(sizeLocation, local);
    }

    @Override
    public synchronized V getUsing(K key, V usingValue) {
        throw new UnsupportedOperationException("getUsing is not supported for stateless clients");
    }

    @Override
    public synchronized V acquireUsing(K key, V usingValue) {
        throw new UnsupportedOperationException("getUsing is not supported for stateless clients");
    }

    @Override
    public synchronized V put(K key, V value) {
        long sizeLocation = this.writeEvent(EventId.PUT);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        this.writeKey(key, local);
        this.writeValue(value, local);
        return this.readKey(sizeLocation, local);
    }

    @Override
    public synchronized V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        long sizeLocation = this.writeEvent(EventId.REMOVE);
        this.writeKey(key);
        return this.readKey(sizeLocation);
    }

    private void writeEntries(Map<? extends K, ? extends V> map) {
        int numberOfEntries = map.size();
        int numberOfEntriesReadSoFar = 0;
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        this.bytes.writeStopBit((long)numberOfEntries);
        assert (this.bytes.limit() == this.bytes.capacity());
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.resizeIfRequired(numberOfEntries, ++numberOfEntriesReadSoFar);
            long start = this.bytes.position();
            K key = e.getKey();
            Class<?> keyClass = key.getClass();
            if (!this.kClass.isAssignableFrom(keyClass)) {
                throw new ClassCastException("key=" + key + " is of type=" + keyClass + " " + "and should" + " be of type=" + this.kClass);
            }
            this.writeKey(key, local);
            V value = e.getValue();
            Class<?> valueClass = value.getClass();
            if (!this.vClass.isAssignableFrom(valueClass)) {
                throw new ClassCastException("value=" + value + " is of type=" + valueClass + " and " + "should  be of type=" + this.vClass);
            }
            this.writeValue(value, local);
            int len = (int)(this.bytes.position() - start);
            if (len <= this.maxEntrySize) continue;
            this.maxEntrySize = len;
        }
    }

    private void resizeIfRequired(int numberOfEntries, int numberOfEntriesReadSoFar) {
        long remaining = this.bytes.remaining();
        if (remaining < (long)this.maxEntrySize) {
            long estimatedRequiredSize = this.estimateSize(numberOfEntries, numberOfEntriesReadSoFar);
            this.resizeBuffer(estimatedRequiredSize + (long)this.maxEntrySize);
        }
    }

    private long estimateSize(int numberOfEntries, int numberOfEntriesReadSoFar) {
        double percentageComplete = (double)numberOfEntriesReadSoFar / (double)numberOfEntries;
        return (long)((double)this.bytes.position() / percentageComplete);
    }

    void resizeBuffer(long size) {
        if (size < (long)this.buffer.capacity()) {
            throw new IllegalStateException("it not possible to resize the buffer smaller");
        }
        assert (size < Integer.MAX_VALUE);
        ByteBuffer result = ByteBuffer.allocateDirect((int)size).order(ByteOrder.nativeOrder());
        int bufferPosition = this.buffer.position();
        int bufferLimit = this.buffer.limit();
        long bytesPosition = this.bytes.position();
        this.bytes = new ByteBufferBytes(result.slice());
        this.buffer.position(0);
        this.buffer.limit((int)bytesPosition);
        int i = 0;
        while ((long)i < bytesPosition) {
            result.put(this.buffer.get());
            ++i;
        }
        this.buffer = result;
        this.buffer.limit(bufferLimit);
        this.buffer.position(bufferPosition);
        assert ((long)this.buffer.capacity() == this.bytes.capacity());
        this.bytes.limit(this.bytes.capacity());
        this.bytes.position(bytesPosition);
        assert ((long)this.buffer.capacity() == size);
        assert ((long)this.buffer.capacity() == this.bytes.capacity());
        assert (this.bytes.limit() == this.bytes.capacity());
    }

    @Override
    public synchronized void clear() {
        this.blockingFetch(this.writeEvent(EventId.CLEAR));
    }

    @Override
    @NotNull
    public synchronized Collection<V> values() {
        long sizeLocation = this.writeEvent(EventId.VALUES);
        long startTime = System.currentTimeMillis();
        long transactionId = this.nextUniqueTransaction(startTime);
        long timeoutTime = System.currentTimeMillis() + this.builder.timeoutMs();
        Bytes in = this.blockingFetch0(sizeLocation, transactionId, startTime);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        ArrayList<V> result = new ArrayList<V>();
        while (true) {
            boolean hasMoreEntries = in.readBoolean();
            long size = in.readInt();
            int i = 0;
            while ((long)i < size) {
                result.add(this.keyValueSerializer.readValue(in, local));
                ++i;
            }
            if (!hasMoreEntries) break;
            this.compact(in);
            in = this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
        return result;
    }

    @Override
    @NotNull
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        long sizeLocation = this.writeEvent(EventId.ENTRY_SET);
        long startTime = System.currentTimeMillis();
        long transactionId = this.nextUniqueTransaction(startTime);
        long timeoutTime = System.currentTimeMillis() + this.builder.timeoutMs();
        Bytes in = this.blockingFetch0(sizeLocation, transactionId, startTime);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        HashMap<K, V> result = new HashMap<K, V>();
        while (true) {
            boolean hasMoreEntries = in.readBoolean();
            long size = in.readInt();
            int i = 0;
            while ((long)i < size) {
                K k = this.keyValueSerializer.readKey(in, local);
                V v = this.keyValueSerializer.readValue(in, local);
                result.put(k, v);
                ++i;
            }
            if (!hasMoreEntries) break;
            this.compact(in);
            in = this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
        return result.entrySet();
    }

    private void compact(Bytes in) {
        if (in.remaining() == 0L) {
            this.bytes.clear();
            this.bytes.buffer().clear();
        } else {
            this.buffer.compact();
        }
    }

    @Override
    @NotNull
    public synchronized Set<K> keySet() {
        long sizeLocation = this.writeEvent(EventId.KEY_SET);
        long startTime = System.currentTimeMillis();
        long transactionId = this.nextUniqueTransaction(startTime);
        long timeoutTime = System.currentTimeMillis() + this.builder.timeoutMs();
        Bytes in = this.blockingFetch0(sizeLocation, transactionId, startTime);
        ThreadLocalCopies local = this.keyValueSerializer.threadLocalCopies();
        HashSet<K> result = new HashSet<K>();
        while (true) {
            boolean hasMoreEntries = in.readBoolean();
            long size = in.readInt();
            int i = 0;
            while ((long)i < size) {
                result.add(this.keyValueSerializer.readKey(in, local));
                ++i;
            }
            if (!hasMoreEntries) break;
            this.compact(in);
            in = this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
        return result;
    }

    private long writeEvent(EventId event) {
        this.buffer.clear();
        this.bytes.clear();
        this.bytes.write((int)((byte)event.ordinal()));
        long sizeLocation = this.markSizeLocation();
        return sizeLocation;
    }

    private Bytes blockingFetch(long sizeLocation) {
        try {
            long startTime = System.currentTimeMillis();
            return this.blockingFetchThrowable(sizeLocation, this.builder.timeoutMs(), this.nextUniqueTransaction(startTime), startTime);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Bytes blockingFetch0(long sizeLocation, long transactionId, long startTime) {
        try {
            return this.blockingFetchThrowable(sizeLocation, this.builder.timeoutMs(), transactionId, startTime);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Bytes blockingFetchThrowable(long sizeLocation, long timeOutMs, long transactionId, long startTime) throws IOException {
        long timeoutTime = startTime + timeOutMs;
        while (true) {
            if (this.clientChannel == null) {
                this.clientChannel = this.lazyConnect(this.builder.timeoutMs(), this.builder.remoteAddress());
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sending data with transactionId=" + transactionId);
                }
                this.writeSizeAndTransactionIdAt(sizeLocation, transactionId);
                this.send(this.bytes, timeoutTime);
                this.bytes.clear();
                this.bytes.buffer().clear();
                return this.blockingFetch(timeoutTime, transactionId);
            }
            catch (ClosedConnectionException | ClosedChannelException e) {
                this.checkTimeout(timeoutTime);
                this.clientChannel = this.lazyConnect(this.builder.timeoutMs(), this.builder.remoteAddress());
                continue;
            }
            break;
        }
    }

    private Bytes blockingFetchReadOnly(long timeoutTime, long transactionId) {
        try {
            return this.blockingFetch(timeoutTime, transactionId);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Bytes blockingFetch(long timeoutTime, long transactionId) throws IOException {
        int size = this.receive(4, timeoutTime).readInt();
        int requiredSize = size + 4;
        if (this.bytes.capacity() < (long)requiredSize) {
            this.bytes = new ByteBufferBytes(ByteBuffer.allocateDirect(requiredSize));
        }
        this.receive(size, timeoutTime);
        boolean isException = this.bytes.readBoolean();
        long inTransactionId = this.bytes.readLong();
        if (inTransactionId != transactionId) {
            throw new IllegalStateException("the received transaction-id=" + inTransactionId + ", does not match the expected transaction-id=" + transactionId);
        }
        if (isException) {
            throw (RuntimeException)this.bytes.readObject();
        }
        return this.bytes;
    }

    private ByteBufferBytes receive(int requiredNumberOfBytes, long timeoutTime) throws IOException {
        while (this.bytes.buffer().position() < requiredNumberOfBytes) {
            this.clientChannel.read(this.bytes.buffer());
            this.checkTimeout(timeoutTime);
        }
        this.bytes.limit((long)this.bytes.buffer().position());
        return this.bytes;
    }

    private void send(ByteBufferBytes out, long timeoutTime) throws IOException {
        this.buffer.limit((int)out.position());
        this.buffer.position(0);
        while (this.buffer.remaining() > 0) {
            this.clientChannel.write(this.buffer);
            this.checkTimeout(timeoutTime);
        }
        out.clear();
        this.buffer.clear();
    }

    private void checkTimeout(long timeoutTime) {
        if (timeoutTime < System.currentTimeMillis()) {
            throw new TimeoutRuntimeException();
        }
    }

    private void writeSizeAndTransactionIdAt(long locationOfSize, long transactionId) {
        long size = this.bytes.position() - locationOfSize;
        long pos = this.bytes.position();
        this.bytes.position(locationOfSize);
        this.bytes.writeInt((int)size - 4);
        this.bytes.writeLong(transactionId);
        this.bytes.position(pos);
    }

    private long markSizeLocation() {
        long position = this.bytes.position();
        this.bytes.skip(4L);
        this.bytes.skip(8L);
        return position;
    }

    private void writeKey(K key) {
        try {
            this.keyValueSerializer.writeKey(key, (Bytes)this.bytes);
        }
        catch (IllegalArgumentException e) {
            this.resizeBuffer(this.bytes.capacity() + (long)this.maxEntrySize);
        }
    }

    private void writeKey(K key, ThreadLocalCopies local) {
        try {
            this.keyValueSerializer.writeKey(key, (Bytes)this.bytes, local);
        }
        catch (IllegalArgumentException e) {
            this.resizeBuffer(this.bytes.capacity() + (long)this.maxEntrySize);
        }
    }

    private V readKey(long sizeLocation) {
        return this.keyValueSerializer.readValue(this.blockingFetch(sizeLocation), null);
    }

    private V readKey(long sizeLocation, ThreadLocalCopies local) {
        return this.keyValueSerializer.readValue(this.blockingFetch(sizeLocation), local);
    }

    private void writeValue(V value) {
        try {
            this.keyValueSerializer.writeValue(value, (Bytes)this.bytes, null);
        }
        catch (IllegalArgumentException e) {
            this.resizeBuffer(this.bytes.capacity() + (long)this.maxEntrySize);
        }
    }

    private void writeValue(V value, ThreadLocalCopies local) {
        try {
            this.keyValueSerializer.writeValue(value, (Bytes)this.bytes, local);
        }
        catch (IllegalArgumentException e) {
            this.resizeBuffer(this.bytes.capacity() + (long)this.maxEntrySize);
        }
    }

    class Entry
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K k1, V v) {
            this.value = v;
            this.key = k1;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            StatelessChronicleMap.this.put(this.getKey(), newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    static enum EventId {
        HEARTBEAT,
        STATEFUL_UPDATE,
        LONG_SIZE,
        SIZE,
        IS_EMPTY,
        CONTAINS_KEY,
        CONTAINS_VALUE,
        GET,
        PUT,
        REMOVE,
        CLEAR,
        KEY_SET,
        VALUES,
        ENTRY_SET,
        REPLACE,
        REPLACE_WITH_OLD_AND_NEW_VALUE,
        PUT_IF_ABSENT,
        REMOVE_WITH_VALUE,
        TO_STRING,
        PUT_ALL,
        HASH_CODE;

    }
}

