/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.PrepareValueBytes;
import net.openhft.chronicle.map.ZeroOutValueBytes;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import org.jetbrains.annotations.NotNull;

public final class OffHeapUpdatableChronicleMapBuilder<K, V>
extends AbstractChronicleMapBuilder<K, V, OffHeapUpdatableChronicleMapBuilder<K, V>> {
    public static <K, V> OffHeapUpdatableChronicleMapBuilder<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        if (!Byteable.class.isAssignableFrom(valueClass)) {
            if (!valueClass.isInterface()) {
                throw new IllegalArgumentException("Value class should be either Byteable subclass or interface,allowing direct Byteable implementation generation");
            }
            valueClass = DataValueClasses.directClassFor(valueClass);
        }
        return new OffHeapUpdatableChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    OffHeapUpdatableChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        super(keyClass, valueClass);
        this.prepareValueBytesOnAcquire((PrepareValueBytes)new ZeroOutValueBytes(this.valueSize()));
    }

    @Override
    OffHeapUpdatableChronicleMapBuilder<K, V> self() {
        return this;
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> entrySize(int entrySize) {
        return (OffHeapUpdatableChronicleMapBuilder)super.entrySize(entrySize);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        return (OffHeapUpdatableChronicleMapBuilder)super.entryAndValueAlignment(alignment);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> defaultValue(V defaultValue) {
        return (OffHeapUpdatableChronicleMapBuilder)super.defaultValue(defaultValue);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        return (OffHeapUpdatableChronicleMapBuilder)super.defaultValueProvider(defaultValueProvider);
    }

    @Override
    public OffHeapUpdatableChronicleMapBuilder<K, V> prepareValueBytesOnAcquire(@NotNull PrepareValueBytes<K> prepareValueBytes) {
        return (OffHeapUpdatableChronicleMapBuilder)super.prepareValueBytesOnAcquire(prepareValueBytes);
    }
}

