/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ReplicationConfig;
import net.openhft.chronicle.hash.ThrottlingConfig;
import net.openhft.chronicle.map.IdentifierListener;
import org.jetbrains.annotations.NotNull;

public class TcpReplicationConfig
implements ReplicationConfig {
    private static final int DEFAULT_PACKET_SIZE = 8192;
    private static final long DEFAULT_HEART_BEAT_INTERVAL = 20L;
    private static final TimeUnit DEFAULT_HEART_BEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    private int serverPort = 8192;
    private Set<InetSocketAddress> endpoints;
    private int packetSize = 8192;
    private boolean autoReconnectedUponDroppedConnection = true;
    private ThrottlingConfig throttlingConfig = ThrottlingConfig.noThrottling();
    private long heartBeatInterval = 20L;
    private TimeUnit heartBeatIntervalUnit = DEFAULT_HEART_BEAT_INTERVAL_UNIT;
    public IdentifierListener identifierListener;

    TcpReplicationConfig() {
    }

    public IdentifierListener identifierListener() {
        return this.identifierListener;
    }

    public TcpReplicationConfig nonUniqueIdentifierListener(@NotNull IdentifierListener identifierListener) {
        this.identifierListener = identifierListener;
        return this;
    }

    public boolean autoReconnectedUponDroppedConnection() {
        return this.autoReconnectedUponDroppedConnection;
    }

    public TcpReplicationConfig autoReconnectedUponDroppedConnection(boolean autoReconnectedUponDroppedConnection) {
        this.autoReconnectedUponDroppedConnection = autoReconnectedUponDroppedConnection;
        return this;
    }

    public ThrottlingConfig throttlingConfig() {
        return this.throttlingConfig;
    }

    public TcpReplicationConfig throttlingConfig(ThrottlingConfig throttlingConfig) {
        this.throttlingConfig = throttlingConfig;
        return this;
    }

    public long heartBeatInterval(TimeUnit unit) {
        return unit.convert(this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public int serverPort() {
        return this.serverPort;
    }

    public TcpReplicationConfig serverPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public Set<InetSocketAddress> endpoints() {
        return this.endpoints;
    }

    public TcpReplicationConfig endpoints(Set<InetSocketAddress> endpoints) {
        for (InetSocketAddress endpoint : endpoints) {
            if (endpoint.getPort() != this.serverPort || !"localhost".equals(endpoint.getHostName())) continue;
            throw new IllegalArgumentException("endpoint=" + endpoint + " can not point to the same port as the server");
        }
        this.endpoints = endpoints;
        return this;
    }

    public int packetSize() {
        return this.packetSize;
    }

    public static TcpReplicationConfig of(int serverPort, InetSocketAddress ... endpoints) {
        return TcpReplicationConfig.of(serverPort, Arrays.asList(endpoints));
    }

    public static TcpReplicationConfig of(int serverPort, Collection<InetSocketAddress> endpoints) {
        for (InetSocketAddress endpoint : endpoints) {
            if (endpoint.getPort() != serverPort || !"localhost".equals(endpoint.getHostName())) continue;
            throw new IllegalArgumentException("endpoint=" + endpoint + " can not point to the same port as the server");
        }
        TcpReplicationConfig tcpReplicationConfig = new TcpReplicationConfig();
        tcpReplicationConfig.serverPort(serverPort);
        tcpReplicationConfig.endpoints = Collections.unmodifiableSet(new HashSet<InetSocketAddress>(endpoints));
        return tcpReplicationConfig;
    }

    public TcpReplicationConfig packetSize(int packetSize) {
        if (packetSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.packetSize = packetSize;
        return this;
    }

    public TcpReplicationConfig throttlingConfig(long heartBeatInterval, TimeUnit heartBeatIntervalUnit) {
        this.heartBeatInterval = heartBeatInterval;
        this.heartBeatIntervalUnit = heartBeatIntervalUnit;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpReplicationConfig that = (TcpReplicationConfig)o;
        if (this.autoReconnectedUponDroppedConnection != that.autoReconnectedUponDroppedConnection) {
            return false;
        }
        if (this.heartBeatInterval != that.heartBeatInterval) {
            return false;
        }
        if (this.packetSize != that.packetSize) {
            return false;
        }
        if (this.serverPort != that.serverPort) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.heartBeatIntervalUnit != that.heartBeatIntervalUnit) {
            return false;
        }
        return !(this.throttlingConfig != null ? !this.throttlingConfig.equals(that.throttlingConfig) : that.throttlingConfig != null);
    }

    public int hashCode() {
        int result = this.serverPort;
        result = 31 * result + (this.endpoints != null ? this.endpoints.hashCode() : 0);
        result = 31 * result + this.packetSize;
        result = 31 * result + (this.autoReconnectedUponDroppedConnection ? 1 : 0);
        result = 31 * result + (this.throttlingConfig != null ? this.throttlingConfig.hashCode() : 0);
        result = 31 * result + (int)(this.heartBeatInterval ^ this.heartBeatInterval >>> 32);
        result = 31 * result + (this.heartBeatIntervalUnit != null ? this.heartBeatIntervalUnit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TcpReplicationConfig{serverPort=" + this.serverPort + ", endpoints=" + this.endpoints + ", packetSize=" + this.packetSize + ", autoReconnectedUponDroppedConnection=" + this.autoReconnectedUponDroppedConnection + ", throttlingConfig=" + this.throttlingConfig + ", heartBeatInterval=" + this.heartBeatInterval + ", heartBeatIntervalUnit=" + (Object)((Object)this.heartBeatIntervalUnit) + '}';
    }

    public TcpReplicationConfig heartBeatInterval(long time, TimeUnit unit) {
        this.heartBeatInterval = time;
        this.heartBeatIntervalUnit = unit;
        return this;
    }
}

