/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.serialization;

import java.nio.ByteOrder;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import sun.misc.Unsafe;

public final class Hasher {
    private static final long LONG_LEVEL_PRIME_MULTIPLE = 1011001110001111L;
    private static final int SHORT_LEVEL_PRIME_MULTIPLE = 101111;
    private static final long BYTE_LEVEL_PRIME_MULTIPLE = 2111L;
    private static final int INT_HASH_LOW_SHORT_MULTIPLE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 101111 : 1;
    private static final int INT_HASH_HIGH_SHORT_MULTIPLE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 101111;

    public static long hash(Bytes bytes) {
        return Hasher.hash(bytes, bytes.position(), bytes.limit());
    }

    public static long hash(Bytes bytes, long offset, long limit) {
        long i;
        long h = 0L;
        for (i = offset; i < limit - 7L; i += 8L) {
            h = 1011001110001111L * h + bytes.readLong(i);
        }
        while (i < limit - 1L) {
            h = 101111L * h + (long)bytes.readShort(i);
            i += 2L;
        }
        if (i < limit) {
            h = 2111L * h + (long)bytes.readByte(i);
        }
        return Hasher.hash(h);
    }

    public static long hash(Object array, int length) {
        long i;
        Unsafe unsafe = NativeBytes.UNSAFE;
        long base = unsafe.arrayBaseOffset(array.getClass());
        long scale = unsafe.arrayIndexScale(array.getClass());
        long h = 0L;
        long limit = (long)length * scale;
        for (i = 0L; i < limit - 7L; i += 8L) {
            h = 1011001110001111L * h + unsafe.getLong(array, base + i);
        }
        while (i < limit - 1L) {
            h = 101111L * h + (long)unsafe.getShort(array, base + i);
            i += 2L;
        }
        if (i < limit) {
            h = 2111L * h + (long)unsafe.getByte(array, base + i);
        }
        return Hasher.hash(h);
    }

    public static long hash(int value) {
        return Hasher.hash((long)((short)(value >>> 16) * INT_HASH_HIGH_SHORT_MULTIPLE) + (long)((short)value * INT_HASH_LOW_SHORT_MULTIPLE));
    }

    public static long hash(long value) {
        value *= 11018881818881011L;
        value ^= value >>> 41 ^ value >>> 21;
        return value;
    }

    private Hasher() {
    }
}

