/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.IntIntMultiMap;
import net.openhft.chronicle.map.VanillaIntIntMultiMap;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

class VanillaShortShortMultiMap
implements IntIntMultiMap {
    private static final int ENTRY_SIZE = 4;
    private static final int ENTRY_SIZE_SHIFT = 2;
    private static final int UNSET_KEY = 0;
    private static final int HASH_INSTEAD_OF_UNSET_KEY = 65535;
    private static final int UNSET_VALUE = Integer.MIN_VALUE;
    private static final int UNSET_ENTRY = 65535;
    private final int capacity;
    private final int capacityMask;
    private final int capacityMask2;
    private final Bytes bytes;
    private ATSDirectBitSet positions;
    private int searchHash = -1;
    private int searchPos = -1;

    public VanillaShortShortMultiMap(int minCapacity) {
        this.capacity = VanillaIntIntMultiMap.multiMapCapacity(minCapacity);
        if (this.capacity > 65536) {
            throw new IllegalArgumentException();
        }
        this.capacityMask = this.capacity - 1;
        this.capacityMask2 = (this.capacity - 1) * 4;
        this.bytes = DirectStore.allocateLazy((long)(this.capacity * 4)).bytes();
        this.positions = VanillaIntIntMultiMap.newPositions(this.capacity);
        this.clear();
    }

    public VanillaShortShortMultiMap(Bytes multiMapBytes, Bytes multiMapBitSetBytes) {
        this.capacity = (int)(multiMapBytes.capacity() / 4L);
        assert (this.capacity == Maths.nextPower2((int)this.capacity, (int)16));
        this.capacityMask = this.capacity - 1;
        this.capacityMask2 = (this.capacity - 1) * 4;
        this.bytes = multiMapBytes;
        this.positions = new ATSDirectBitSet(multiMapBitSetBytes);
    }

    public static long sizeInBytes(int minCapacity) {
        return (long)VanillaIntIntMultiMap.multiMapCapacity(minCapacity) * 4L;
    }

    public static long sizeOfBitSetInBytes(int minCapacity) {
        return VanillaIntIntMultiMap.sizeOfBitSetInBytes(minCapacity);
    }

    private static void checkKey(int key) {
        if ((key & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Key out of range, was " + key);
        }
    }

    private static void checkValue(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Value out of range, was " + value);
        }
    }

    private static int checkAndMaskUnsetKey(int key) {
        if (key == 0) {
            return 65535;
        }
        VanillaShortShortMultiMap.checkKey(key);
        return key;
    }

    @Override
    public void put(int key, int value) {
        key = VanillaShortShortMultiMap.checkAndMaskUnsetKey(key);
        VanillaShortShortMultiMap.checkValue(value);
        int pos = (key & this.capacityMask) << 2;
        for (int i = 0; i <= this.capacityMask; ++i) {
            int value2;
            int entry = this.bytes.readInt((long)pos);
            int hash2 = entry >>> 16;
            if (hash2 == 0) {
                this.bytes.writeInt((long)pos, key << 16 | value);
                this.positions.set((long)value);
                return;
            }
            if (hash2 == key && (value2 = entry & 0xFFFF) == value) {
                return;
            }
            pos = pos + 4 & this.capacityMask2;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " is full");
    }

    @Override
    public boolean remove(int key, int value) {
        key = VanillaShortShortMultiMap.checkAndMaskUnsetKey(key);
        VanillaShortShortMultiMap.checkValue(value);
        int pos = (key & this.capacityMask) << 2;
        int posToRemove = -1;
        for (int i = 0; i <= this.capacityMask; ++i) {
            int entry = this.bytes.readInt((long)pos);
            int hash2 = entry >>> 16;
            if (hash2 == key) {
                int value2 = entry & 0xFFFF;
                if (value2 == value) {
                    posToRemove = pos;
                    break;
                }
            } else if (hash2 == 0) break;
            pos = pos + 4 & this.capacityMask2;
        }
        if (posToRemove < 0) {
            return false;
        }
        this.positions.clear((long)value);
        this.removePos(posToRemove);
        return true;
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        key = VanillaShortShortMultiMap.checkAndMaskUnsetKey(key);
        VanillaShortShortMultiMap.checkValue(oldValue);
        VanillaShortShortMultiMap.checkValue(newValue);
        int pos = (key & this.capacityMask) << 2;
        for (int i = 0; i <= this.capacityMask; ++i) {
            int entry = this.bytes.readInt((long)pos);
            int hash2 = entry >>> 16;
            if (hash2 == key) {
                int value2 = entry & 0xFFFF;
                if (value2 == oldValue) {
                    this.positions.clear((long)oldValue);
                    this.positions.set((long)newValue);
                    this.bytes.writeInt((long)pos, key << 16 | newValue);
                    return true;
                }
            } else if (hash2 == 0) break;
            pos = pos + 4 & this.capacityMask2;
        }
        return false;
    }

    private void removePos(int posToRemove) {
        int entryToShift;
        int hash;
        int posToShift = posToRemove;
        for (int i = 0; i <= this.capacityMask && (hash = (entryToShift = this.bytes.readInt((long)(posToShift = posToShift + 4 & this.capacityMask2))) >>> 16) != 0; ++i) {
            boolean cond2;
            int insertPos = (hash & this.capacityMask) << 2;
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.bytes.writeInt((long)posToRemove, entryToShift);
            posToRemove = posToShift;
        }
        this.bytes.writeInt((long)posToRemove, 65535);
    }

    @Override
    public int startSearch(int key) {
        key = VanillaShortShortMultiMap.checkAndMaskUnsetKey(key);
        this.searchPos = (key & this.capacityMask) << 2;
        this.searchHash = key;
        return this.searchHash;
    }

    @Override
    public int nextPos() {
        int pos = this.searchPos;
        for (int i = 0; i < this.capacity; ++i) {
            int entry = this.bytes.readInt((long)pos);
            int hash2 = entry >>> 16;
            if (hash2 == 0) {
                this.searchPos = pos;
                return Integer.MIN_VALUE;
            }
            pos = pos + 4 & this.capacityMask2;
            if (hash2 != this.searchHash) continue;
            this.searchPos = pos;
            return entry & 0xFFFF;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " is full");
    }

    @Override
    public void removePrevPos() {
        int prevPos = this.searchPos - 4 & this.capacityMask2;
        int entry = this.bytes.readInt((long)prevPos);
        int value = entry & 0xFFFF;
        this.positions.clear((long)value);
        this.removePos(prevPos);
    }

    @Override
    public void replacePrevPos(int newValue) {
        VanillaShortShortMultiMap.checkValue(newValue);
        int prevPos = this.searchPos - 4 & this.capacityMask2;
        int oldEntry = this.bytes.readInt((long)prevPos);
        int oldValue = oldEntry & 0xFFFF;
        this.positions.clear((long)oldValue);
        this.positions.set((long)newValue);
        this.bytes.writeInt((long)prevPos, this.searchHash << 16 | newValue);
    }

    @Override
    public void putAfterFailedSearch(int value) {
        VanillaShortShortMultiMap.checkValue(value);
        this.positions.set((long)value);
        this.bytes.writeInt((long)this.searchPos, this.searchHash << 16 | value);
    }

    @Override
    public int getSearchHash() {
        return this.searchHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int i = 0;
        int pos = 0;
        while (i < this.capacity) {
            int entry = this.bytes.readInt((long)pos);
            int key = entry >>> 16;
            int value = entry & 0xFFFF;
            if (key != 0) {
                sb.append(key).append('=').append(value).append(", ");
            }
            ++i;
            pos += 4;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
            return sb.append(" }").toString();
        }
        return "{ }";
    }

    @Override
    public void forEach(IntIntMultiMap.EntryConsumer action) {
        int i = 0;
        int pos = 0;
        while (i < this.capacity) {
            int entry = this.bytes.readInt((long)pos);
            int key = entry >>> 16;
            int value = entry & 0xFFFF;
            if (key != 0) {
                action.accept(key, value);
            }
            ++i;
            pos += 4;
        }
    }

    @Override
    public DirectBitSet getPositions() {
        return this.positions;
    }

    @Override
    public void clear() {
        this.positions.clear();
        int pos = 0;
        while ((long)pos < this.bytes.capacity()) {
            this.bytes.writeInt((long)pos, 65535);
            pos += 4;
        }
    }
}

