/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.Serializer;
import net.openhft.chronicle.map.StatelessMapClient;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.constraints.NotNull;

public class StatelessServerConnector<K, V> {
    private final ChronicleMap<K, V> map;
    private final Serializer<V, ?, ?> valueSerializer;
    private final Serializer<K, ?, ?> keySerializer;

    public StatelessServerConnector(Class<K> kClass, Class<V> vClass, ChronicleMap<K, V> map) {
        this.map = map;
        SerializationBuilder<K> keyBuilder = new SerializationBuilder<K>(kClass, SerializationBuilder.Role.KEY);
        SerializationBuilder<V> valueBuilder = new SerializationBuilder<V>(vClass, SerializationBuilder.Role.VALUE);
        this.keySerializer = new Serializer(keyBuilder);
        this.valueSerializer = new Serializer(valueBuilder);
    }

    public void marshall(@NotNull Bytes in, @NotNull Bytes out) {
        byte b = in.readByte();
        StatelessMapClient.EventId eventId = StatelessMapClient.EventId.values()[b];
        switch (eventId) {
            case LONG_SIZE: {
                this.longSize(in, out);
                break;
            }
            case IS_EMPTY: {
                this.isEmpty(in, out);
                break;
            }
            case CONTAINS_KEY: {
                this.containsKey(in, out);
                break;
            }
            case CONTAINS_VALUE: {
                this.containsValue(in, out);
                break;
            }
            case GET: {
                this.get(in, out);
                break;
            }
            case PUT: {
                this.put(in, out);
                break;
            }
            case REMOVE: {
                this.remove(in, out);
                break;
            }
            case PUT_ALL: {
                this.putAll(in, out);
                break;
            }
            case CLEAR: {
                this.clear(in, out);
                break;
            }
            case KEY_SET: {
                this.keySet(in, out);
                break;
            }
            case VALUES: {
                this.values(in, out);
                break;
            }
            case ENTRY_SET: {
                this.entrySet(in, out);
                break;
            }
            case REPLACE: {
                this.replace(in, out);
                break;
            }
            case REPLACE_WITH_OLD_AND_NEW_VALUE: {
                this.replaceWithOldAndNew(in, out);
                break;
            }
            case PUT_IF_ABSENT: {
                this.putIfAbsent(in, out);
                break;
            }
            case REMOVE_WITH_VALUE: {
                this.removeWithValue(in, out);
            }
        }
    }

    private void removeWithValue(Bytes in, Bytes out) {
        boolean result = this.map.remove(this.readKey(in), this.readValue(in));
        this.reflectTransactionId(in, out);
        out.writeBoolean(result);
    }

    private void replaceWithOldAndNew(Bytes in, Bytes out) {
        K key = this.readKey(in);
        V oldValue = this.readValue(in);
        V newValue = this.readValue(in);
        this.reflectTransactionId(in, out);
        this.map.replace(key, oldValue, newValue);
    }

    public void longSize(Bytes in, Bytes out) {
        this.reflectTransactionId(in, out);
        out.writeLong(this.map.longSize());
    }

    public void size(Bytes in, Bytes out) {
        this.reflectTransactionId(in, out);
        out.writeInt(this.map.size());
    }

    public void isEmpty(Bytes in, Bytes out) {
        this.reflectTransactionId(in, out);
        out.writeBoolean(this.map.isEmpty());
    }

    public void containsKey(Bytes in, Bytes out) {
        K k = this.readKey(in);
        this.reflectTransactionId(in, out);
        out.writeBoolean(this.map.containsKey(k));
    }

    public void containsValue(Bytes in, Bytes out) {
        V v = this.readValue(in);
        this.reflectTransactionId(in, out);
        out.writeBoolean(this.map.containsValue(v));
    }

    public void get(Bytes in, Bytes out) {
        K k = this.readKey(in);
        this.reflectTransactionId(in, out);
        this.writeValue(this.map.get(k), out);
    }

    public void put(Bytes in, Bytes out) {
        K k = this.readKey(in);
        V v = this.readValue(in);
        this.reflectTransactionId(in, out);
        this.writeValue(this.map.put(k, v), out);
    }

    public void remove(Bytes in, Bytes out) {
        Object value = this.map.remove(this.readKey(in));
        this.reflectTransactionId(in, out);
        this.writeValue(value, out);
    }

    public void putAll(Bytes in, Bytes out) {
        this.map.putAll(this.readEntries(in));
        this.reflectTransactionId(in, out);
    }

    private Map<K, V> readEntries(Bytes in) {
        long size = in.readStopBit();
        HashMap<K, V> result = new HashMap<K, V>();
        for (long i = 0L; i < size; ++i) {
            result.put(this.readKey(in), this.readValue(in));
        }
        return result;
    }

    public void clear(Bytes in, Bytes out) {
        this.map.clear();
        this.reflectTransactionId(in, out);
    }

    public void keySet(Bytes in, Bytes out) {
        this.reflectTransactionId(in, out);
        Set ks = this.map.keySet();
        out.writeStopBit((long)ks.size());
        for (Object key : ks) {
            this.writeKey(key, out);
        }
    }

    public void values(Bytes in, Bytes out) {
        this.reflectTransactionId(in, out);
        Collection values = this.map.values();
        out.writeStopBit((long)values.size());
        for (Object value : values) {
            this.writeValue(value, out);
        }
    }

    public void entrySet(Bytes in, Bytes out) {
        this.reflectTransactionId(in, out);
        Set entries = this.map.entrySet();
        out.writeStopBit((long)entries.size());
        for (Map.Entry e : entries) {
            this.writeKey(e.getKey(), out);
            this.writeValue(e.getValue(), out);
        }
    }

    public void putIfAbsent(Bytes in, Bytes out) {
        K key = this.readKey(in);
        V v = this.readValue(in);
        this.reflectTransactionId(in, out);
        this.writeValue(this.map.putIfAbsent(key, v), out);
    }

    public void replace(Bytes in, Bytes out) {
        K k = this.readKey(in);
        V v = this.readValue(in);
        this.reflectTransactionId(in, out);
        this.map.replace(k, v);
    }

    private void writeKey(K key, Bytes out) {
        this.keySerializer.writeMarshallable(key, out);
    }

    private void reflectTransactionId(Bytes in, Bytes out) {
        out.writeLong(in.readLong());
    }

    private void writeValue(V value, Bytes out) {
        this.valueSerializer.writeMarshallable(value, out);
    }

    private K readKey(Bytes in) {
        return this.keySerializer.readMarshallable(in);
    }

    private V readValue(Bytes in) {
        return this.valueSerializer.readMarshallable(in);
    }
}

