/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.ChronicleHashBuilder;
import net.openhft.chronicle.ChronicleHashErrorListener;
import net.openhft.chronicle.ChronicleHashErrorListeners;
import net.openhft.chronicle.TimeProvider;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChannelProvider;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapEventListeners;
import net.openhft.chronicle.map.NullValueProvider;
import net.openhft.chronicle.map.Objects;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.ReplicationConfig;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.TcpReplicationConfig;
import net.openhft.chronicle.map.UdpReplicationConfig;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.serialization.AgileBytesMarshaller;
import net.openhft.chronicle.map.serialization.MetaBytesInterop;
import net.openhft.chronicle.map.serialization.MetaProvider;
import net.openhft.chronicle.map.threadlocal.Provider;
import net.openhft.chronicle.map.threadlocal.ThreadLocalCopies;
import net.openhft.lang.Maths;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleMapBuilder<K, V>
implements Cloneable,
ChronicleHashBuilder<K, ChronicleMap<K, V>, ChronicleMapBuilder<K, V>> {
    private static final Bytes EMPTY_BYTES = new ByteBufferBytes(ByteBuffer.allocate(0));
    private static final int DEFAULT_KEY_OR_VALUE_SIZE = 120;
    public static final short UDP_REPLICATION_MODIFICATION_ITERATOR_ID = 128;
    private static final Logger LOG = LoggerFactory.getLogger((String)ChronicleMapBuilder.class.getName());
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    private Map<Class<? extends Replicator>, Replicator> replicators = new HashMap<Class<? extends Replicator>, Replicator>();
    private int minSegments = -1;
    private int actualSegments = -1;
    private int actualEntriesPerSegment = -1;
    private int keySize = 0;
    private K sampleKey;
    private int valueSize = 0;
    private V sampleValue;
    private int entrySize = 0;
    private Alignment alignment = Alignment.OF_4_BYTES;
    private long entries = 0x100000L;
    private long lockTimeOut = 2000L;
    private TimeUnit lockTimeOutUnit = TimeUnit.MILLISECONDS;
    private int metaDataBytes = 0;
    private ChronicleHashErrorListener errorListener = ChronicleHashErrorListeners.logging();
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private boolean largeSegments = false;
    private TimeProvider timeProvider = TimeProvider.SYSTEM;
    private BytesMarshallerFactory bytesMarshallerFactory;
    private ObjectSerializer objectSerializer;
    private MapEventListener<K, V, ChronicleMap<K, V>> eventListener = MapEventListeners.nop();
    private V defaultValue = null;
    private DefaultValueProvider<K, V> defaultValueProvider = null;
    private byte identifier = (byte)-1;

    ChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass, SerializationBuilder.Role.KEY);
        this.valueBuilder = new SerializationBuilder<V>(valueClass, SerializationBuilder.Role.VALUE);
    }

    public static <K, V> ChronicleMapBuilder<K, V> of(Class<K> keyClass, Class<V> valueClass) {
        return new ChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        long roundUp = headerSize + 127L & 0xFFFFFFFFFFFFFF80L;
        if (roundUp - headerSize < 64L) {
            roundUp += 128L;
        }
        return roundUp;
    }

    @Override
    public ChronicleMapBuilder<K, V> clone() {
        try {
            ChronicleMapBuilder result = (ChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleMapBuilder<K, V> minSegments(int minSegments) {
        this.minSegments = minSegments;
        return this;
    }

    int minSegments() {
        return this.minSegments < 1 ? this.tryMinSegments(4, 65536) : this.minSegments;
    }

    private int tryMinSegments(int min, int max) {
        for (int i = min; i < max; i <<= 1) {
            if (i * i * i < this.entrySize() * 2) continue;
            return i;
        }
        return max;
    }

    @Override
    public ChronicleMapBuilder<K, V> keySize(int keySize) {
        if (keySize <= 0) {
            throw new IllegalArgumentException("Key size must be positive");
        }
        this.keySize = keySize;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantKeySizeBySample(K sampleKey) {
        this.sampleKey = sampleKey;
        return this;
    }

    private int keySize() {
        return this.keyOrValueSize(this.keySize, this.keyBuilder);
    }

    public ChronicleMapBuilder<K, V> valueSize(int valueSize) {
        if (valueSize <= 0) {
            throw new IllegalArgumentException("Value size must be positive");
        }
        this.valueSize = valueSize;
        return this;
    }

    public ChronicleMapBuilder<K, V> constantValueSizeBySample(V sampleValue) {
        this.sampleValue = sampleValue;
        return this;
    }

    private int valueSize() {
        return this.keyOrValueSize(this.valueSize, this.valueBuilder);
    }

    private int keyOrValueSize(int configuredSize, SerializationBuilder builder) {
        if (configuredSize > 0) {
            return configuredSize;
        }
        if (builder.sizeMarshaller().sizeEncodingSize(0L) == 0) {
            return (int)builder.sizeMarshaller().readSize(EMPTY_BYTES);
        }
        return 120;
    }

    @Override
    public ChronicleMapBuilder<K, V> entrySize(int entrySize) {
        if (entrySize <= 0) {
            throw new IllegalArgumentException("Entry Size must be positive");
        }
        this.entrySize = entrySize;
        return this;
    }

    int entrySize() {
        if (this.entrySize > 0) {
            return this.entryAndValueAlignment().alignSize(this.entrySize);
        }
        int size = this.metaDataBytes;
        int keySize = this.keySize();
        size += this.keyBuilder.sizeMarshaller().sizeEncodingSize(keySize);
        size += keySize;
        if (this.useReplication()) {
            size += 10;
        }
        int valueSize = this.valueSize();
        size += this.valueBuilder.sizeMarshaller().sizeEncodingSize(valueSize);
        size = this.entryAndValueAlignment().alignSize(size);
        size += valueSize;
        for (int i = 1; i <= 4; ++i) {
            int bound = i * 64;
            if (size >= bound || bound - size > bound / 20) continue;
            size = bound;
            break;
        }
        return this.entryAndValueAlignment().alignSize(size);
    }

    public ChronicleMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    Alignment entryAndValueAlignment() {
        return this.alignment;
    }

    @Override
    public ChronicleMapBuilder<K, V> entries(long entries) {
        this.entries = entries;
        return this;
    }

    long entries() {
        return this.entries;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualEntriesPerSegment(int actualEntriesPerSegment) {
        this.actualEntriesPerSegment = actualEntriesPerSegment;
        return this;
    }

    int actualEntriesPerSegment() {
        if (this.actualEntriesPerSegment > 0) {
            return this.actualEntriesPerSegment;
        }
        int as = this.actualSegments();
        return (int)(Math.max(1L, this.entries * 2L / (long)as) + 63L) & 0xFFFFFFC0;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualSegments(int actualSegments) {
        this.actualSegments = actualSegments;
        return this;
    }

    int actualSegments() {
        long segments;
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        if (!this.largeSegments && this.entries > (long)this.minSegments() << 15 && (segments = Maths.nextPower2((long)(this.entries >> 15), (long)128L)) < 0x100000L) {
            return (int)segments;
        }
        return (int)Maths.nextPower2((long)Math.max((this.entries >> 30) + 1L, (long)this.minSegments()), (long)1L);
    }

    @Override
    public ChronicleMapBuilder<K, V> lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.lockTimeOut = lockTimeOut;
        this.lockTimeOutUnit = unit;
        return this;
    }

    long lockTimeOut(TimeUnit unit) {
        return unit.convert(this.lockTimeOut, this.lockTimeOutUnit);
    }

    @Override
    public ChronicleMapBuilder<K, V> errorListener(ChronicleHashErrorListener errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    ChronicleHashErrorListener errorListener() {
        return this.errorListener;
    }

    public ChronicleMapBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public ChronicleMapBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    boolean largeSegments() {
        return this.entries > 0x800000000L || this.largeSegments;
    }

    @Override
    public ChronicleMapBuilder<K, V> largeSegments(boolean largeSegments) {
        this.largeSegments = largeSegments;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> metaDataBytes(int metaDataBytes) {
        if ((metaDataBytes & 0xFF) != metaDataBytes) {
            throw new IllegalArgumentException("MetaDataBytes must be [0..255] was " + metaDataBytes);
        }
        this.metaDataBytes = metaDataBytes;
        return this;
    }

    int metaDataBytes() {
        return this.metaDataBytes;
    }

    public String toString() {
        return "ChronicleMapBuilder{actualSegments=" + ChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + ChronicleMapBuilder.pretty(this.minSegments) + ", actualEntriesPerSegment=" + ChronicleMapBuilder.pretty(this.actualEntriesPerSegment) + ", keySize=" + ChronicleMapBuilder.pretty(this.keySize) + ", sampleKeyForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleKey) + ", valueSize=" + ChronicleMapBuilder.pretty(this.valueSize) + ", sampleValueForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleValue) + ", entrySize=" + ChronicleMapBuilder.pretty(this.entrySize) + ", entryAndValueAlignment=" + (Object)((Object)this.entryAndValueAlignment()) + ", entries=" + this.entries() + ", lockTimeOut=" + this.lockTimeOut + " " + (Object)((Object)this.lockTimeOutUnit) + ", metaDataBytes=" + this.metaDataBytes() + ", errorListener=" + this.errorListener() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", largeSegments=" + (this.largeSegments ? "true" : "not configured") + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerFactory=" + ChronicleMapBuilder.pretty(this.bytesMarshallerFactory) + ", objectSerializer=" + ChronicleMapBuilder.pretty(this.objectSerializer) + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + ", eventListener=" + this.eventListener + ", defaultValue=" + this.defaultValue + ", defaultValueProvider=" + ChronicleMapBuilder.pretty(this.defaultValueProvider) + '}';
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleMapBuilder<K, V> replicators(byte identifier, ReplicationConfig ... replicationConfigs) {
        this.identifier = identifier;
        this.replicators.clear();
        for (ReplicationConfig replicationConfig : replicationConfigs) {
            Replicator replicator;
            if (replicationConfig instanceof TcpReplicationConfig) {
                replicator = Replicators.tcp((TcpReplicationConfig)replicationConfig);
            } else if (replicationConfig instanceof UdpReplicationConfig) {
                replicator = Replicators.udp((UdpReplicationConfig)replicationConfig);
            } else {
                throw new UnsupportedOperationException();
            }
            this.replicators.put(replicator.getClass(), replicator);
        }
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> channel(ChannelProvider.ChronicleChannel chronicleChannel) {
        this.identifier = chronicleChannel.identifier();
        this.replicators.clear();
        this.replicators.put(chronicleChannel.getClass(), chronicleChannel);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    TimeProvider timeProvider() {
        return this.timeProvider;
    }

    BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory == null ? (this.bytesMarshallerFactory = new VanillaBytesMarshallerFactory()) : this.bytesMarshallerFactory;
    }

    @Override
    public ChronicleMapBuilder<K, V> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        return this;
    }

    ObjectSerializer objectSerializer() {
        return this.objectSerializer == null ? (this.objectSerializer = BytesMarshallableSerializer.create((BytesMarshallerFactory)this.bytesMarshallerFactory(), (ObjectSerializer)JDKObjectSerializer.INSTANCE)) : this.objectSerializer;
    }

    @Override
    public ChronicleMapBuilder<K, V> objectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshaller(@NotNull BytesMarshaller<K> keyMarshaller) {
        this.keyBuilder.marshaller(keyMarshaller, null);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> immutableKeys() {
        this.keyBuilder.instancesAreMutable(false);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshallerAndFactory(@NotNull BytesMarshaller<V> valueMarshaller, @NotNull ObjectFactory<V> valueFactory) {
        this.valueBuilder.marshaller(valueMarshaller, valueFactory);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshallerAndFactory(@NotNull AgileBytesMarshaller<V> valueMarshaller, @NotNull ObjectFactory<V> valueFactory) {
        this.valueBuilder.agileMarshaller(valueMarshaller, valueFactory);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueFactory(@NotNull ObjectFactory<V> valueFactory) {
        this.valueBuilder.factory(valueFactory);
        return this;
    }

    public ChronicleMapBuilder<K, V> eventListener(MapEventListener<K, V, ChronicleMap<K, V>> eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    MapEventListener<K, V, ChronicleMap<K, V>> eventListener() {
        return this.eventListener;
    }

    public ChronicleMapBuilder<K, V> defaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultValueProvider = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> defaultValueProvider(DefaultValueProvider<K, V> defaultValueProvider) {
        this.defaultValueProvider = defaultValueProvider;
        return this;
    }

    DefaultValueProvider<K, V> defaultValueProvider() {
        if (this.defaultValueProvider != null) {
            return this.defaultValueProvider;
        }
        if (this.defaultValue == null) {
            return NullValueProvider.INSTANCE;
        }
        Object originalValueWriter = this.valueBuilder.interop();
        Provider<?> writerProvider = Provider.of(originalValueWriter.getClass());
        ThreadLocalCopies copies = writerProvider.getCopies(null);
        Object valueWriter = writerProvider.get(copies, originalValueWriter);
        MetaProvider<V, ?, MetaBytesInterop<V, ?>> metaWriterProvider = this.valueBuilder.metaInteropProvider();
        copies = metaWriterProvider.getCopies(copies);
        MetaBytesInterop<V, ?> metaValueWriter = metaWriterProvider.get(copies, this.valueBuilder.metaInterop(), valueWriter, this.defaultValue);
        return new ConstantValueProvider(this.defaultValue, metaValueWriter, valueWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChronicleMap<K, V> create(File file) throws IOException {
        for (int i = 0; i < 10; ++i) {
            if (file.exists() && file.length() > 0L) {
                FileInputStream fis = new FileInputStream(file);
                try (ObjectInputStream ois = new ObjectInputStream(fis);){
                    VanillaChronicleMap map = (VanillaChronicleMap)ois.readObject();
                    map.headerSize = ChronicleMapBuilder.roundUpMapHeaderSize(fis.getChannel().position());
                    map.createMappedStoreAndSegments(file);
                    ChronicleMap<K, V> chronicleMap = this.establishReplication(map);
                    return chronicleMap;
                }
            }
            if (file.createNewFile() || file.length() == 0L) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to create " + file);
        }
        VanillaChronicleMap<K, ?, ?, V, ?, ?> map = this.newMap();
        FileOutputStream fos = new FileOutputStream(file);
        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(map);
            oos.flush();
            map.headerSize = ChronicleMapBuilder.roundUpMapHeaderSize(fos.getChannel().position());
            map.createMappedStoreAndSegments(file);
        }
        return this.establishReplication(map);
    }

    @Override
    public ChronicleMap<K, V> create() throws IOException {
        VanillaChronicleMap<K, ?, ?, V, ?, ?> map = this.newMap();
        DirectStore bytesStore = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, map.sizeInBytes(), true);
        map.createMappedStoreAndSegments((BytesStore)bytesStore);
        return this.establishReplication(map);
    }

    private VanillaChronicleMap<K, ?, ?, V, ?, ?> newMap() throws IOException {
        this.preMapConstruction();
        if (!this.useReplication()) {
            return new VanillaChronicleMap(this);
        }
        return new ReplicatedChronicleMap(this);
    }

    private boolean useReplication() {
        return this.identifier != -1;
    }

    void preMapConstruction() {
        this.keyBuilder.objectSerializer(this.objectSerializer());
        this.valueBuilder.objectSerializer(this.objectSerializer());
        int maxSize = this.entrySize() * this.figureBufferAllocationFactor();
        this.keyBuilder.maxSize(maxSize);
        this.valueBuilder.maxSize(maxSize);
        if (this.sampleKey != null) {
            this.keyBuilder.constantSizeBySample(this.sampleKey);
        }
        if (this.sampleValue != null) {
            this.valueBuilder.constantSizeBySample(this.sampleValue);
        }
    }

    private ChronicleMap<K, V> establishReplication(ChronicleMap<K, V> map) throws IOException {
        if (map instanceof ReplicatedChronicleMap) {
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            for (Replicator replicator : this.replicators.values()) {
                Closeable token = replicator.applyTo(this, result, result);
                if (this.replicators.size() == 1 && token.getClass() == UdpReplicator.class) {
                    LOG.warn("MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator");
                }
                result.addCloseable(token);
            }
        }
        return map;
    }

    private int figureBufferAllocationFactor() {
        return (int)Math.min(Math.max(2L, this.entries() >> 10), 64L);
    }

    public byte identifier() {
        return this.identifier;
    }
}

