/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import net.openhft.chronicle.ChronicleHashErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChronicleHashErrorListeners {
    public static ChronicleHashErrorListener logging() {
        return LoggingErrorListener.INSTANCE;
    }

    public static ChronicleHashErrorListener error() {
        return ThrowingErrorListener.INSTANCE;
    }

    private static enum ThrowingErrorListener implements ChronicleHashErrorListener
    {
        INSTANCE;


        @Override
        public void onLockTimeout(long threadId) throws IllegalStateException {
            throw new IllegalStateException("Unable to acquire lock held by threadId: " + threadId);
        }

        @Override
        public void errorOnUnlock(IllegalMonitorStateException e) {
            throw e;
        }
    }

    private static enum LoggingErrorListener implements ChronicleHashErrorListener
    {
        INSTANCE;

        final Logger LOG = LoggerFactory.getLogger(this.getClass());

        @Override
        public void onLockTimeout(long threadId) throws IllegalStateException {
            if (threadId > 0x100000000L) {
                this.LOG.warn("Grabbing lock held by processId: {}, threadId: {}", (Object)(threadId >>> 33), (Object)(threadId & 0xFFFFFFL));
            } else {
                this.LOG.warn("Grabbing lock held by threadId: {}", (Object)threadId);
            }
        }

        @Override
        public void errorOnUnlock(IllegalMonitorStateException e) {
            this.LOG.warn("Failed to unlock as expected", (Throwable)e);
        }
    }
}

