/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.hashing;

import net.openhft.chronicle.hash.hashing.Access;
import net.openhft.chronicle.hash.hashing.Accesses;
import net.openhft.chronicle.hash.hashing.Primitives;
import net.openhft.chronicle.hash.hashing.UnsafeAccess;
import net.openhft.lang.io.Bytes;

public final class Hasher {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;

    public static <T> long hash(T input, Access<T> access, long offset, long length) {
        long k2;
        long k1;
        assert (offset >= 0L && length >= 0L);
        long h1 = 0L;
        long h2 = 0L;
        long remaining = length;
        while (remaining >= 16L) {
            k1 = access.getLong(input, offset);
            k2 = access.getLong(input, offset + 8L);
            offset += 16L;
            remaining -= 16L;
            h1 ^= Hasher.mixK1(k1);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            h2 ^= Hasher.mixK2(k2);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        if (remaining > 0L) {
            k1 = 0L;
            k2 = 0L;
            switch ((int)remaining) {
                case 15: {
                    k2 ^= (long)access.getUnsignedByte(input, offset + 14L) << 48;
                }
                case 14: {
                    k2 ^= (long)access.getUnsignedByte(input, offset + 13L) << 40;
                }
                case 13: {
                    k2 ^= (long)access.getUnsignedByte(input, offset + 12L) << 32;
                }
                case 12: {
                    k2 ^= (long)access.getUnsignedByte(input, offset + 11L) << 24;
                }
                case 11: {
                    k2 ^= (long)access.getUnsignedByte(input, offset + 10L) << 16;
                }
                case 10: {
                    k2 ^= (long)access.getUnsignedByte(input, offset + 9L) << 8;
                }
                case 9: {
                    k2 ^= (long)access.getUnsignedByte(input, offset + 8L);
                }
                case 8: {
                    k1 ^= access.getLong(input, offset);
                    break;
                }
                case 7: {
                    k1 ^= (long)access.getUnsignedByte(input, offset + 6L) << 48;
                }
                case 6: {
                    k1 ^= (long)access.getUnsignedByte(input, offset + 5L) << 40;
                }
                case 5: {
                    k1 ^= (long)access.getUnsignedByte(input, offset + 4L) << 32;
                }
                case 4: {
                    k1 ^= access.getUnsignedInt(input, offset);
                    break;
                }
                case 3: {
                    k1 ^= (long)access.getUnsignedByte(input, offset + 2L) << 16;
                }
                case 2: {
                    k1 ^= (long)access.getUnsignedByte(input, offset + 1L) << 8;
                }
                case 1: {
                    k1 ^= (long)access.getUnsignedByte(input, offset);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            h1 ^= Hasher.mixK1(k1);
            h2 ^= Hasher.mixK2(k2);
        }
        return Hasher.finalize(length, h1, h2);
    }

    private static long finalize(long length, long h1, long h2) {
        h1 ^= length;
        h1 += (h2 ^= length);
        h2 += h1;
        h1 = Hasher.fmix64(h1);
        h2 = Hasher.fmix64(h2);
        return h1 += h2;
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private static long mixK1(long k1) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= 5545529020109919103L;
    }

    private static long mixK2(long k2) {
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= -8663945395140668459L;
    }

    public static long hash(Bytes bytes) {
        return Hasher.hash(bytes, bytes.position(), bytes.limit());
    }

    public static long hash(Bytes bytes, long offset, long limit) {
        return Hasher.hash(bytes, Accesses.toBytes(), offset, limit - offset);
    }

    public static long hash(byte[] array) {
        return Hasher.hash(array, Accesses.unsafe(), UnsafeAccess.BYTE_BASE, array.length);
    }

    public static long hash(char[] array) {
        return Hasher.hash(array, Accesses.unsafe(), UnsafeAccess.CHAR_BASE, (long)array.length * 2L);
    }

    public static long hash(int value) {
        long k1 = Primitives.unsignedInt(value);
        long h1 = 0L ^ Hasher.mixK1(k1);
        long h2 = 0L;
        return Hasher.finalize(4L, h1, h2);
    }

    public static long hash(long value) {
        long k1 = value;
        long h1 = 0L ^ Hasher.mixK1(k1);
        long h2 = 0L;
        return Hasher.finalize(8L, h1, h2);
    }

    private Hasher() {
    }
}

