/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.xstreem.converters;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.openhft.chronicle.map.MapEntryCallback;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.xstreem.converters.AbstractChronicleMapConverter;

public class StatelessChronicleMapConverter<K, V>
extends AbstractChronicleMapConverter<K, V> {
    public StatelessChronicleMapConverter(@NotNull Map<K, V> map) {
        super(map);
    }

    @Override
    public void marshal(Object o, final HierarchicalStreamWriter writer, final MarshallingContext marshallingContext) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            Method entrySize = o.getClass().getDeclaredMethod("entrySet", MapEntryCallback.class);
            entrySize.setAccessible(true);
            entrySize.invoke(o, new MapEntryCallback(){

                public void onEntry(Object key, Object value) {
                    writer.startNode("entry");
                    writer.startNode(key.getClass().getName());
                    marshallingContext.convertAnother(key);
                    writer.endNode();
                    writer.startNode(value.getClass().getName());
                    marshallingContext.convertAnother(value);
                    writer.endNode();
                    writer.endNode();
                }

                @Override
                public void onFinished() {
                    countDownLatch.countDown();
                }
            });
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConversionException("", (Throwable)e);
        }
    }
}

