/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.xstreem.converters;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Collections;
import java.util.Map;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.constraints.NotNull;

public class AbstractChronicleMapConverter<K, V>
implements Converter {
    private final Map<K, V> map;
    final Class mapClazz;

    public AbstractChronicleMapConverter(@NotNull Map<K, V> map) {
        this.map = map;
        this.mapClazz = map.getClass();
    }

    public boolean canConvert(Class aClass) {
        return this.mapClazz.isAssignableFrom(aClass);
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        for (Map.Entry entry : ((Map)o).entrySet()) {
            writer.startNode("entry");
            Object key = entry.getKey();
            writer.startNode(key.getClass().getName());
            marshallingContext.convertAnother(key);
            writer.endNode();
            Object value = entry.getValue();
            writer.startNode(value.getClass().getName());
            marshallingContext.convertAnother(value);
            writer.endNode();
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if ("[\"\"]".equals(reader.getValue())) {
            return null;
        }
        if (!"cmap".equals(reader.getNodeName())) {
            throw new ConversionException("should be under 'cmap' node");
        }
        reader.moveDown();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName0 = reader.getNodeName();
            if (!nodeName0.equals("entry")) {
                throw new ConversionException("unable to convert node named=" + nodeName0);
            }
            reader.moveDown();
            Object k = AbstractChronicleMapConverter.deserialize(context, reader);
            reader.moveUp();
            reader.moveDown();
            Object v = AbstractChronicleMapConverter.deserialize(context, reader);
            reader.moveUp();
            if (k != null) {
                this.map.put(k, v);
            }
            reader.moveUp();
        }
        reader.moveUp();
        return null;
    }

    static <E> E deserialize(@NotNull UnmarshallingContext unmarshallingContext, @NotNull HierarchicalStreamReader reader) {
        switch (reader.getNodeName()) {
            case "java.util.Collections$EmptySet": {
                return (E)Collections.EMPTY_SET;
            }
            case "java.util.Collections$EmptyList": {
                return (E)Collections.EMPTY_LIST;
            }
            case "java.util.Collections$EmptyMap": 
            case "java.util.Collections.EmptyMap": {
                return (E)Collections.EMPTY_MAP;
            }
        }
        return (E)unmarshallingContext.convertAnother(null, AbstractChronicleMapConverter.forName(reader.getNodeName()));
    }

    static Class forName(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            boolean isNative = clazz.endsWith("$$Native");
            boolean isHeap = clazz.endsWith("$$Heap");
            if (!isNative && !isHeap) {
                throw new ConversionException("class=" + clazz, (Throwable)e);
            }
            String nativeInterface = isNative ? clazz.substring(0, clazz.length() - "$$Native".length()) : clazz.substring(0, clazz.length() - "$$Heap".length());
            try {
                DataValueClasses.newDirectInstance(Class.forName(clazz));
                return Class.forName(nativeInterface);
            }
            catch (Exception e1) {
                throw new ConversionException("class=" + clazz, (Throwable)e1);
            }
        }
    }
}

