/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.ChronicleHashErrorListeners;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.StatelessClientConfig;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.BytesMapEventListener;
import net.openhft.chronicle.map.ChannelProvider;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapInstanceConfig;
import net.openhft.chronicle.map.MultiMapFactory;
import net.openhft.chronicle.map.Objects;
import net.openhft.chronicle.map.PrepareValueBytes;
import net.openhft.chronicle.map.PrepareValueBytesAsWriter;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.StatelessMapConfig;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.ZeroOutValueBytes;
import net.openhft.lang.Maths;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.DataValueGenerator;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChronicleMapBuilder<K, V>
implements Cloneable,
ChronicleHashBuilder<K, ChronicleMap<K, V>, ChronicleMapBuilder<K, V>>,
Serializable {
    static final byte UDP_REPLICATION_MODIFICATION_ITERATOR_ID = -128;
    private static final int DEFAULT_KEY_OR_VALUE_SIZE = 120;
    private static final long DEFAULT_ENTRIES = 0x100000L;
    private static final int MAX_SEGMENTS = 0x40000000;
    private static final int MAX_SEGMENTS_TO_CHAISE_COMPACT_MULTI_MAPS = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger((String)ChronicleMapBuilder.class.getName());
    static final long DEFAULT_STATELESS_CLIENT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final StringBuilder EMTRY_STRING_BUILDER = new StringBuilder();
    private static final double UNDEFINED_DOUBLE_CONFIG = Double.NaN;
    private List jsonConverters = new ArrayList();
    private static final boolean strictStateChecks = Boolean.getBoolean("chronicle.strictStateChecks");
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    private String name;
    private int minSegments = -1;
    private int actualSegments = -1;
    private long entriesPerSegment = -1L;
    private long actualChunksPerSegment = -1L;
    private double averageKeySize = Double.NaN;
    private K sampleKey;
    private double averageValueSize = Double.NaN;
    private V sampleValue;
    private int actualChunkSize = 0;
    private int maxChunksPerEntry = -1;
    private Alignment alignment = null;
    private long entries = -1L;
    private long lockTimeOut = 20000L;
    private TimeUnit lockTimeOutUnit = TimeUnit.MILLISECONDS;
    private int metaDataBytes = 0;
    private ChronicleHashErrorListener errorListener = ChronicleHashErrorListeners.logging();
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private TimeProvider timeProvider = TimeProvider.SYSTEM;
    private BytesMarshallerFactory bytesMarshallerFactory;
    private ObjectSerializer objectSerializer;
    private MapEventListener<K, V> eventListener = null;
    private BytesMapEventListener bytesEventListener = null;
    private V defaultValue = null;
    private DefaultValueProvider<K, V> defaultValueProvider = null;
    private PrepareValueBytes<K, V> prepareValueBytes = null;
    private SingleChronicleHashReplication singleHashReplication = null;
    private InetSocketAddress[] pushToAddresses;

    private static boolean isDefined(double config) {
        return !Double.isNaN(config);
    }

    ChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass, SerializationBuilder.Role.KEY);
        this.valueBuilder = new SerializationBuilder<V>(valueClass, SerializationBuilder.Role.VALUE);
        if (CharSequence.class == valueClass) {
            this.defaultValue = "";
        }
        if (StringBuilder.class == valueClass) {
            this.defaultValue = EMTRY_STRING_BUILDER;
        }
    }

    public static <K, V> ChronicleMapBuilder<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return new ChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        long roundUp = headerSize + 127L & 0xFFFFFFFFFFFFFF80L;
        if (roundUp - headerSize < 64L) {
            roundUp += 128L;
        }
        return roundUp;
    }

    private static void checkSegments(int segments) {
        if (segments <= 0 || segments > 0x40000000) {
            throw new IllegalArgumentException("segments should be positive, " + segments + " given");
        }
        if (segments > 0x40000000) {
            throw new IllegalArgumentException("Max segments is 1073741824, " + segments + " given");
        }
    }

    private static long divideUpper(long dividend, long divisor) {
        return (dividend - 1L) / divisor + 1L;
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    public ChronicleMapBuilder<K, V> pushTo(InetSocketAddress ... addresses) {
        this.pushToAddresses = addresses;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> clone() {
        try {
            ChronicleMapBuilder result = (ChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleMapBuilder<K, V> averageKeySize(double averageKeySize) {
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.keyBuilder);
        ChronicleMapBuilder.checkAverageSize(averageKeySize, "key");
        this.averageKeySize = averageKeySize;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantKeySizeBySample(K sampleKey) {
        this.sampleKey = sampleKey;
        return this;
    }

    public ChronicleMapBuilder<K, V> addJsonConverter(Object converter) {
        this.jsonConverters.add(converter);
        return this;
    }

    private double averageKeySize() {
        return this.averageKeyOrValueSize(this.averageKeySize, this.keyBuilder);
    }

    public ChronicleMapBuilder<K, V> averageValueSize(double averageValueSize) {
        ChronicleMapBuilder.checkSizeIsNotStaticallyKnown(this.valueBuilder);
        ChronicleMapBuilder.checkAverageSize(averageValueSize, "value");
        this.averageValueSize = averageValueSize;
        return this;
    }

    private static void checkAverageSize(double averageSize, String role) {
        if (averageSize <= 0.0 || Double.isNaN(averageSize) || Double.isInfinite(averageSize)) {
            throw new IllegalArgumentException("Average " + role + " size must be a positive, " + "finite number");
        }
    }

    private static void checkSizeIsNotStaticallyKnown(SerializationBuilder builder) {
        if (builder.sizeIsStaticallyKnown) {
            throw new IllegalStateException("Size of type " + builder.eClass + " is statically known and shouldn't be specified manually");
        }
    }

    public ChronicleMapBuilder<K, V> constantValueSizeBySample(V sampleValue) {
        this.sampleValue = sampleValue;
        return this;
    }

    double averageValueSize() {
        return this.averageKeyOrValueSize(this.averageValueSize, this.valueBuilder);
    }

    private double averageKeyOrValueSize(double configuredSize, SerializationBuilder builder) {
        if (ChronicleMapBuilder.isDefined(configuredSize)) {
            return configuredSize;
        }
        if (builder.constantSizeMarshaller()) {
            return builder.pseudoReadConstantSize();
        }
        return 120.0;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunkSize(int actualChunkSize) {
        if (this.constantlySizedEntries()) {
            throw new IllegalStateException("Sizes of key type: " + this.keyBuilder.eClass + " and " + "value type: " + this.valueBuilder.eClass + " are both constant, " + "so chunk size shouldn't be specified manually");
        }
        if (actualChunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be positive");
        }
        this.actualChunkSize = actualChunkSize;
        return this;
    }

    List jsonConverters() {
        return this.jsonConverters;
    }

    private EntrySizeInfo entrySizeInfo(boolean replicated) {
        int worstAlignment;
        double size = this.metaDataBytes;
        double keySize = this.averageKeySize();
        size += ChronicleMapBuilder.averageSizeEncodingSize(this.keyBuilder, keySize);
        size += keySize;
        if (replicated) {
            size += 10.0;
        }
        double valueSize = this.averageValueSize();
        size += ChronicleMapBuilder.averageSizeEncodingSize(this.valueBuilder, valueSize);
        Alignment alignment = this.valueAlignment();
        if (alignment != Alignment.NO_ALIGNMENT && this.constantlySizedKeys() && this.valueBuilder.constantSizeEncodingSizeMarshaller()) {
            long constantSizeBeforeAlignment = Math.round(size);
            if (this.constantlySizedValues()) {
                long totalDataSize = constantSizeBeforeAlignment + this.constantValueSize();
                worstAlignment = (int)(alignment.alignAddr(totalDataSize) - totalDataSize);
            } else if (this.actualChunkSize > 0) {
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, this.actualChunkSize);
            } else {
                int chunkSize = 8;
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                if (!(size + (double)worstAlignment + valueSize >= (double)(ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(replicated) * chunkSize))) {
                    chunkSize = 4;
                    worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                }
            }
        } else {
            worstAlignment = alignment.alignment() - 1;
        }
        size += (double)worstAlignment;
        return new EntrySizeInfo(size += valueSize, worstAlignment);
    }

    int specialEntrySpaceOffset(boolean replicated) {
        if (!this.constantlySizedEntries()) {
            return 0;
        }
        return (int)(this.constantValueSize() % (long)this.valueAlignment().alignment());
    }

    private long constantValueSize() {
        return this.valueBuilder.pseudoReadConstantSize();
    }

    private boolean constantlySizedKeys() {
        return this.keyBuilder.constantSizeMarshaller();
    }

    private static double averageSizeEncodingSize(SerializationBuilder builder, double averageSize) {
        int upperEncodingSize;
        SizeMarshaller sizeMarshaller = builder.sizeMarshaller();
        if (averageSize == (double)Math.round(averageSize)) {
            return sizeMarshaller.sizeEncodingSize(Math.round(averageSize));
        }
        long lower = (long)averageSize;
        long upper = lower + 1L;
        int lowerEncodingSize = sizeMarshaller.sizeEncodingSize(lower);
        if (lowerEncodingSize == (upperEncodingSize = sizeMarshaller.sizeEncodingSize(upper))) {
            return lowerEncodingSize;
        }
        return (double)lower * ((double)upper - averageSize) + (double)upper * (averageSize - (double)lower);
    }

    private int worstAlignmentAssumingChunkSize(long constantSizeBeforeAlignment, int chunkSize) {
        Alignment valueAlignment = this.valueAlignment();
        long firstAlignment = valueAlignment.alignAddr(constantSizeBeforeAlignment) - constantSizeBeforeAlignment;
        int alignment = valueAlignment.alignment();
        int gcdOfAlignmentAndChunkSize = ChronicleMapBuilder.greatestCommonDivisor(alignment, chunkSize);
        if (gcdOfAlignmentAndChunkSize == alignment) {
            return (int)firstAlignment;
        }
        long worstAlignment = firstAlignment;
        while (worstAlignment + (long)gcdOfAlignmentAndChunkSize < (long)alignment) {
            worstAlignment += (long)gcdOfAlignmentAndChunkSize;
        }
        return (int)worstAlignment;
    }

    int worstAlignment(boolean replicated) {
        return this.entrySizeInfo((boolean)replicated).worstAlignment;
    }

    static int greatestCommonDivisor(int a, int b) {
        if (b == 0) {
            return a;
        }
        return ChronicleMapBuilder.greatestCommonDivisor(b, a % b);
    }

    long chunkSize(boolean replicated) {
        if (this.actualChunkSize > 0) {
            return this.actualChunkSize;
        }
        double averageEntrySize = this.entrySizeInfo((boolean)replicated).averageEntrySize;
        if (this.constantlySizedEntries()) {
            return Math.round(averageEntrySize);
        }
        int maxChunkSize = 0x40000000;
        for (long chunkSize = 4L; chunkSize <= (long)maxChunkSize; chunkSize *= 2L) {
            if (!((double)((long)ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(replicated) * chunkSize) > averageEntrySize)) continue;
            return chunkSize;
        }
        return maxChunkSize;
    }

    boolean constantlySizedEntries() {
        return this.constantlySizedKeys() && this.constantlySizedValues();
    }

    double averageChunksPerEntry(boolean replicated) {
        if (this.constantlySizedEntries()) {
            return 1.0;
        }
        long chunkSize = this.chunkSize(replicated);
        return (this.entrySizeInfo((boolean)replicated).averageEntrySize + (double)chunkSize - 1.0) / (double)chunkSize;
    }

    private static int maxDefaultChunksPerAverageEntry(boolean replicated) {
        return replicated ? 4 : 8;
    }

    @Override
    public ChronicleMapBuilder<K, V> maxChunksPerEntry(int maxChunksPerEntry) {
        if (maxChunksPerEntry < 1) {
            throw new IllegalArgumentException("maxChunksPerEntry should be >= 1, " + maxChunksPerEntry + " given");
        }
        this.maxChunksPerEntry = maxChunksPerEntry;
        return this;
    }

    int maxChunksPerEntry() {
        if (this.maxChunksPerEntry > 0) {
            return this.maxChunksPerEntry;
        }
        if (this.constantlySizedEntries()) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private boolean constantlySizedValues() {
        return this.valueBuilder.constantSizeMarshaller();
    }

    public ChronicleMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap();
        return this;
    }

    private void checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap() {
        if (!(this.valueBuilder.possibleOffHeapReferences() || this.alignment != Alignment.OF_4_BYTES && this.alignment != Alignment.OF_8_BYTES)) {
            throw new IllegalStateException("Entry and value alignment should be configured only if values might point to off-heap memory");
        }
    }

    Alignment valueAlignment() {
        if (this.alignment != null) {
            return this.alignment;
        }
        Class firstPrimitiveFieldType = DataValueGenerator.firstPrimitiveFieldType(this.valueBuilder.eClass);
        if (firstPrimitiveFieldType == Long.TYPE || firstPrimitiveFieldType == Double.TYPE) {
            return Alignment.OF_8_BYTES;
        }
        if (firstPrimitiveFieldType == Integer.TYPE || firstPrimitiveFieldType == Float.TYPE) {
            return Alignment.OF_4_BYTES;
        }
        return Alignment.NO_ALIGNMENT;
    }

    @Override
    public ChronicleMapBuilder<K, V> entries(long entries) {
        if (entries <= 0L) {
            throw new IllegalArgumentException("Entries should be positive, " + entries + " given");
        }
        this.entries = entries;
        return this;
    }

    long entries() {
        if (this.entries < 0L) {
            return 0x100000L;
        }
        return this.entries;
    }

    @Override
    public ChronicleMapBuilder<K, V> entriesPerSegment(long entriesPerSegment) {
        if (entriesPerSegment <= 0L) {
            throw new IllegalArgumentException("Entries per segment should be positive, " + entriesPerSegment + " given");
        }
        this.entriesPerSegment = entriesPerSegment;
        return this;
    }

    long entriesPerSegment(boolean replicated) {
        long entriesPerSegment;
        if (this.entriesPerSegment > 0L) {
            entriesPerSegment = this.entriesPerSegment;
        } else {
            int actualSegments = this.actualSegments(replicated);
            long totalEntries = this.totalEntriesIfPoorDistribution(actualSegments);
            entriesPerSegment = ChronicleMapBuilder.divideUpper(totalEntries, actualSegments);
        }
        if (this.actualChunksPerSegment > 0L) {
            return entriesPerSegment;
        }
        double averageChunksPerEntry = this.averageChunksPerEntry(replicated);
        if ((double)entriesPerSegment * averageChunksPerEntry > 4.294967296E9) {
            throw new IllegalStateException("Max chunks per segment is 4294967296 configured entries() and actualSegments() so that there should be " + entriesPerSegment + " entries per segment, while average chunks per entry is " + averageChunksPerEntry);
        }
        return entriesPerSegment;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunksPerSegment(long actualChunksPerSegment) {
        if (actualChunksPerSegment <= 0L) {
            throw new IllegalArgumentException("Actual chunks per segment should be positive, " + actualChunksPerSegment + " given");
        }
        this.actualChunksPerSegment = actualChunksPerSegment;
        return this;
    }

    private void checkActualChunksPerSegmentIsConfiguredOnlyIfOtherLowLevelConfigsAreManual() {
        if (this.actualChunksPerSegment > 0L && (this.entriesPerSegment <= 0L || this.actualChunkSize <= 0 && !this.constantlySizedEntries() || this.actualSegments <= 0)) {
            throw new IllegalStateException("Actual chunks per entry could be configured only if other three low level configs are manual: entriesPerSegment(), actualSegments() and actualChunkSize(), unless both keys and value sizes are constant");
        }
    }

    private void checkActualChunksPerSegmentGreaterOrEqualToEntries() {
        if (this.actualChunksPerSegment > 0L && this.entriesPerSegment > 0L && this.entriesPerSegment > this.actualChunksPerSegment) {
            throw new IllegalStateException("Entries per segment couldn't be greater than actual chunks per segment. Entries: " + this.entriesPerSegment + ", " + "chunks: " + this.actualChunksPerSegment + " is configured");
        }
    }

    long actualChunksPerSegment(boolean replicated) {
        if (this.actualChunksPerSegment > 0L) {
            return this.actualChunksPerSegment;
        }
        return Math.round((double)this.entriesPerSegment(replicated) * this.averageChunksPerEntry(replicated));
    }

    private long totalEntriesIfPoorDistribution(int segments) {
        long s3;
        if (segments == 1) {
            return this.entries();
        }
        long entries = this.entries();
        entries = entries * 4L <= (s3 = (long)Math.min(8, segments) * (long)Math.min(32, segments) * (long)Math.min(128, segments)) ? (long)((double)entries * 1.8) : (entries <= s3 ? (long)((double)entries * 1.45) : (entries <= s3 * 4L ? (long)((double)entries * 1.33) : (entries <= s3 * 8L ? (long)((double)entries * 1.22) : (entries <= s3 * 16L ? (long)((double)entries * 1.15) : (long)((double)entries * 1.1)))));
        return Math.min((long)segments * this.entries(), entries + (long)(4 * segments) + 8L);
    }

    @Override
    public ChronicleMapBuilder<K, V> minSegments(int minSegments) {
        ChronicleMapBuilder.checkSegments(minSegments);
        this.minSegments = minSegments;
        return this;
    }

    int minSegments() {
        return Math.max(this.estimateSegments(), this.minSegments);
    }

    private int estimateSegments() {
        return (int)Math.min(Maths.nextPower2((long)(this.entries() / 32L), (long)1L), (long)this.estimateSegmentsBasedOnSize());
    }

    private int estimateSegmentsBasedOnSize() {
        int segmentsForEntries = ChronicleMapBuilder.estimateSegmentsForEntries(this.entries());
        double averageValueSize = this.averageValueSize();
        return averageValueSize >= 1000000.0 ? segmentsForEntries * 16 : (averageValueSize >= 100000.0 ? segmentsForEntries * 8 : (averageValueSize >= 10000.0 ? segmentsForEntries * 4 : (averageValueSize >= 1000.0 ? segmentsForEntries * 2 : segmentsForEntries)));
    }

    private static int estimateSegmentsForEntries(long size) {
        if (size > 0xC800000L) {
            return 256;
        }
        if (size >= 0x100000L) {
            return 128;
        }
        if (size >= 131072L) {
            return 64;
        }
        if (size >= 16384L) {
            return 32;
        }
        if (size >= 4096L) {
            return 16;
        }
        if (size >= 1024L) {
            return 8;
        }
        return 1;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualSegments(int actualSegments) {
        ChronicleMapBuilder.checkSegments(actualSegments);
        this.actualSegments = actualSegments;
        return this;
    }

    int actualSegments(boolean replicated) {
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        if (this.entriesPerSegment > 0L) {
            long segments = 1L;
            for (int i = 0; i < 3; ++i) {
                long totalEntries = this.totalEntriesIfPoorDistribution((int)segments);
                if ((segments = ChronicleMapBuilder.divideUpper(totalEntries, this.entriesPerSegment)) <= 0x40000000L) continue;
                throw new IllegalStateException();
            }
            if (this.minSegments > 0) {
                segments = Math.max((long)this.minSegments, segments);
            }
            return (int)segments;
        }
        long shortMMapSegments = this.trySegments(65536L, 0x100000, replicated);
        if (shortMMapSegments > 0L) {
            return (int)shortMMapSegments;
        }
        long intMMapSegments = this.trySegments(0x100000000L, 0x40000000, replicated);
        if (intMMapSegments > 0L) {
            return (int)intMMapSegments;
        }
        throw new IllegalStateException("Max segments is 1073741824, configured so much entries (" + this.entries() + ") or average chunks per entry is too high (" + this.averageChunksPerEntry(replicated) + ") that builder automatically decided to use " + -intMMapSegments + " segments");
    }

    private long trySegments(long maxSegmentCapacity, int maxSegments, boolean replicated) {
        long totalChunks = Math.round((double)this.totalEntriesIfPoorDistribution(this.minSegments()) * this.averageChunksPerEntry(replicated));
        long segments = ChronicleMapBuilder.divideUpper(totalChunks, maxSegmentCapacity);
        return (segments = Maths.nextPower2((long)Math.max(segments, (long)this.minSegments()), (long)1L)) <= (long)maxSegments ? segments : -segments;
    }

    int segmentHeaderSize(boolean replicated) {
        int segments = this.actualSegments(replicated);
        return segments <= 16384 ? 64 : 32;
    }

    MultiMapFactory multiMapFactory(boolean replicated) {
        return MultiMapFactory.forCapacity(this.actualChunksPerSegment(replicated));
    }

    @Override
    public ChronicleMapBuilder<K, V> lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.lockTimeOut = lockTimeOut;
        this.lockTimeOutUnit = unit;
        return this;
    }

    long lockTimeOut(TimeUnit unit) {
        return unit.convert(this.lockTimeOut, this.lockTimeOutUnit);
    }

    @Override
    public ChronicleMapBuilder<K, V> errorListener(ChronicleHashErrorListener errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    ChronicleHashErrorListener errorListener() {
        return this.errorListener;
    }

    public ChronicleMapBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public ChronicleMapBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public ChronicleMapBuilder<K, V> metaDataBytes(int metaDataBytes) {
        if (metaDataBytes < 0 || metaDataBytes > 255) {
            throw new IllegalArgumentException("MetaDataBytes must be [0..255] was " + metaDataBytes);
        }
        this.metaDataBytes = metaDataBytes;
        return this;
    }

    int metaDataBytes() {
        return this.metaDataBytes;
    }

    public String toString() {
        return "ChronicleMapBuilder{name=" + this.name + ", actualSegments=" + ChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + ChronicleMapBuilder.pretty(this.minSegments) + ", entriesPerSegment=" + ChronicleMapBuilder.pretty(this.entriesPerSegment) + ", actualChunksPerSegment=" + ChronicleMapBuilder.pretty(this.actualChunksPerSegment) + ", averageKeySize=" + ChronicleMapBuilder.pretty(this.averageKeySize) + ", sampleKeyForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleKey) + ", averageValueSize=" + ChronicleMapBuilder.pretty(this.averageValueSize) + ", sampleValueForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleValue) + ", actualChunkSize=" + ChronicleMapBuilder.pretty(this.actualChunkSize) + ", valueAlignment=" + (Object)((Object)this.valueAlignment()) + ", entries=" + this.entries() + ", lockTimeOut=" + this.lockTimeOut + " " + (Object)((Object)this.lockTimeOutUnit) + ", metaDataBytes=" + this.metaDataBytes() + ", errorListener=" + this.errorListener() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerFactory=" + ChronicleMapBuilder.pretty(this.bytesMarshallerFactory) + ", objectSerializer=" + ChronicleMapBuilder.pretty(this.objectSerializer) + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + ", eventListener=" + this.eventListener + ", defaultValue=" + this.defaultValue + ", defaultValueProvider=" + ChronicleMapBuilder.pretty(this.defaultValueProvider) + ", prepareValueBytes=" + ChronicleMapBuilder.pretty(this.prepareValueBytes) + '}';
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleMapBuilder<K, V> timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    TimeProvider timeProvider() {
        return this.timeProvider;
    }

    BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory == null ? (this.bytesMarshallerFactory = new VanillaBytesMarshallerFactory()) : this.bytesMarshallerFactory;
    }

    @Override
    public ChronicleMapBuilder<K, V> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        return this;
    }

    ObjectSerializer acquireObjectSerializer(ObjectSerializer defaultSerializer) {
        return this.objectSerializer == null ? BytesMarshallableSerializer.create((BytesMarshallerFactory)this.bytesMarshallerFactory(), (ObjectSerializer)defaultSerializer) : this.objectSerializer;
    }

    @Override
    public ChronicleMapBuilder<K, V> objectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshaller(@NotNull BytesMarshaller<? super K> keyMarshaller) {
        this.keyBuilder.marshaller(keyMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(@NotNull BytesWriter<K> keyWriter, @NotNull BytesReader<K> keyReader) {
        this.keyBuilder.writer(keyWriter);
        this.keyBuilder.reader(keyReader);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.keyBuilder.sizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyDeserializationFactory(@NotNull ObjectFactory<K> keyDeserializationFactory) {
        this.keyBuilder.factory(keyDeserializationFactory);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> immutableKeys() {
        this.keyBuilder.instancesAreMutable(false);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshaller(@NotNull BytesMarshaller<? super V> valueMarshaller) {
        this.valueBuilder.marshaller(valueMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull BytesWriter<V> valueWriter, @NotNull BytesReader<V> valueReader) {
        this.valueBuilder.writer(valueWriter);
        this.valueBuilder.reader(valueReader);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueSizeMarshaller(@NotNull SizeMarshaller valueSizeMarshaller) {
        this.valueBuilder.sizeMarshaller(valueSizeMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueDeserializationFactory(@NotNull ObjectFactory<V> valueDeserializationFactory) {
        this.valueBuilder.factory(valueDeserializationFactory);
        return this;
    }

    public ChronicleMapBuilder<K, V> eventListener(MapEventListener<K, V> eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    MapEventListener<K, V> eventListener() {
        return this.eventListener;
    }

    public ChronicleMapBuilder<K, V> bytesEventListener(BytesMapEventListener eventListener) {
        this.bytesEventListener = eventListener;
        return this;
    }

    BytesMapEventListener bytesEventListener() {
        return this.bytesEventListener;
    }

    public ChronicleMapBuilder<K, V> defaultValue(V defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("default ChronicleMap value couldn't be null");
        }
        this.defaultValue = defaultValue;
        this.defaultValueProvider = null;
        this.prepareValueBytes = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        this.defaultValueProvider = defaultValueProvider;
        this.defaultValue = null;
        this.prepareValueBytes = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> prepareDefaultValueBytes(@NotNull PrepareValueBytes<K, V> prepareValueBytes) {
        this.prepareValueBytes = prepareValueBytes;
        this.defaultValue = null;
        this.defaultValueProvider = null;
        this.checkPrepareValueBytesOnlyIfConstantValueSize();
        return this;
    }

    private void checkPrepareValueBytesOnlyIfConstantValueSize() {
        if (this.prepareValueBytes != null && !this.constantlySizedValues()) {
            throw new IllegalStateException("Prepare value bytes could be used only if value size is constant");
        }
    }

    PrepareValueBytesAsWriter<K> prepareValueBytesAsWriter() {
        PrepareValueBytes<K, V> prepareValueBytes = this.prepareValueBytes;
        if (prepareValueBytes == null && this.defaultValueProvider() != null || !this.constantlySizedValues()) {
            return null;
        }
        long constantValueSize = this.constantValueSize();
        if (prepareValueBytes == null) {
            prepareValueBytes = new ZeroOutValueBytes(constantValueSize);
        }
        return new PrepareValueBytesAsWriter<K>(prepareValueBytes, constantValueSize);
    }

    DefaultValueProvider<K, V> defaultValueProvider() {
        if (this.defaultValueProvider != null) {
            return this.defaultValueProvider;
        }
        if (this.defaultValue == null) {
            return null;
        }
        Object originalValueWriter = this.valueBuilder.interop();
        Provider writerProvider = Provider.of(originalValueWriter.getClass());
        ThreadLocalCopies copies = writerProvider.getCopies(null);
        Object valueWriter = writerProvider.get(copies, originalValueWriter);
        MetaProvider<V, ?, MetaBytesInterop<V, ?>> metaWriterProvider = this.valueBuilder.metaInteropProvider();
        copies = metaWriterProvider.getCopies(copies);
        MetaBytesInterop<V, ?> metaValueWriter = metaWriterProvider.get(copies, this.valueBuilder.metaInterop(), valueWriter, this.defaultValue);
        return new ConstantValueProvider(this.defaultValue, metaValueWriter, valueWriter);
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(SingleChronicleHashReplication replication) {
        this.singleHashReplication = replication;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier) {
        return this.replication(SingleChronicleHashReplication.builder().createWithId(identifier));
    }

    @Override
    public ChronicleMapBuilder<K, V> replication(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return this.replication(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> instance() {
        return new MapInstanceConfig(this.clone(), this.singleHashReplication, null, null, null, new AtomicBoolean(false));
    }

    @Override
    public ChronicleMap<K, V> createStatelessClient(InetSocketAddress serverAddress) throws IOException {
        return this.statelessClient(serverAddress).create();
    }

    ChronicleMap<K, V> createStatelessClient(StatelessMapConfig<K, V> statelessClientConfig) throws IOException {
        this.pushingToMapEventListener();
        this.preMapConstruction(false);
        return new StatelessChronicleMap(statelessClientConfig, this);
    }

    @Override
    public ChronicleMap<K, V> createPersistedTo(File file) throws IOException {
        return ((ChronicleMapBuilder)this.clone()).createWithFile(file, this.singleHashReplication, null);
    }

    @Override
    public StatelessClientConfig<ChronicleMap<K, V>> statelessClient(InetSocketAddress remoteAddress) {
        return new StatelessMapConfig(this.clone(), remoteAddress, DEFAULT_STATELESS_CLIENT_TIMEOUT, null, new AtomicBoolean(false));
    }

    @Override
    public ChronicleMap<K, V> create() {
        return ((ChronicleMapBuilder)this.clone()).createWithoutFile(this.singleHashReplication, null);
    }

    ChronicleMap<K, V> create(MapInstanceConfig<K, V> ib) throws IOException {
        if (ib.file != null) {
            return this.createWithFile(ib.file, ib.singleHashReplication, ib.channel);
        }
        return this.createWithoutFile(ib.singleHashReplication, ib.channel);
    }

    /*
     * Exception decompiling
     */
    ChronicleMap<K, V> createWithFile(File file, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    ChronicleMap<K, V> createWithoutFile(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) {
        try {
            this.pushingToMapEventListener();
            VanillaChronicleMap<K, ?, ?, V, ?, ?> map = this.newMap(singleHashReplication, channel);
            map.warnOnWindows();
            DirectStore bytesStore = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, map.sizeInBytes(), true);
            map.createMappedStoreAndSegments((BytesStore)bytesStore);
            return this.establishReplication(map, singleHashReplication, channel);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void pushingToMapEventListener() {
        if (this.pushToAddresses == null || this.pushToAddresses.length == 0) {
            return;
        }
        try {
            Class<?> pmel = Class.forName("com.higherfrequencytrading.chronicle.enterprise.map.PushingMapEventListener");
            Constructor<?> constructor = pmel.getConstructor(ChronicleMap[].class);
            ChronicleMap[] statelessClients = new ChronicleMap[this.pushToAddresses.length];
            Object cmb = this.clone();
            ((ChronicleMapBuilder)cmb).pushTo(null);
            for (int i = 0; i < this.pushToAddresses.length; ++i) {
                statelessClients[i] = ((ChronicleMapBuilder)cmb).createStatelessClient(this.pushToAddresses[i]);
            }
            this.eventListener = (MapEventListener)constructor.newInstance(new Object[]{statelessClients});
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getLogger((String)this.getClass().getName()).warn("Chronicle Enterprise not found in the class path");
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)this.getClass().getName()).error("PushingMapEventListener failed to load", (Throwable)e);
        }
    }

    private VanillaChronicleMap<K, ?, ?, V, ?, ?> newMap(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        boolean replicated = singleHashReplication != null || channel != null;
        this.preMapConstruction(replicated);
        if (replicated) {
            AbstractReplication replication = singleHashReplication != null ? singleHashReplication : channel.hub();
            return new ReplicatedChronicleMap(this, replication);
        }
        return new VanillaChronicleMap(this);
    }

    void preMapConstruction(boolean replicated) {
        this.keyBuilder.objectSerializer(this.acquireObjectSerializer((ObjectSerializer)JDKObjectSerializer.INSTANCE));
        this.valueBuilder.objectSerializer(this.acquireObjectSerializer((ObjectSerializer)JDKObjectSerializer.INSTANCE));
        double largeKeySize = this.averageKeySize();
        if (!this.constantlySizedKeys()) {
            largeKeySize *= (double)this.figureBufferAllocationFactor();
        }
        this.keyBuilder.maxSize(Math.round(largeKeySize));
        double largeValueSize = this.averageValueSize();
        if (!this.constantlySizedValues()) {
            largeValueSize *= (double)this.figureBufferAllocationFactor();
        }
        this.valueBuilder.maxSize(Math.round(largeValueSize));
        if (this.sampleKey != null) {
            this.keyBuilder.constantSizeBySample(this.sampleKey);
        }
        if (this.sampleValue != null) {
            this.valueBuilder.constantSizeBySample(this.sampleValue);
        }
        this.stateChecks();
    }

    private void stateChecks() {
        if (strictStateChecks) {
            if (this.entries < 0L) {
                throw new IllegalStateException("Entries must be specified");
            }
            if (!this.constantlySizedKeys() && !ChronicleMapBuilder.isDefined(this.averageKeySize)) {
                throw new IllegalStateException("No info about key size");
            }
            if (!this.constantlySizedValues() && !ChronicleMapBuilder.isDefined(this.averageValueSize)) {
                throw new IllegalStateException("No info about value size");
            }
        }
        this.checkAlignmentOnlyIfValuesPossiblyReferenceOffHeap();
        this.checkPrepareValueBytesOnlyIfConstantValueSize();
        this.checkActualChunksPerSegmentIsConfiguredOnlyIfOtherLowLevelConfigsAreManual();
        this.checkActualChunksPerSegmentGreaterOrEqualToEntries();
    }

    private ChronicleMap<K, V> establishReplication(VanillaChronicleMap<K, ?, ?, V, ?, ?> map, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        if (map instanceof ReplicatedChronicleMap) {
            if (singleHashReplication != null && channel != null) {
                throw new AssertionError((Object)"Only one non-null replication should be passed");
            }
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            ArrayList<Replicator> replicators = new ArrayList<Replicator>(2);
            if (singleHashReplication != null) {
                if (singleHashReplication.tcpTransportAndNetwork() != null) {
                    replicators.add(Replicators.tcp(singleHashReplication));
                }
                if (singleHashReplication.udpTransport() != null) {
                    replicators.add(Replicators.udp(singleHashReplication.udpTransport()));
                }
            } else {
                ReplicationHub hub = channel.hub();
                ChannelProvider provider = ChannelProvider.getProvider(hub);
                ChannelProvider.ChronicleChannel ch = provider.createChannel(channel.channelId());
                replicators.add(ch);
            }
            for (Replicator replicator : replicators) {
                Closeable token = replicator.applyTo(this, result, result, map);
                if (replicators.size() == 1 && token.getClass() == UdpReplicator.class) {
                    LOG.warn("MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator");
                }
                result.addCloseable(token);
            }
        }
        return map;
    }

    private int figureBufferAllocationFactor() {
        return (int)Math.min(Math.max(2L, this.entries() >> 10), (long)Math.min(64, this.maxChunksPerEntry()));
    }

    static class EntrySizeInfo {
        final double averageEntrySize;
        final int worstAlignment;

        public EntrySizeInfo(double averageEntrySize, int worstAlignment) {
            this.averageEntrySize = averageEntrySize;
            this.worstAlignment = worstAlignment;
        }
    }
}

