/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.internal.CopyingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DataValueMetaBytesInterop;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.threadlocal.StatefulCopyable;

class DirectBytesBuffer
implements StatefulCopyable<DirectBytesBuffer>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Serializable identity;
    transient DirectBytes buffer;
    transient ForBytesMarshaller forBytesMarshaller;
    transient ForBytesWriter forBytesWriter;
    transient ForDataValueWriter forDataValueWriter;

    DirectBytesBuffer(Serializable identity) {
        this.identity = identity;
        this.initTransients();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.forBytesMarshaller = new ForBytesMarshaller();
        this.forBytesWriter = new ForBytesWriter();
        this.forDataValueWriter = new ForDataValueWriter();
    }

    Bytes obtain(long maxSize) {
        DirectBytes buf = this.buffer;
        if (buf != null) {
            if (maxSize <= buf.capacity()) {
                return buf.clear();
            }
            DirectStore store = (DirectStore)buf.store();
            store.resize(maxSize, false);
            this.buffer = store.bytes();
            return this.buffer;
        }
        this.buffer = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, maxSize, false).bytes();
        return this.buffer;
    }

    public Object stateIdentity() {
        return this.identity;
    }

    public DirectBytesBuffer copy() {
        return new DirectBytesBuffer(this.identity);
    }

    class ForDataValueWriter<E>
    extends DataValueMetaBytesInterop<E> {
        private ForDataValueWriter() {
            super(DirectBytesBuffer.this);
        }
    }

    class ForBytesWriter<E, W extends BytesWriter<E>>
    extends CopyingMetaBytesInterop<E, W> {
        private static final long serialVersionUID = 0L;

        private ForBytesWriter() {
            super(DirectBytesBuffer.this);
        }

        @Override
        void innerWrite(W writer, Bytes bytes, E e) {
            writer.write(bytes, e);
        }
    }

    class ForBytesMarshaller<E, M extends BytesMarshaller<E>>
    extends CopyingMetaBytesInterop<E, M> {
        private static final long serialVersionUID = 0L;

        private ForBytesMarshaller() {
            super(DirectBytesBuffer.this);
        }

        @Override
        void innerWrite(M writer, Bytes bytes, E e) {
            writer.write(bytes, e);
        }
    }
}

