/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.xstreem.convertors;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.values.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValueConverter
implements Converter {
    private static final Logger LOG = LoggerFactory.getLogger(DataValueConverter.class);

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        String canonicalName = o.getClass().getCanonicalName();
        boolean isNative = canonicalName.endsWith("$$Native");
        boolean isHeap = canonicalName.endsWith("$$Heap");
        if (!isNative && !isHeap) {
            return;
        }
        if (canonicalName.startsWith("net.openhft.lang.values")) {
            Method[] methods;
            for (Method method : methods = o.getClass().getMethods()) {
                if (!method.getName().equals("getValue") || method.getParameterTypes().length != 0) continue;
                try {
                    context.convertAnother(method.invoke(o, new Object[0]));
                    return;
                }
                catch (Exception e) {
                    throw new ConversionException("class=" + canonicalName, (Throwable)e);
                }
            }
            throw new ConversionException("class=" + canonicalName);
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor p : info.getPropertyDescriptors()) {
                if (p instanceof IndexedPropertyDescriptor) {
                    try {
                        Class<?> returnType;
                        IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)p;
                        Method indexedReadMethod = indexedPropertyDescriptor.getIndexedReadMethod();
                        if (indexedReadMethod == null || (returnType = indexedReadMethod.getReturnType()) == null) continue;
                        String simpleName = returnType.getSimpleName();
                        String fieldName = "_" + DataValueConverter.toCamelCase(simpleName);
                        Field field = o.getClass().getDeclaredField(fieldName);
                        field.setAccessible(true);
                        Object[] o1 = (Object[])field.get(o);
                        if (o1 == null) continue;
                        int i = 0;
                        for (Object f : o1) {
                            writer.startNode(Integer.toString(i++));
                            context.convertAnother(f);
                            writer.endNode();
                        }
                    }
                    catch (IllegalAccessException | NoSuchFieldException e1) {
                        LOG.error("", (Throwable)e1);
                    }
                }
                if (p.getName().equals("Class") || p.getReadMethod() == null || p.getWriteMethod() == null) continue;
                try {
                    Method readMethod = p.getReadMethod();
                    Object value = readMethod.invoke(o, new Object[0]);
                    if (value == null) {
                        return;
                    }
                    writer.startNode(p.getDisplayName());
                    context.convertAnother(value);
                    writer.endNode();
                }
                catch (Exception e) {
                    LOG.error("class=" + p.getName(), (Throwable)e);
                }
            }
        }
        catch (IntrospectionException e) {
            throw new ConversionException("class=" + canonicalName, (Throwable)e);
        }
    }

    static String toCamelCase(String s) {
        StringBuilder b = new StringBuilder();
        if (s.length() > 0) {
            b.append(Character.toLowerCase(s.charAt(0)));
        }
        if (s.length() > 0) {
            b.append(s.substring(1));
        }
        return b.toString();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String canonicalName = context.getRequiredType().getCanonicalName();
        boolean isNative = canonicalName.endsWith("$$Native");
        boolean isHeap = canonicalName.endsWith("$$Heap");
        if (!isNative && !isHeap) {
            return null;
        }
        if (context.getRequiredType().getCanonicalName().startsWith("net.openhft.lang.values")) {
            return DataValueConverter.toNativeValueObjects(reader, context.getRequiredType(), context);
        }
        String nodeName = isNative ? canonicalName.substring(0, canonicalName.length() - "$$Native".length()) : canonicalName.substring(0, canonicalName.length() - "$$Heap".length());
        try {
            Class<?> interfaceClass = Class.forName(nodeName);
            Object result = isNative ? DataValueClasses.newDirectInstance(interfaceClass) : DataValueClasses.newInstance(interfaceClass);
            BeanInfo beanInfo = Introspector.getBeanInfo(result.getClass());
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String name = reader.getNodeName();
                for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                    Class<?>[] parameterTypes;
                    if (!descriptor.getName().equals(name) || (parameterTypes = descriptor.getWriteMethod().getParameterTypes()).length != 1) continue;
                    Object object = context.convertAnother(null, parameterTypes[0]);
                    try {
                        descriptor.getWriteMethod().invoke(result, object);
                    }
                    catch (Exception e) {
                        LOG.error("", (Throwable)e);
                    }
                    break;
                }
                reader.moveUp();
            }
            return result;
        }
        catch (Exception e) {
            throw new ConversionException("class=" + canonicalName, (Throwable)e);
        }
    }

    static Object toNativeValueObjects(HierarchicalStreamReader reader, Class aClass, UnmarshallingContext context) {
        Object o = DataValueClasses.newDirectInstance((Class)aClass);
        try {
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor p : info.getPropertyDescriptors()) {
                if (!p.getName().equals("value")) continue;
                String value = reader.getValue();
                if (StringValue.class.isAssignableFrom(o.getClass())) {
                    ((StringValue)o).setValue((CharSequence)value);
                    return o;
                }
                Class<?> propertyType = p.getPropertyType();
                Object o1 = context.convertAnother((Object)value, propertyType);
                p.getWriteMethod().invoke(o, o1);
                return o;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new ConversionException("setValue(..) method not found in class=" + aClass.getCanonicalName());
    }

    public boolean canConvert(Class clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName.startsWith("net.openhft.lang.values") || canonicalName.endsWith("$$Native") || canonicalName.endsWith("$$Heap");
    }
}

