/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.FindByName;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapInstanceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicationHubFindByName<K>
implements FindByName {
    public static final Logger LOG = LoggerFactory.getLogger((String)ReplicationHubFindByName.class.getName());
    public static final int MAP_BY_NAME_CHANNEL = 1;
    private final AtomicInteger nextFreeChannel = new AtomicInteger(2);
    private final Map<String, MapInstanceConfig> map;
    private final ReplicationHub replicationHub;

    public ReplicationHubFindByName(ReplicationHub replicationHub) throws IOException {
        LOG.info("connecting to replicationHub=" + replicationHub);
        this.replicationHub = replicationHub;
        ReplicationChannel channel = replicationHub.createChannel(1);
        MapEventListener<CharSequence, MapInstanceConfig> listener = new MapEventListener<CharSequence, MapInstanceConfig>(){

            @Override
            public void onPut(CharSequence key, MapInstanceConfig value, MapInstanceConfig replacedValue) {
                boolean added;
                super.onPut(key, value, replacedValue);
                boolean bl = added = replacedValue == null;
                if (!added || value == null) {
                    return;
                }
                LOG.info("create new map for name=" + value.name + ",channelId=" + value.channel.channelId());
                try {
                    ReplicationHubFindByName.this.toReplicatedViaChannel(value.mapBuilder, value.channel.channelId()).create();
                }
                catch (IllegalStateException e) {
                    LOG.debug("while creating channel for name=" + value.name + ",channelId=" + value.channel.channelId(), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        };
        this.map = ((ChronicleMapBuilder)((ChronicleMapBuilder)ChronicleMapBuilder.of(CharSequence.class, MapInstanceConfig.class).entrySize(4000)).entries(128L)).eventListener(listener).instance().replicatedViaChannel(channel).create();
        if (LOG.isDebugEnabled()) {
            LOG.debug("map=" + this.map);
        }
    }

    public <T extends ChronicleHash> T create(MapInstanceConfig<CharSequence, CharSequence> config) throws IOException, TimeoutException, InterruptedException {
        int withChannelId = this.nextFreeChannel.incrementAndGet();
        this.map.put(config.name, (MapInstanceConfig)config.replicatedViaChannel(this.replicationHub.createChannel(withChannelId)));
        return (T)this.get((String)config.name).mapBuilder.create();
    }

    @Override
    public <T extends ChronicleHash> T from(String name) throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        return (T)this.get(name).create();
    }

    MapInstanceConfig get(String name) throws IllegalArgumentException, TimeoutException, InterruptedException {
        MapInstanceConfig config = this.waitTillEntryReceived(5000, name);
        if (config == null) {
            throw new IllegalArgumentException("A map name=" + name + " can not be found.");
        }
        return config;
    }

    private MapInstanceConfig waitTillEntryReceived(int timeOutMs, String name) throws TimeoutException, InterruptedException {
        for (int t = 0; t < timeOutMs; ++t) {
            MapInstanceConfig config = this.map.get(name);
            if (config != null) {
                return config;
            }
            Thread.sleep(1L);
        }
        throw new TimeoutException("timed out wait for map name=" + name);
    }

    public <T extends ChronicleHash> T createPersistedTo(String name, File file) throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        return (T)((MapInstanceConfig)this.get(name).persistedTo(file)).create();
    }

    private ChronicleHashInstanceConfig toReplicatedViaChannel(ChronicleMapBuilder builder) {
        int channelId = this.nextFreeChannel.incrementAndGet();
        if (channelId > this.replicationHub.maxNumberOfChannels()) {
            throw new IllegalStateException("There are no more free channels, you can increase the number of changes in the replicationHub by calling replicationHub.maxNumberOfChannels(..);");
        }
        return builder.instance().replicatedViaChannel(this.replicationHub.createChannel((short)channelId));
    }

    private ChronicleHashInstanceConfig toReplicatedViaChannel(ChronicleHashBuilder<K, ?, ?> builder, int withChannelId) {
        return builder.instance().replicatedViaChannel(this.replicationHub.createChannel((short)withChannelId));
    }
}

