/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValue;

class SetFromMap<E>
extends AbstractSet<E>
implements ChronicleSet<E>,
Serializable {
    private final ChronicleMap<E, DummyValue> m;
    private transient Set<E> s;
    private static final long serialVersionUID = 2454657854757543876L;

    SetFromMap(ChronicleMap<E, DummyValue> map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("Map is non-empty");
        }
        this.m = map;
        this.s = map.keySet();
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o) == DummyValue.DUMMY_VALUE;
    }

    @Override
    public boolean add(E e) {
        return this.m.putIfAbsent(e, DummyValue.DUMMY_VALUE) == null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.s.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.s.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.s.toArray(a);
    }

    @Override
    public String toString() {
        return this.s.toString();
    }

    @Override
    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.s.equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.s.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.s.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.s.retainAll(c);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.s = this.m.keySet();
    }

    @Override
    public long longSize() {
        return this.m.longSize();
    }

    @Override
    public File file() {
        return this.m.file();
    }

    @Override
    public void close() throws IOException {
        this.m.close();
    }
}

