/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.Hasher;
import net.openhft.lang.io.Bytes;

public enum CharArrayMarshaller implements BytesInterop<char[]>,
BytesReader<char[]>
{
    INSTANCE;


    @Override
    public boolean startsWith(Bytes bytes, char[] chars) {
        long pos = bytes.position();
        for (int i = 0; i < chars.length; ++i) {
            if (bytes.readChar(pos + (long)i * 2L) == chars[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hash(char[] chars) {
        return Hasher.hash(chars, chars.length);
    }

    @Override
    public char[] read(Bytes bytes, long size) {
        char[] chars = new char[(int)size];
        bytes.readFully(chars);
        return chars;
    }

    @Override
    public char[] read(Bytes bytes, long size, char[] toReuse) {
        if (toReuse == null || (long)toReuse.length != size) {
            toReuse = new char[(int)size];
        }
        bytes.readFully(toReuse);
        return toReuse;
    }

    @Override
    public long size(char[] chars) {
        return (long)chars.length * 2L;
    }

    @Override
    public void write(Bytes bytes, char[] chars) {
        bytes.write(chars);
    }
}

