/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import org.jetbrains.annotations.NotNull;

public final class ReplicationHub
extends AbstractReplication {
    private final int maxEntrySize;
    private final ReplicationChannel[] channels;

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private ReplicationHub(byte localIdentifier, Builder builder) {
        super(localIdentifier, builder);
        this.maxEntrySize = builder.maxEntrySize;
        this.channels = new ReplicationChannel[builder.maxNumberOfChronicles];
    }

    public int maxEntrySize() {
        return this.maxEntrySize;
    }

    public int maxNumberOfChannels() {
        return this.channels.length;
    }

    public synchronized ReplicationChannel createChannel(short channelId) {
        ReplicationChannel channel;
        if (channelId < 0) {
            throw new IllegalArgumentException("channelId should be positive");
        }
        if (channelId >= this.maxNumberOfChannels()) {
            throw new IllegalArgumentException("maxNumberOfChannels is configured (or defaulted) to " + this.maxNumberOfChannels() + ", channelId=" + channelId + " is requested");
        }
        if (this.channels[channelId] != null) {
            throw new IllegalStateException("The requested channelId=" + channelId + " is already in use");
        }
        this.channels[channelId] = channel = new ReplicationChannel(this, channelId);
        return channel;
    }

    public static final class Builder
    extends AbstractReplication.Builder<ReplicationHub, Builder> {
        private int maxEntrySize = 1024;
        private int maxNumberOfChronicles = 128;

        private Builder() {
        }

        @NotNull
        public Builder maxEntrySize(int maxEntrySize) {
            this.maxEntrySize = maxEntrySize;
            return this;
        }

        @NotNull
        public Builder maxNumberOfChannels(int maxNumberOfChannels) {
            this.maxNumberOfChronicles = maxNumberOfChannels;
            return this;
        }

        @Override
        @NotNull
        public ReplicationHub createWithId(byte identifier) {
            this.check(identifier);
            return new ReplicationHub(identifier, this);
        }
    }
}

