/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import net.openhft.chronicle.map.Objects;
import net.openhft.chronicle.map.serialization.AgileBytesMarshaller;
import net.openhft.chronicle.map.serialization.BytesInterop;
import net.openhft.chronicle.map.serialization.BytesReader;
import net.openhft.chronicle.map.serialization.BytesWriter;
import net.openhft.chronicle.map.serialization.CopyingMetaBytesInterop;
import net.openhft.chronicle.map.serialization.DelegatingMetaBytesInteropProvider;
import net.openhft.chronicle.map.serialization.MetaBytesInterop;
import net.openhft.chronicle.map.serialization.MetaProvider;
import net.openhft.chronicle.map.serialization.SizeMarshaller;
import net.openhft.chronicle.map.serialization.SizeMarshallers;
import net.openhft.chronicle.map.serialization.impl.ByteArrayMarshaller;
import net.openhft.chronicle.map.serialization.impl.ByteableMarshaller;
import net.openhft.chronicle.map.serialization.impl.CharSequenceReader;
import net.openhft.chronicle.map.serialization.impl.CharSequenceWriter;
import net.openhft.chronicle.map.serialization.impl.LongMarshaller;
import net.openhft.chronicle.map.threadlocal.Provider;
import net.openhft.chronicle.map.threadlocal.ThreadLocalCopies;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.AllocateInstanceObjectFactory;
import net.openhft.lang.io.serialization.impl.BytesMarshallableMarshaller;
import net.openhft.lang.io.serialization.impl.ExternalizableMarshaller;
import net.openhft.lang.io.serialization.impl.NewInstanceObjectFactory;
import net.openhft.lang.io.serialization.impl.NullObjectFactory;
import net.openhft.lang.model.Byteable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SerializationBuilder<E>
implements Cloneable {
    private final Serializable bufferIdentity;
    final Class<E> eClass;
    private boolean instancesAreMutable;
    private SizeMarshaller sizeMarshaller = SizeMarshallers.stopBit();
    private BytesReader<E> reader;
    private Object interop;
    private CopyingInterop copyingInterop = null;
    private MetaBytesInterop<E, ?> metaInterop;
    private MetaProvider<E, ?, ?> metaInteropProvider;
    private long maxSize;
    private ObjectFactory<E> factory;

    private static boolean concreteClass(Class c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    private static boolean marshallerUseFactory(Class c) {
        return Byteable.class.isAssignableFrom(c) || BytesMarshallable.class.isAssignableFrom(c) || Externalizable.class.isAssignableFrom(c);
    }

    private static boolean instancesAreMutable(Class c) {
        return c != String.class;
    }

    SerializationBuilder(Class<E> eClass, Role role) {
        BytesMarshaller<E> marshaller;
        this.bufferIdentity = role;
        this.eClass = eClass;
        this.instancesAreMutable = SerializationBuilder.instancesAreMutable(eClass);
        NullObjectFactory factory = null;
        if (role == Role.VALUE) {
            Object object = factory = SerializationBuilder.concreteClass(eClass) && SerializationBuilder.marshallerUseFactory(eClass) ? new NewInstanceObjectFactory(eClass) : NullObjectFactory.INSTANCE;
        }
        if (SerializationBuilder.concreteClass(eClass) && Byteable.class.isAssignableFrom(eClass)) {
            this.agileMarshaller(ByteableMarshaller.of(eClass), (ObjectFactory<E>)factory);
        } else if (eClass == CharSequence.class || eClass == String.class) {
            this.reader((BytesReader<E>)CharSequenceReader.of(), (ObjectFactory<E>)factory);
            this.writer(CharSequenceWriter.instance());
        } else if (eClass == Long.class) {
            this.agileMarshaller(LongMarshaller.INSTANCE, (ObjectFactory<E>)factory);
        } else if (eClass == byte[].class) {
            this.reader(ByteArrayMarshaller.INSTANCE, (ObjectFactory<E>)factory);
            this.interop(ByteArrayMarshaller.INSTANCE);
        } else if (SerializationBuilder.concreteClass(eClass) && (marshaller = this.chooseMarshaller(eClass, eClass)) != null) {
            this.marshaller(marshaller, (ObjectFactory<E>)factory);
        }
        if (role == Role.VALUE && SerializationBuilder.concreteClass(eClass) && SerializationBuilder.marshallerUseFactory(eClass)) {
            this.factory((ObjectFactory<E>)factory);
        }
    }

    private BytesMarshaller<E> chooseMarshaller(Class<E> eClass, Class<E> classForMarshaller) {
        if (BytesMarshallable.class.isAssignableFrom(eClass)) {
            return new BytesMarshallableMarshaller(classForMarshaller);
        }
        if (Externalizable.class.isAssignableFrom(eClass)) {
            return new ExternalizableMarshaller(classForMarshaller);
        }
        if (eClass == Integer.class) {
            return IntegerMarshaller.INSTANCE;
        }
        if (eClass == Double.class) {
            return DoubleMarshaller.INSTANCE;
        }
        return null;
    }

    private SerializationBuilder<E> copyingInterop(CopyingInterop copyingInterop) {
        this.copyingInterop = copyingInterop;
        return this;
    }

    public SerializationBuilder<E> agileMarshaller(AgileBytesMarshaller<E> agileBytesMarshaller, ObjectFactory<E> factory) {
        if (factory == null) {
            factory = this.factory;
        }
        return this.sizeMarshaller(agileBytesMarshaller).reader(agileBytesMarshaller, factory).interop(agileBytesMarshaller);
    }

    public SerializationBuilder<E> interop(BytesInterop<E> interop) {
        return super.metaInteropProvider(DelegatingMetaBytesInteropProvider.instance());
    }

    public SerializationBuilder<E> writer(BytesWriter<E> writer) {
        return super.metaInterop(CopyingMetaBytesInterop.forBytesWriter(this.bufferIdentity));
    }

    public SerializationBuilder<E> marshaller(BytesMarshaller<E> marshaller, ObjectFactory<E> factory) {
        if (factory == null) {
            factory = this.factory;
        }
        return super.metaInterop(CopyingMetaBytesInterop.forBytesMarshaller(this.bufferIdentity));
    }

    public SerializationBuilder<E> maxSize(long maxSize) {
        if (this.copyingInterop == CopyingInterop.FROM_MARSHALLER) {
            this.maxSize = maxSize;
            this.metaInteropProvider(CopyingMetaBytesInterop.providerForBytesMarshaller(this.instancesAreMutable, maxSize));
        } else if (this.copyingInterop == CopyingInterop.FROM_WRITER) {
            this.maxSize = maxSize;
            this.metaInteropProvider(CopyingMetaBytesInterop.providerForBytesWriter(this.instancesAreMutable, maxSize));
        }
        return this;
    }

    public SerializationBuilder<E> constantSizeBySample(E sampleObject) {
        MetaBytesInterop<E, ?> metaInterop;
        Object interop;
        block5: {
            MetaProvider<E, ?, ?> metaInteropProvider;
            Object originalInterop = this.interop;
            Provider<?> interopProvider = Provider.of(originalInterop.getClass());
            ThreadLocalCopies copies = interopProvider.getCopies(null);
            interop = interopProvider.get(copies, originalInterop);
            copies = this.metaInteropProvider.getCopies(copies);
            if (this.maxSize > 0L) {
                while (true) {
                    metaInteropProvider = this.metaInteropProvider;
                    try {
                        metaInterop = metaInteropProvider.get(copies, this.metaInterop, interop, sampleObject);
                        break block5;
                    }
                    catch (Exception e) {
                        if (this.maxSize > 0x20000000L) {
                            throw e;
                        }
                        this.maxSize(this.maxSize * 2L);
                        continue;
                    }
                    break;
                }
            }
            metaInteropProvider = this.metaInteropProvider;
            metaInterop = metaInteropProvider.get(copies, this.metaInterop, interop, sampleObject);
        }
        long constantSize = metaInterop.size(interop, sampleObject);
        this.maxSize(constantSize);
        this.sizeMarshaller(SizeMarshallers.constant(constantSize));
        return this;
    }

    public SerializationBuilder<E> objectSerializer(ObjectSerializer serializer) {
        if (this.reader == null || this.interop == null) {
            NullObjectFactory factory = this.factory;
            if (factory == null) {
                factory = NullObjectFactory.INSTANCE;
            }
            this.marshaller(new SerializableMarshaller(serializer), (ObjectFactory<E>)factory);
        }
        return this;
    }

    public SerializationBuilder<E> instancesAreMutable(boolean mutable) {
        this.instancesAreMutable = mutable;
        return this;
    }

    public SizeMarshaller sizeMarshaller() {
        return this.sizeMarshaller;
    }

    public SerializationBuilder<E> sizeMarshaller(SizeMarshaller sizeMarshaller) {
        this.sizeMarshaller = sizeMarshaller;
        return this;
    }

    public BytesReader<E> reader() {
        return this.reader;
    }

    public SerializationBuilder<E> reader(BytesReader<E> reader, ObjectFactory<E> factory) {
        this.reader = reader;
        if (factory != null) {
            this.factory = factory;
        }
        return this;
    }

    public Object interop() {
        return this.interop;
    }

    private SerializationBuilder<E> setInterop(Object interop) {
        this.interop = interop;
        return this;
    }

    public MetaBytesInterop<E, ?> metaInterop() {
        return this.metaInterop;
    }

    private SerializationBuilder<E> metaInterop(MetaBytesInterop<E, ?> metaInterop) {
        this.metaInterop = metaInterop;
        return this;
    }

    public MetaProvider<E, ?, MetaBytesInterop<E, ?>> metaInteropProvider() {
        return this.metaInteropProvider;
    }

    private SerializationBuilder<E> metaInteropProvider(MetaProvider<E, ?, ?> metaInteropProvider) {
        this.metaInteropProvider = metaInteropProvider;
        return this;
    }

    public ObjectFactory<E> factory() {
        return this.factory;
    }

    public SerializationBuilder<E> factory(ObjectFactory<E> factory) {
        if (!SerializationBuilder.marshallerUseFactory(this.eClass)) {
            throw new IllegalStateException("Default marshaller for " + this.eClass + " value don't use object factory");
        }
        if (this.interop instanceof ByteableMarshaller) {
            if (factory instanceof AllocateInstanceObjectFactory) {
                this.agileMarshaller(ByteableMarshaller.of(this.eClass), factory);
            } else {
                this.agileMarshaller(ByteableMarshaller.of(this.eClass, factory), factory);
            }
        } else if (this.interop instanceof BytesMarshallableMarshaller) {
            this.interop = factory instanceof AllocateInstanceObjectFactory ? new BytesMarshallableMarshaller(((AllocateInstanceObjectFactory)factory).allocatedClass()) : new BytesMarshallableMarshallerWithCustomFactory<E>(((BytesMarshallableMarshaller)this.interop).marshaledClass(), factory);
        } else if (this.interop instanceof ExternalizableMarshaller) {
            this.interop = factory instanceof AllocateInstanceObjectFactory ? new ExternalizableMarshaller(((AllocateInstanceObjectFactory)factory).allocatedClass()) : new ExternalizableMarshallerWithCustomFactory<E>(((ExternalizableMarshaller)this.interop).marshaledClass(), factory);
        } else {
            throw new IllegalStateException("Change the value factory simultaneously with marshaller using *AndFactory() method");
        }
        this.factory = factory;
        return this;
    }

    public SerializationBuilder<E> clone() {
        try {
            return (SerializationBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class ExternalizableMarshallerWithCustomFactory<T extends Externalizable>
    extends ExternalizableMarshaller<T> {
        private static final long serialVersionUID = 0L;
        @NotNull
        private final ObjectFactory<T> factory;

        ExternalizableMarshallerWithCustomFactory(@NotNull Class<T> tClass, @NotNull ObjectFactory<T> factory) {
            super(tClass);
            this.factory = factory;
        }

        @NotNull
        protected T getInstance() throws Exception {
            return (T)((Externalizable)this.factory.create());
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            ExternalizableMarshallerWithCustomFactory that = (ExternalizableMarshallerWithCustomFactory)((Object)obj);
            return that.marshaledClass() == this.marshaledClass() && that.factory.equals(this.factory);
        }

        public int hashCode() {
            return Objects.hash(this.marshaledClass(), this.factory);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "{marshaledClass=" + this.marshaledClass() + ",factory=" + this.factory + "}";
        }
    }

    private static class BytesMarshallableMarshallerWithCustomFactory<T extends BytesMarshallable>
    extends BytesMarshallableMarshaller<T> {
        private static final long serialVersionUID = 0L;
        @NotNull
        private final ObjectFactory<T> factory;

        BytesMarshallableMarshallerWithCustomFactory(@NotNull Class<T> tClass, @NotNull ObjectFactory<T> factory) {
            super(tClass);
            this.factory = factory;
        }

        @NotNull
        protected T getInstance() throws Exception {
            return (T)((BytesMarshallable)this.factory.create());
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            BytesMarshallableMarshallerWithCustomFactory that = (BytesMarshallableMarshallerWithCustomFactory)((Object)obj);
            return that.marshaledClass() == this.marshaledClass() && that.factory.equals(this.factory);
        }

        public int hashCode() {
            return Objects.hash(this.marshaledClass(), this.factory);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "{marshaledClass=" + this.marshaledClass() + ",factory=" + this.factory + "}";
        }
    }

    private static class SerializableMarshaller
    implements BytesMarshaller {
        private static final long serialVersionUID = 0L;
        private final ObjectSerializer serializer;

        private SerializableMarshaller(ObjectSerializer serializer) {
            this.serializer = serializer;
        }

        public void write(Bytes bytes, Object obj) {
            try {
                this.serializer.writeSerializable(bytes, obj, null);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Nullable
        public Object read(Bytes bytes) {
            try {
                return this.serializer.readSerializable(bytes, null, null);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Nullable
        public Object read(Bytes bytes, @Nullable Object obj) {
            try {
                return this.serializer.readSerializable(bytes, null, obj);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static enum DoubleMarshaller implements BytesMarshaller<Double>
    {
        INSTANCE;


        public void write(Bytes bytes, Double v) {
            bytes.writeDouble(v.doubleValue());
        }

        @Nullable
        public Double read(Bytes bytes) {
            return bytes.readDouble();
        }

        @Nullable
        public Double read(Bytes bytes, @Nullable Double v) {
            return bytes.readDouble();
        }
    }

    private static enum IntegerMarshaller implements BytesMarshaller<Integer>
    {
        INSTANCE;


        public void write(Bytes bytes, Integer v) {
            bytes.writeInt(v.intValue());
        }

        @Nullable
        public Integer read(Bytes bytes) {
            return bytes.readInt();
        }

        @Nullable
        public Integer read(Bytes bytes, @Nullable Integer v) {
            return bytes.readInt();
        }
    }

    private static enum CopyingInterop {
        FROM_MARSHALLER,
        FROM_WRITER;

    }

    static enum Role {
        KEY,
        VALUE;

    }
}

