/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.channels.FileChannel;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.IntIntMultiMap;
import net.openhft.chronicle.map.MapErrorListener;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapEventListeners;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.SharedSegment;
import net.openhft.chronicle.map.VanillaIntIntMultiMap;
import net.openhft.chronicle.map.VanillaShortShortMultiMap;
import net.openhft.chronicle.map.serialization.BytesReader;
import net.openhft.chronicle.map.serialization.Hasher;
import net.openhft.chronicle.map.serialization.MetaBytesInterop;
import net.openhft.chronicle.map.serialization.MetaBytesWriter;
import net.openhft.chronicle.map.serialization.MetaProvider;
import net.openhft.chronicle.map.serialization.SizeMarshaller;
import net.openhft.chronicle.map.threadlocal.Provider;
import net.openhft.chronicle.map.threadlocal.ThreadLocalCopies;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.MappedStore;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.Byteable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VanillaChronicleMap<K, KI, MKI extends MetaBytesInterop<K, KI>, V, VW, MVW extends MetaBytesWriter<V, VW>>
extends AbstractMap<K, V>
implements ChronicleMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VanillaChronicleMap.class);
    static final int MAX_ENTRY_OVERSIZE_FACTOR = 64;
    private static final int SEGMENT_HEADER = 64;
    final Class<K> kClass;
    final SizeMarshaller keySizeMarshaller;
    final BytesReader<K> originalKeyReader;
    transient Provider<BytesReader<K>> keyReaderProvider;
    final KI originalKeyInterop;
    transient Provider<KI> keyInteropProvider;
    final MKI originalMetaKeyInterop;
    final MetaProvider<K, KI, MKI> metaKeyInteropProvider;
    final Class<V> vClass;
    final SizeMarshaller valueSizeMarshaller;
    final BytesReader<V> originalValueReader;
    transient Provider<BytesReader<V>> valueReaderProvider;
    final VW originalValueWriter;
    transient Provider<VW> valueWriterProvider;
    final MVW originalMetaValueWriter;
    final MetaProvider<V, VW, MVW> metaValueWriterProvider;
    final ObjectFactory<V> valueFactory;
    final DefaultValueProvider<K, V> defaultValueProvider;
    final int metaDataBytes;
    final int entrySize;
    final Alignment alignment;
    final int actualSegments;
    final int entriesPerSegment;
    final MapEventListener<K, V, ChronicleMap<K, V>> eventListener;
    final boolean putReturnsNull;
    final boolean removeReturnsNull;
    private final ObjectSerializer objectSerializer;
    private final long lockTimeOutNS;
    private final MapErrorListener errorListener;
    transient Segment[] segments;
    transient BytesStore ms;
    transient long headerSize;
    transient Set<Map.Entry<K, V>> entrySet;
    private int bits;
    private int mask;

    public VanillaChronicleMap(ChronicleMapBuilder<K, V> builder) throws IOException {
        SerializationBuilder keyBuilder = builder.keyBuilder;
        this.kClass = keyBuilder.eClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.originalKeyReader = keyBuilder.reader();
        this.originalKeyInterop = keyBuilder.interop();
        this.originalMetaKeyInterop = keyBuilder.metaInterop();
        this.metaKeyInteropProvider = keyBuilder.metaInteropProvider();
        SerializationBuilder valueBuilder = builder.valueBuilder;
        this.vClass = valueBuilder.eClass;
        this.valueSizeMarshaller = valueBuilder.sizeMarshaller();
        this.originalValueReader = valueBuilder.reader();
        this.originalValueWriter = valueBuilder.interop();
        this.originalMetaValueWriter = valueBuilder.metaInterop();
        this.metaValueWriterProvider = valueBuilder.metaInteropProvider();
        this.valueFactory = valueBuilder.factory();
        this.defaultValueProvider = builder.defaultValueProvider();
        this.lockTimeOutNS = builder.lockTimeOut(TimeUnit.NANOSECONDS);
        this.entrySize = builder.alignedEntrySize();
        this.alignment = builder.entryAndValueAlignment();
        this.errorListener = builder.errorListener();
        this.putReturnsNull = builder.putReturnsNull();
        this.removeReturnsNull = builder.removeReturnsNull();
        this.objectSerializer = builder.objectSerializer();
        this.actualSegments = builder.actualSegments();
        this.entriesPerSegment = builder.actualEntriesPerSegment();
        this.metaDataBytes = builder.metaDataBytes();
        this.eventListener = builder.eventListener();
        this.mask = this.useSmallMultiMaps() ? 65535 : -1;
        this.bits = Maths.intLog2((long)this.actualSegments);
        this.initTransients();
    }

    int segmentHash(long hash) {
        return (int)(hash >>> this.bits) & this.mask;
    }

    int getSegment(long hash) {
        return (int)(hash & (long)(this.actualSegments - 1));
    }

    static long align64(long l) {
        return l + 63L & 0xFFFFFFFFFFFFFFC0L;
    }

    void initTransients() {
        ConstantValueProvider constantValueProvider;
        this.keyReaderProvider = Provider.of(this.originalKeyReader.getClass());
        this.keyInteropProvider = Provider.of(this.originalKeyInterop.getClass());
        this.valueReaderProvider = Provider.of(this.originalValueReader.getClass());
        this.valueWriterProvider = Provider.of(this.originalValueWriter.getClass());
        if (this.defaultValueProvider instanceof ConstantValueProvider && (constantValueProvider = (ConstantValueProvider)this.defaultValueProvider).wasDeserialized()) {
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader<V> valueReader = this.valueReaderProvider.get(copies, this.originalValueReader);
            constantValueProvider.initTransients(valueReader);
        }
        Segment[] ss = (Segment[])Array.newInstance(this.segmentType(), this.actualSegments);
        this.segments = ss;
    }

    Class segmentType() {
        return Segment.class;
    }

    long createMappedStoreAndSegments(BytesStore bytesStore) throws IOException {
        this.ms = bytesStore;
        this.onHeaderCreated();
        long offset = this.getHeaderSize();
        long segmentSize = this.segmentSize();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment((NativeBytes)this.ms.bytes(offset, segmentSize), i);
            offset += segmentSize;
        }
        return offset;
    }

    long createMappedStoreAndSegments(File file) throws IOException {
        return this.createMappedStoreAndSegments((BytesStore)new MappedStore(file, FileChannel.MapMode.READ_WRITE, this.sizeInBytes(), this.objectSerializer));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    void onHeaderCreated() {
    }

    long getHeaderSize() {
        return this.headerSize;
    }

    Segment createSegment(NativeBytes bytes, int index) {
        return new Segment(bytes, index);
    }

    @Override
    public File file() {
        return this.ms.file();
    }

    long sizeInBytes() {
        return this.getHeaderSize() + (long)this.segments.length * this.segmentSize();
    }

    long sizeOfMultiMap() {
        return this.useSmallMultiMaps() ? VanillaShortShortMultiMap.sizeInBytes(this.entriesPerSegment) : VanillaIntIntMultiMap.sizeInBytes(this.entriesPerSegment);
    }

    long sizeOfMultiMapBitSet() {
        return this.useSmallMultiMaps() ? VanillaShortShortMultiMap.sizeOfBitSetInBytes(this.entriesPerSegment) : VanillaIntIntMultiMap.sizeOfBitSetInBytes(this.entriesPerSegment);
    }

    boolean useSmallMultiMaps() {
        return this.entriesPerSegment <= 65536;
    }

    long sizeOfBitSets() {
        return VanillaChronicleMap.align64(this.entriesPerSegment / 8);
    }

    int numberOfBitSets() {
        return 1;
    }

    long segmentSize() {
        long ss = 64L + VanillaChronicleMap.align64(this.sizeOfMultiMap() + this.sizeOfMultiMapBitSet()) * (long)this.multiMapsPerSegment() + (long)this.numberOfBitSets() * this.sizeOfBitSets() + this.sizeOfEntriesInSegment();
        if ((ss & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        if ((ss & 0xFFDL) < 64L) {
            ss = (ss & 0xFFFFFFFFFFFFFFC0L) + 64L;
        }
        return ss;
    }

    int multiMapsPerSegment() {
        return 1;
    }

    private long sizeOfEntriesInSegment() {
        return VanillaChronicleMap.align64((long)this.entriesPerSegment * (long)this.entrySize);
    }

    @Override
    public void close() {
        if (this.ms == null) {
            return;
        }
        this.ms.free();
        this.segments = null;
        this.ms = null;
    }

    MapEventListener<K, V, ChronicleMap<K, V>> eventListener() {
        return this.eventListener;
    }

    void checkKey(Object key) {
        if (!this.kClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.kClass.getName() + " but was a " + key.getClass());
        }
    }

    void checkValue(Object value) {
        if (!this.vClass.isInstance(value)) {
            throw new ClassCastException("Value must be a " + this.vClass.getName() + " but was a " + value.getClass());
        }
    }

    @Override
    public V put(K key, V value) {
        return this.put0(key, value, true);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put0(key, value, false);
    }

    private V put0(K key, V value, boolean replaceIfPresent) {
        this.checkKey(key);
        this.checkValue(value);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        KI keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].put(copies, metaKeyInterop, keyInterop, key, value, segmentHash, replaceIfPresent);
    }

    @Override
    public V get(Object key) {
        return this.lookupUsing(key, null, false);
    }

    @Override
    public V getUsing(K key, V value) {
        return this.lookupUsing(key, value, false);
    }

    @Override
    public V acquireUsing(K key, V value) {
        return this.lookupUsing(key, value, true);
    }

    V lookupUsing(K key, V value, boolean create) {
        this.checkKey(key);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        KI keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].acquire(copies, metaKeyInterop, keyInterop, key, value, segmentHash, create);
    }

    @Override
    public boolean containsKey(Object k) {
        this.checkKey(k);
        Object key = k;
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        KI keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].containsKey(keyInterop, metaKeyInterop, key, segmentHash);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public V remove(Object key) {
        return this.removeIfValueIs(key, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        return this.removeIfValueIs(key, value) != null;
    }

    V removeIfValueIs(Object k, V expectedValue) {
        this.checkKey(k);
        Object key = k;
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        KI keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].remove(copies, metaKeyInterop, keyInterop, key, expectedValue, segmentHash);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkValue(oldValue);
        return oldValue.equals(this.replaceIfValueIs(key, oldValue, newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.replaceIfValueIs(key, null, value);
    }

    @Override
    public long longSize() {
        long result = 0L;
        for (Segment segment : this.segments) {
            result += (long)segment.getSize();
        }
        return result;
    }

    @Override
    public int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    V replaceIfValueIs(@net.openhft.lang.model.constraints.NotNull K key, V existingValue, V newValue) {
        this.checkKey(key);
        this.checkValue(newValue);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        KI keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].replace(copies, metaKeyInterop, keyInterop, key, existingValue, newValue, segmentHash);
    }

    void checkConsistency() {
        for (Segment segment : this.segments) {
            segment.checkConsistency();
        }
    }

    long readValueSize(Bytes entry) {
        long valueSize = this.valueSizeMarshaller.readSize(entry);
        this.alignment.alignPositionAddr(entry);
        return valueSize;
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = 0L;

        WriteThroughEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            VanillaChronicleMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object v = VanillaChronicleMap.this.get(e.getKey());
                return v != null && v.equals(e.getValue());
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object key = e.getKey();
                Object value = e.getValue();
                return VanillaChronicleMap.this.remove(key, value);
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public int size() {
            return VanillaChronicleMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return VanillaChronicleMap.this.isEmpty();
        }

        @Override
        public void clear() {
            VanillaChronicleMap.this.clear();
        }
    }

    class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        Map.Entry<K, V> returnedEntry;
        private int returnedSeg = -1;
        private long returnedPos = -1L;
        private int nextSeg;
        private long nextPos;

        public EntryIterator() {
            this.nextSeg = VanillaChronicleMap.this.segments.length - 1;
            this.nextPos = -1L;
            this.advance(this.nextSeg, -1L);
        }

        private boolean advance(int segIndex, long pos) {
            while (segIndex >= 0) {
                pos = VanillaChronicleMap.this.segments[segIndex].getHashLookup().getPositions().nextSetBit(pos + 1L);
                if (pos >= 0L) {
                    this.nextSeg = segIndex;
                    this.nextPos = pos;
                    return true;
                }
                --segIndex;
                pos = -1L;
            }
            this.nextSeg = -1;
            this.nextPos = -1L;
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.nextSeg >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            while (true) {
                int segIndex = this.nextSeg;
                long pos = this.nextPos;
                if (segIndex < 0) {
                    throw new NoSuchElementException();
                }
                Segment segment = VanillaChronicleMap.this.segments[segIndex];
                try {
                    segment.lock();
                    if (segment.getHashLookup().getPositions().isClear(pos)) {
                        this.advance(segIndex, pos);
                        continue;
                    }
                    this.returnedSeg = segIndex;
                    this.returnedPos = pos;
                    this.advance(this.returnedSeg, this.returnedPos);
                    this.returnedEntry = segment.getEntry(pos);
                    Map.Entry entry = this.returnedEntry;
                    return entry;
                }
                finally {
                    segment.unlock();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int segIndex = this.returnedSeg;
            if (segIndex < 0) {
                throw new IllegalStateException();
            }
            Segment segment = VanillaChronicleMap.this.segments[segIndex];
            int pos = (int)this.returnedPos;
            try {
                segment.lock();
                if (segment.getHashLookup().getPositions().isClear((long)pos)) {
                    VanillaChronicleMap.this.remove(this.returnedEntry.getKey());
                } else {
                    this.removePresent(segment, pos);
                }
                this.returnedSeg = -1;
                this.returnedEntry = null;
            }
            finally {
                segment.unlock();
            }
        }

        void removePresent(Segment segment, int pos) {
            long offset = segment.offsetFromPos(pos);
            MultiStoreBytes entry = segment.entry(offset);
            long limit = entry.limit();
            long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
            long position = entry.position();
            int segmentHash = VanillaChronicleMap.this.segmentHash(Hasher.hash((Bytes)entry, position, position + keySize));
            entry.skip(keySize);
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            segment.getHashLookup().remove(segmentHash, pos);
            segment.decrementSize();
            segment.free(pos, segment.inBlocks(entryEndAddr - segment.entryStartAddr(offset)));
            segment.notifyRemoved(offset, this.returnedEntry.getKey(), this.returnedEntry.getValue(), pos);
        }
    }

    class Segment
    implements SharedSegment {
        static final int LOCK_OFFSET = 0;
        static final int SIZE_OFFSET = 8;
        static final int PAD1_OFFSET = 12;
        static final int REPLICA_OFFSET = 16;
        final NativeBytes bytes;
        final MultiStoreBytes tmpBytes = new MultiStoreBytes();
        final long entriesOffset;
        private final int index;
        private final SingleThreadedDirectBitSet freeList;
        private IntIntMultiMap hashLookup;
        private int nextPosToSearchFrom = 0;

        Segment(NativeBytes bytes, int index) {
            this.bytes = bytes;
            this.index = index;
            long start = bytes.startAddr() + 64L;
            this.createHashLookups(start);
            NativeBytes bsBytes = new NativeBytes(this.tmpBytes.objectSerializer(), start += VanillaChronicleMap.align64(VanillaChronicleMap.this.sizeOfMultiMap() + VanillaChronicleMap.this.sizeOfMultiMapBitSet()) * (long)VanillaChronicleMap.this.multiMapsPerSegment(), start + VanillaChronicleMap.this.sizeOfBitSets(), null);
            this.freeList = new SingleThreadedDirectBitSet((Bytes)bsBytes);
            this.entriesOffset = (start += (long)VanillaChronicleMap.this.numberOfBitSets() * VanillaChronicleMap.this.sizeOfBitSets()) - bytes.startAddr();
            assert (bytes.capacity() >= this.entriesOffset + (long)(VanillaChronicleMap.this.entriesPerSegment * VanillaChronicleMap.this.entrySize));
        }

        void createHashLookups(long start) {
            this.hashLookup = this.createMultiMap(start);
        }

        public IntIntMultiMap getHashLookup() {
            return this.hashLookup;
        }

        IntIntMultiMap createMultiMap(long start) {
            NativeBytes multiMapBytes = new NativeBytes((BytesMarshallerFactory)new VanillaBytesMarshallerFactory(), start, start += VanillaChronicleMap.this.sizeOfMultiMap(), null);
            NativeBytes sizeOfMultiMapBitSetBytes = new NativeBytes((BytesMarshallerFactory)new VanillaBytesMarshallerFactory(), start, start + VanillaChronicleMap.this.sizeOfMultiMapBitSet(), null);
            multiMapBytes.load();
            return VanillaChronicleMap.this.useSmallMultiMaps() ? new VanillaShortShortMultiMap((Bytes)multiMapBytes, (Bytes)sizeOfMultiMapBitSetBytes) : new VanillaIntIntMultiMap((Bytes)multiMapBytes, (Bytes)sizeOfMultiMapBitSetBytes);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        void incrementSize() {
            this.bytes.addInt(8L, 1);
        }

        void resetSize() {
            this.bytes.writeInt(8L, 0);
        }

        void decrementSize() {
            this.bytes.addInt(8L, -1);
        }

        int getSize() {
            return Math.max(0, this.bytes.readVolatileInt(8L));
        }

        @Override
        public void lock() throws IllegalStateException {
            boolean success;
            while (!(success = this.bytes.tryLockNanosLong(0L, VanillaChronicleMap.this.lockTimeOutNS))) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IllegalStateException(new InterruptedException("Unable to obtain lock, interrupted"));
                }
                VanillaChronicleMap.this.errorListener.onLockTimeout(this.bytes.threadIdForLockLong(0L));
                this.bytes.resetLockLong(0L);
            }
            return;
        }

        @Override
        public void unlock() {
            try {
                this.bytes.unlockLong(0L);
            }
            catch (IllegalMonitorStateException e) {
                VanillaChronicleMap.this.errorListener.errorOnUnlock(e);
            }
        }

        @Override
        public long offsetFromPos(long pos) {
            return this.entriesOffset + pos * (long)VanillaChronicleMap.this.entrySize;
        }

        long posFromOffset(long offset) {
            return (offset - this.entriesOffset) / (long)VanillaChronicleMap.this.entrySize;
        }

        public MultiStoreBytes entry(long offset) {
            return this.reuse(this.tmpBytes, offset);
        }

        private MultiStoreBytes reuse(MultiStoreBytes entry, long offset) {
            entry.storePositionAndSize((BytesStore)this.bytes, offset += (long)VanillaChronicleMap.this.metaDataBytes, this.bytes.limit() - offset);
            return entry;
        }

        long entryStartAddr(long offset) {
            return this.bytes.startAddr() + offset;
        }

        private long entrySize(long keySize, long valueSize) {
            return VanillaChronicleMap.this.alignment.alignAddr((long)(VanillaChronicleMap.this.metaDataBytes + VanillaChronicleMap.this.keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)VanillaChronicleMap.this.valueSizeMarshaller.sizeEncodingSize(valueSize)) + valueSize;
        }

        int inBlocks(long sizeInBytes) {
            if (sizeInBytes <= (long)VanillaChronicleMap.this.entrySize) {
                return 1;
            }
            if (--sizeInBytes <= Integer.MAX_VALUE) {
                return (int)sizeInBytes / VanillaChronicleMap.this.entrySize + 1;
            }
            return (int)(sizeInBytes / (long)VanillaChronicleMap.this.entrySize) + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V acquire(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V usingValue, int hash2, boolean create) {
            this.lock();
            try {
                long keySize = metaKeyInterop.size(keyInterop, key);
                MultiStoreBytes entry = this.tmpBytes;
                long offset = this.searchKey(keyInterop, metaKeyInterop, key, keySize, hash2, entry, this.hashLookup);
                if (offset >= 0L) {
                    Object v = this.onKeyPresentOnAcquire(copies, key, usingValue, offset, (NativeBytes)entry);
                    return v;
                }
                boolean usingValuePassed = usingValue != null;
                if ((usingValue = this.tryObtainUsingValueOnAcquire(key, usingValue, create)) != null) {
                    offset = this.putEntry(copies, metaKeyInterop, keyInterop, key, keySize, usingValue, create);
                    this.incrementSize();
                    if (usingValuePassed || !create) {
                        this.notifyPut(offset, true, key, usingValue, this.posFromOffset(offset));
                    }
                    Object v = usingValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        long searchKey(KI keyInterop, MKI metaKeyInterop, K key, long keySize, int hash2, MultiStoreBytes entry, IntIntMultiMap hashLookup) {
            int pos;
            hashLookup.startSearch(hash2);
            while ((pos = hashLookup.nextPos()) >= 0) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                entry.skip(keySize);
                return offset;
            }
            return -1L;
        }

        V onKeyPresentOnAcquire(ThreadLocalCopies copies, K key, V usingValue, long offset, NativeBytes entry) {
            Object v = this.readValue(copies, entry, usingValue);
            this.notifyGet(offset, key, v);
            return v;
        }

        V tryObtainUsingValueOnAcquire(K key, V usingValue, boolean create) {
            if (create) {
                if (usingValue != null) {
                    return usingValue;
                }
                try {
                    usingValue = VanillaChronicleMap.this.valueFactory.create();
                    if (usingValue == null) {
                        throw new IllegalStateException("acquireUsing() method requiresvalueFactory.create() result to be non-null. By default it is so when value class isa Byteable/BytesMarshallable/Externalizable subclass.Note that acquireUsing() anyway makes very little sense when value class is not a Byteable subclass.");
                    }
                    return usingValue;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            if (usingValue instanceof Byteable) {
                ((Byteable)usingValue).bytes(null, 0L);
            }
            return VanillaChronicleMap.this.defaultValueProvider.get(key, usingValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V value, int hash2, boolean replaceIfPresent) {
            this.lock();
            try {
                int pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    if (replaceIfPresent) {
                        Object v = this.replaceValueOnPut(copies, key, value, (NativeBytes)entry, pos, offset, !VanillaChronicleMap.this.putReturnsNull, this.hashLookup);
                        return v;
                    }
                    Object v = VanillaChronicleMap.this.putReturnsNull ? null : (Object)this.readValue(copies, (NativeBytes)entry, null);
                    return v;
                }
                long offset = this.putEntry(copies, metaKeyInterop, keyInterop, key, keySize, value, false);
                this.incrementSize();
                this.notifyPut(offset, true, key, value, this.posFromOffset(offset));
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V replaceValueOnPut(ThreadLocalCopies copies, K key, V value, NativeBytes entry, int pos, long offset, boolean readPrevValue, IntIntMultiMap searchedHashLookup) {
            long valueSizePos = entry.position();
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            Object prevValue = null;
            if (readPrevValue) {
                prevValue = this.readValue(copies, entry, null, valueSize);
            }
            offset = this.putValue(pos, offset, entry, valueSizePos, entryEndAddr, copies, value, null, searchedHashLookup);
            this.notifyPut(offset, false, key, value, this.posFromOffset(offset));
            return prevValue;
        }

        private long putEntry(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, long keySize, V value, boolean usingValue) {
            long valueSize;
            boolean byteableValue = usingValue && value instanceof Byteable;
            MetaBytesWriter metaValueWriter = null;
            Object valueWriter = null;
            Byteable valueAsByteable = null;
            if (!byteableValue) {
                copies = VanillaChronicleMap.this.valueWriterProvider.getCopies(copies);
                valueWriter = VanillaChronicleMap.this.valueWriterProvider.get(copies, VanillaChronicleMap.this.originalValueWriter);
                copies = VanillaChronicleMap.this.metaValueWriterProvider.getCopies(copies);
                metaValueWriter = (MetaBytesWriter)VanillaChronicleMap.this.metaValueWriterProvider.get(copies, VanillaChronicleMap.this.originalMetaValueWriter, valueWriter, value);
                valueSize = metaValueWriter.size(valueWriter, value);
            } else {
                valueAsByteable = (Byteable)value;
                valueSize = valueAsByteable.maxSize();
            }
            long entrySize = this.entrySize(keySize, valueSize);
            int pos = this.alloc(this.inBlocks(entrySize));
            long offset = this.offsetFromPos(pos);
            this.clearMetaData(offset);
            MultiStoreBytes entry = this.entry(offset);
            VanillaChronicleMap.this.keySizeMarshaller.writeSize((Bytes)entry, keySize);
            metaKeyInterop.write(keyInterop, (Bytes)entry, key);
            this.writeValueOnPutEntry(valueSize, metaValueWriter, valueWriter, value, valueAsByteable, (NativeBytes)entry);
            this.hashLookup.putAfterFailedSearch(pos);
            return offset;
        }

        void writeValueOnPutEntry(long valueSize, MetaBytesWriter<V, VW> metaValueWriter, VW valueWriter, V value, Byteable valueAsByteable, NativeBytes entry) {
            VanillaChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, valueSize);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            if (metaValueWriter != null) {
                metaValueWriter.write(valueWriter, (Bytes)entry, value);
            } else {
                assert (valueAsByteable != null);
                long valueOffset = entry.positionAddr() - this.bytes.address();
                this.bytes.zeroOut(valueOffset, valueOffset + valueSize);
                valueAsByteable.bytes((Bytes)this.bytes, valueOffset);
            }
        }

        void clearMetaData(long offset) {
            if (VanillaChronicleMap.this.metaDataBytes > 0) {
                this.bytes.zeroOut(offset, offset + (long)VanillaChronicleMap.this.metaDataBytes);
            }
        }

        int alloc(int blocks) {
            int ret = (int)this.freeList.setNextNContinuousClearBits((long)this.nextPosToSearchFrom, blocks);
            if ((long)ret == -1L && (long)(ret = (int)this.freeList.setNextNContinuousClearBits(0L, blocks)) == -1L) {
                if (blocks == 1) {
                    throw new IllegalArgumentException("Segment is full, no free entries found");
                }
                throw new IllegalArgumentException("Segment is full or has no ranges of " + blocks + " continuous free blocks");
            }
            if (blocks == 1 || this.freeList.isSet((long)this.nextPosToSearchFrom)) {
                this.nextPosToSearchFrom = ret + blocks;
            }
            return ret;
        }

        private boolean realloc(int fromPos, int oldBlocks, int newBlocks) {
            if (this.freeList.allClear((long)(fromPos + oldBlocks), (long)(fromPos + newBlocks))) {
                this.freeList.set((long)(fromPos + oldBlocks), (long)(fromPos + newBlocks));
                return true;
            }
            return false;
        }

        void free(int fromPos, int blocks) {
            this.freeList.clear((long)fromPos, (long)(fromPos + blocks));
            if (fromPos < this.nextPosToSearchFrom) {
                this.nextPosToSearchFrom = fromPos;
            }
        }

        V readValue(ThreadLocalCopies copies, NativeBytes entry, V value) {
            return this.readValue(copies, entry, value, VanillaChronicleMap.this.readValueSize((Bytes)entry));
        }

        V readValue(ThreadLocalCopies copies, NativeBytes entry, V value, long valueSize) {
            copies = VanillaChronicleMap.this.valueReaderProvider.getCopies(copies);
            BytesReader valueReader = VanillaChronicleMap.this.valueReaderProvider.get(copies, VanillaChronicleMap.this.originalValueReader);
            this.bytes.positionAddr(entry.positionAddr());
            return valueReader.read((Bytes)this.bytes, valueSize, value);
        }

        boolean keyEquals(KI keyInterop, MKI metaKeyInterop, K key, long keySize, Bytes entry) {
            return keySize == VanillaChronicleMap.this.keySizeMarshaller.readSize(entry) && metaKeyInterop.startsWith(keyInterop, entry, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V expectedValue, int hash2) {
            this.lock();
            try {
                int pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0) {
                    Object valueRemoved;
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
                    long entryEndAddr = entry.positionAddr() + valueSize;
                    Object v = valueRemoved = expectedValue != null || !VanillaChronicleMap.this.removeReturnsNull ? (Object)this.readValue(copies, (NativeBytes)entry, null, valueSize) : null;
                    if (expectedValue != null && !expectedValue.equals(valueRemoved)) {
                        Object v2 = null;
                        return v2;
                    }
                    this.hashLookup.removePrevPos();
                    this.decrementSize();
                    this.free(pos, this.inBlocks(entryEndAddr - this.entryStartAddr(offset)));
                    this.notifyRemoved(offset, key, valueRemoved, pos);
                    Object v3 = valueRemoved;
                    return v3;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsKey(KI keyInterop, MKI metaKeyInterop, K key, int hash2) {
            this.lock();
            try {
                int pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                IntIntMultiMap hashLookup = this.containsKeyHashLookup();
                hashLookup.startSearch(hash2);
                while ((pos = hashLookup.nextPos()) >= 0) {
                    MultiStoreBytes entry = this.entry(this.offsetFromPos(pos));
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        IntIntMultiMap containsKeyHashLookup() {
            return this.hashLookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V expectedValue, V newValue, int hash2) {
            this.lock();
            try {
                int pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    Object v = this.onKeyPresentOnReplace(copies, key, expectedValue, newValue, pos, offset, (NativeBytes)entry, this.hashLookup);
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V onKeyPresentOnReplace(ThreadLocalCopies copies, K key, V expectedValue, V newValue, int pos, long offset, NativeBytes entry, IntIntMultiMap searchedHashLookup) {
            long valueSizePos = entry.position();
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            Object valueRead = this.readValue(copies, entry, null, valueSize);
            if (valueRead == null) {
                return null;
            }
            if (expectedValue == null || expectedValue.equals(valueRead)) {
                offset = this.putValue(pos, offset, entry, valueSizePos, entryEndAddr, copies, newValue, null, searchedHashLookup);
                this.notifyPut(offset, false, key, newValue, this.posFromOffset(offset));
                return valueRead;
            }
            return null;
        }

        void notifyPut(long offset, boolean added, K key, V value, long pos) {
            if (VanillaChronicleMap.this.eventListener() != MapEventListeners.NOP) {
                this.tmpBytes.storePositionAndSize((BytesStore)this.bytes, offset, (long)VanillaChronicleMap.this.entrySize);
                VanillaChronicleMap.this.eventListener().onPut(VanillaChronicleMap.this, (Bytes)this.tmpBytes, VanillaChronicleMap.this.metaDataBytes, added, key, value, pos, this);
            }
        }

        void notifyGet(long offset, K key, V value) {
            if (VanillaChronicleMap.this.eventListener() != MapEventListeners.NOP) {
                this.tmpBytes.storePositionAndSize((BytesStore)this.bytes, offset, (long)VanillaChronicleMap.this.entrySize);
                VanillaChronicleMap.this.eventListener().onGetFound(VanillaChronicleMap.this, (Bytes)this.tmpBytes, VanillaChronicleMap.this.metaDataBytes, key, value);
            }
        }

        void notifyRemoved(long offset, K key, V value, int pos) {
            if (VanillaChronicleMap.this.eventListener() != MapEventListeners.NOP) {
                this.tmpBytes.storePositionAndSize((BytesStore)this.bytes, offset, (long)VanillaChronicleMap.this.entrySize);
                VanillaChronicleMap.this.eventListener().onRemove(VanillaChronicleMap.this, (Bytes)this.tmpBytes, VanillaChronicleMap.this.metaDataBytes, key, value, pos, this);
            }
        }

        long putValue(int pos, long offset, NativeBytes entry, long valueSizePos, long entryEndAddr, ThreadLocalCopies copies, V value, Bytes valueBytes, IntIntMultiMap searchedHashLookup) {
            long newValueSize;
            long valueSizeAddr = entry.address() + valueSizePos;
            Object valueWriter = null;
            MetaBytesWriter metaValueWriter = null;
            if (valueBytes != null) {
                newValueSize = valueBytes.remaining();
            } else {
                copies = VanillaChronicleMap.this.valueWriterProvider.getCopies(copies);
                valueWriter = VanillaChronicleMap.this.valueWriterProvider.get(copies, VanillaChronicleMap.this.originalValueWriter);
                copies = VanillaChronicleMap.this.metaValueWriterProvider.getCopies(copies);
                metaValueWriter = (MetaBytesWriter)VanillaChronicleMap.this.metaValueWriterProvider.get(copies, VanillaChronicleMap.this.originalMetaValueWriter, valueWriter, value);
                newValueSize = metaValueWriter.size(valueWriter, value);
            }
            long newValueAddr = VanillaChronicleMap.this.alignment.alignAddr(valueSizeAddr + (long)VanillaChronicleMap.this.valueSizeMarshaller.sizeEncodingSize(newValueSize));
            long newEntryEndAddr = newValueAddr + newValueSize;
            if (newEntryEndAddr != entryEndAddr) {
                long entryStartAddr = this.entryStartAddr(offset);
                long oldEntrySize = entryEndAddr - entryStartAddr;
                int oldSizeInBlocks = this.inBlocks(oldEntrySize);
                int newSizeInBlocks = this.inBlocks(newEntryEndAddr - entryStartAddr);
                if (newSizeInBlocks > oldSizeInBlocks) {
                    if (newSizeInBlocks > 64) {
                        throw new IllegalArgumentException("Value too large: entry takes " + newSizeInBlocks + " blocks, " + 64 + " is maximum.");
                    }
                    if (!this.realloc(pos, oldSizeInBlocks, newSizeInBlocks)) {
                        this.free(pos, oldSizeInBlocks);
                        VanillaChronicleMap.this.eventListener().onRelocation(pos, this);
                        int prevPos = pos;
                        pos = this.alloc(newSizeInBlocks);
                        this.replacePosInHashLookupOnRelocation(searchedHashLookup, prevPos, pos);
                        offset = this.offsetFromPos(pos);
                        long newEntryStartAddr = this.entryStartAddr(offset);
                        NativeBytes.UNSAFE.copyMemory(entryStartAddr, newEntryStartAddr, valueSizeAddr - entryStartAddr);
                        entry = this.entry(offset);
                    }
                } else if (newSizeInBlocks < oldSizeInBlocks) {
                    this.freeList.clear((long)(pos + newSizeInBlocks), (long)(pos + oldSizeInBlocks));
                }
            }
            entry.position(valueSizePos);
            VanillaChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, newValueSize);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            if (valueBytes != null) {
                entry.write((RandomDataInput)valueBytes);
            } else {
                metaValueWriter.write(valueWriter, (Bytes)entry, value);
            }
            return offset;
        }

        void replacePosInHashLookupOnRelocation(IntIntMultiMap searchedHashLookup, int prevPos, int pos) {
            searchedHashLookup.replacePrevPos(pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            this.lock();
            try {
                this.hashLookup.clear();
                this.freeList.clear();
                this.resetSize();
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public Map.Entry<K, V> getEntry(long pos) {
            this.bytes.position(this.offsetFromPos(pos) + (long)VanillaChronicleMap.this.metaDataBytes);
            long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)this.bytes);
            ThreadLocalCopies copies = VanillaChronicleMap.this.keyReaderProvider.getCopies(null);
            Object key = VanillaChronicleMap.this.keyReaderProvider.get(copies, VanillaChronicleMap.this.originalKeyReader).read((Bytes)this.bytes, keySize);
            long valueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)this.bytes);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)this.bytes);
            copies = VanillaChronicleMap.this.valueReaderProvider.getCopies(copies);
            Object value = VanillaChronicleMap.this.valueReaderProvider.get(copies, VanillaChronicleMap.this.originalValueReader).read((Bytes)this.bytes, valueSize);
            return new WriteThroughEntry(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkConsistency() {
            this.lock();
            try {
                IntIntMultiMap hashLookup = this.checkConsistencyHashLookup();
                int pos = 0;
                while ((pos = (int)this.freeList.nextSetBit((long)pos)) >= 0) {
                    PosPresentOnce check = new PosPresentOnce(pos);
                    hashLookup.forEach(check);
                    if (check.count != 1) {
                        throw new AssertionError();
                    }
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
                    entry.skip(keySize);
                    this.afterKeyHookOnCheckConsistency((Bytes)entry);
                    long valueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
                    long sizeInBytes = this.entrySize(keySize, valueSize);
                    int entrySizeInBlocks = this.inBlocks(sizeInBytes);
                    if (!this.freeList.allSet((long)pos, (long)(pos + entrySizeInBlocks))) {
                        throw new AssertionError();
                    }
                    pos += entrySizeInBlocks;
                }
            }
            finally {
                this.unlock();
            }
        }

        void afterKeyHookOnCheckConsistency(Bytes entry) {
        }

        IntIntMultiMap checkConsistencyHashLookup() {
            return this.hashLookup;
        }

        private class PosPresentOnce
        implements IntIntMultiMap.EntryConsumer {
            int pos;
            int count = 0;

            PosPresentOnce(int pos) {
                this.pos = pos;
            }

            @Override
            public void accept(int hash, int pos) {
                if (this.pos == pos) {
                    ++this.count;
                }
            }
        }
    }
}

