/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.net.InetAddress;
import java.net.NetworkInterface;
import net.openhft.chronicle.map.ThrottlingConfig;
import net.openhft.chronicle.map.UdpReplicationConfig;

final class UdpReplicationConfigBean
extends UdpReplicationConfig {
    private final InetAddress address;
    private final int port;
    private final NetworkInterface networkInterface;
    private final ThrottlingConfig throttlingConfig;

    UdpReplicationConfigBean(InetAddress address, int port, NetworkInterface networkInterface, ThrottlingConfig throttlingConfig) {
        if (address == null) {
            throw new NullPointerException("Null address");
        }
        this.address = address;
        this.port = port;
        this.networkInterface = networkInterface;
        if (throttlingConfig == null) {
            throw new NullPointerException("Null throttlingConfig");
        }
        this.throttlingConfig = throttlingConfig;
    }

    @Override
    public InetAddress address() {
        return this.address;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public NetworkInterface networkInterface() {
        return this.networkInterface;
    }

    @Override
    public ThrottlingConfig throttlingConfig() {
        return this.throttlingConfig;
    }

    public String toString() {
        return "UdpReplicationConfig{address=" + this.address + ", port=" + this.port + ", networkInterface=" + this.networkInterface + ", throttlingConfig=" + this.throttlingConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UdpReplicationConfig) {
            UdpReplicationConfig that = (UdpReplicationConfig)o;
            return this.address.equals(that.address()) && this.port == that.port() && this.networkInterface.equals(that.networkInterface()) && this.throttlingConfig.equals(that.throttlingConfig());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.address.hashCode();
        h *= 1000003;
        h ^= this.port;
        h *= 1000003;
        h ^= this.networkInterface.hashCode();
        h *= 1000003;
        return h ^= this.throttlingConfig.hashCode();
    }
}

