/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collections;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.collections.Alignment;
import net.openhft.collections.SharedMapErrorListener;
import net.openhft.collections.SharedMapErrorListeners;
import net.openhft.collections.SharedMapEventListener;
import net.openhft.collections.SharedMapEventListeners;
import net.openhft.collections.TcpReplicator;
import net.openhft.collections.TcpReplicatorBuilder;
import net.openhft.collections.TimeProvider;
import net.openhft.collections.UdpReplicator;
import net.openhft.collections.UdpReplicatorBuilder;
import net.openhft.collections.VanillaSharedHashMap;
import net.openhft.collections.VanillaSharedReplicatedHashMap;
import net.openhft.lang.Maths;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedHashMapBuilder<K, V>
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger((String)SharedHashMapBuilder.class.getName());
    static final int HEADER_SIZE = 128;
    static final int SEGMENT_HEADER = 64;
    private static final byte[] MAGIC = "SharedHM".getBytes();
    public static final short UDP_REPLICATION_MODIFICATION_ITERATOR_ID = 128;
    public static final short JDBC_REPLICATION_MODIFICATION_ITERATOR_ID = 129;
    public static final short FILE_REPLICATION_MODIFICATION_ITERATOR_ID = 130;
    private int minSegments = -1;
    private int actualSegments = -1;
    private int actualEntriesPerSegment = -1;
    private int entrySize = 256;
    private Alignment alignment = Alignment.OF_4_BYTES;
    private long entries = 0x100000L;
    private int replicas = 0;
    boolean transactional = false;
    private long lockTimeOutMS = 20000L;
    private int metaDataBytes = 0;
    private SharedMapEventListener eventListener = SharedMapEventListeners.nop();
    private SharedMapErrorListener errorListener = SharedMapErrorListeners.logging();
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private boolean generatedKeyType = false;
    private boolean generatedValueType = false;
    private boolean largeSegments = false;
    private boolean canReplicate;
    byte identifier = (byte)-128;
    TcpReplicatorBuilder tcpReplicatorBuilder;
    private TimeProvider timeProvider = TimeProvider.SYSTEM;
    UdpReplicatorBuilder udpReplicatorBuilder;
    private BytesMarshallerFactory bytesMarshallerFactory;
    private ObjectSerializer objectSerializer;
    File file;
    Class kClass;
    Class vClass;

    public SharedHashMapBuilder() {
    }

    public SharedHashMapBuilder(Class<K> kClass, Class<V> vClass) {
        this.kClass = kClass;
        this.vClass = vClass;
    }

    public static <K, V> SharedHashMapBuilder<K, V> of(Class<K> kClass, Class<V> vClass) {
        return new SharedHashMapBuilder<K, V>(kClass, vClass);
    }

    public SharedHashMapBuilder<K, V> clone() {
        try {
            SharedHashMapBuilder result = (SharedHashMapBuilder)super.clone();
            if (this.tcpReplicatorBuilder() != null) {
                result.tcpReplicatorBuilder((TcpReplicatorBuilder)this.tcpReplicatorBuilder().clone());
            }
            if (this.udpReplicatorBuilder() != null) {
                result.udpReplicatorBuilder((UdpReplicatorBuilder)this.udpReplicatorBuilder().clone());
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SharedHashMapBuilder minSegments(int minSegments) {
        this.minSegments = minSegments;
        return this;
    }

    public int minSegments() {
        return this.minSegments < 1 ? this.tryMinSegments(4, 65536) : this.minSegments;
    }

    private int tryMinSegments(int min, int max) {
        for (int i = min; i < max; i <<= 1) {
            if (i * i * i < this.alignedEntrySize() * 2) continue;
            return i;
        }
        return max;
    }

    public SharedHashMapBuilder entrySize(int entrySize) {
        this.entrySize = entrySize;
        return this;
    }

    public int entrySize() {
        return this.entrySize;
    }

    int alignedEntrySize() {
        return this.entryAndValueAlignment().alignSize(this.entrySize());
    }

    public SharedHashMapBuilder<K, V> entryAndValueAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public Alignment entryAndValueAlignment() {
        return this.alignment;
    }

    public SharedHashMapBuilder<K, V> entries(long entries) {
        this.entries = entries;
        return this;
    }

    public long entries() {
        return this.entries;
    }

    public SharedHashMapBuilder<K, V> replicas(int replicas) {
        this.replicas = replicas;
        return this;
    }

    public int replicas() {
        return this.replicas;
    }

    public SharedHashMapBuilder<K, V> actualEntriesPerSegment(int actualEntriesPerSegment) {
        this.actualEntriesPerSegment = actualEntriesPerSegment;
        return this;
    }

    public int actualEntriesPerSegment() {
        if (this.actualEntriesPerSegment > 0) {
            return this.actualEntriesPerSegment;
        }
        int as = this.actualSegments();
        return (int)(Math.max(1L, this.entries * 2L / (long)as) + 63L) & 0xFFFFFFC0;
    }

    public SharedHashMapBuilder<K, V> actualSegments(int actualSegments) {
        this.actualSegments = actualSegments;
        return this;
    }

    public int actualSegments() {
        long segments;
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        if (!this.largeSegments && this.entries > (long)this.minSegments() << 15 && (segments = Maths.nextPower2((long)(this.entries >> 15), (long)128L)) < 0x100000L) {
            return (int)segments;
        }
        return (int)Maths.nextPower2((long)Math.max((this.entries >> 30) + 1L, (long)this.minSegments()), (long)1L);
    }

    public SharedHashMapBuilder<K, V> transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public boolean transactional() {
        return this.transactional;
    }

    public SharedHashMapBuilder kClass(Class kClass) {
        this.kClass = kClass;
        return this;
    }

    public SharedHashMapBuilder vClass(Class vClass) {
        this.vClass = vClass;
        return this;
    }

    public SharedHashMapBuilder<K, V> file(File file) {
        this.file = file;
        return this;
    }

    public File file() {
        return this.file;
    }

    public <K> Class<K> kClass() {
        return this.kClass;
    }

    public <V> Class<V> vClass() {
        return this.vClass;
    }

    public ChronicleMap<K, V> create() throws IOException {
        if (this.kClass == null) {
            throw new IllegalArgumentException("missing mandatory parameter kClass");
        }
        if (this.vClass == null) {
            throw new IllegalArgumentException("missing mandatory parameter vClass");
        }
        SharedHashMapBuilder<K, V> builder = this.toBuilder();
        if (!this.canReplicate()) {
            return new VanillaSharedHashMap(builder, this.file, this.kClass, this.vClass);
        }
        if (this.identifier <= 0) {
            throw new IllegalArgumentException("Identifier must be positive, " + this.identifier + " given");
        }
        VanillaSharedReplicatedHashMap result = new VanillaSharedReplicatedHashMap(builder, this.kClass, this.vClass);
        if (this.tcpReplicatorBuilder != null) {
            this.applyTcpReplication(result, this.tcpReplicatorBuilder);
        }
        if (this.udpReplicatorBuilder != null) {
            if (this.tcpReplicatorBuilder == null) {
                LOG.warn("MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should use the UdpReplicator if you have a large number of nodes, and you wish to receive the data before it becomes available on TCP/IP. Since data delivery is not guaranteed, it is recommended that you only use the UDP Replicator in conjunction with a TCP Replicator");
            }
            this.applyUdpReplication(result, this.udpReplicatorBuilder);
        }
        return result;
    }

    @Deprecated
    public <K, V> ChronicleMap<K, V> create(File file, Class<K> kClass, Class<V> vClass) throws IOException {
        return this.file(file).kClass(kClass).vClass(vClass).create();
    }

    SharedHashMapBuilder<K, V> toBuilder() throws IOException {
        Object builder = this.clone();
        if (this.file != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.file.exists() && this.file.length() > 0L) {
                    SharedHashMapBuilder.readFile(this.file, (SharedHashMapBuilder)builder);
                    break;
                }
                if (this.file.createNewFile() || this.file.length() == 0L) {
                    this.newFile(this.file);
                    break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            if (builder == null || !this.file.exists()) {
                throw new FileNotFoundException("Unable to create " + this.file);
            }
        }
        return builder;
    }

    static void readFile(File file, SharedHashMapBuilder builder) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder());
        FileInputStream fis = new FileInputStream(file);
        fis.getChannel().read(bb);
        fis.close();
        bb.flip();
        if (bb.remaining() < 22) {
            throw new IOException("File too small, corrupted? " + file);
        }
        byte[] bytes = new byte[8];
        bb.get(bytes);
        if (!Arrays.equals(bytes, MAGIC)) {
            throw new IOException("Unknown magic number, was " + new String(bytes, "ISO-8859-1"));
        }
        builder.actualSegments(bb.getInt());
        builder.actualEntriesPerSegment(bb.getInt());
        builder.entrySize(bb.getInt());
        builder.entryAndValueAlignment(Alignment.fromOrdinal((int)bb.get()));
        builder.replicas(bb.getInt());
        builder.transactional(bb.get() == 89);
        builder.metaDataBytes(bb.get() & 0xFF);
        if (builder.actualSegments() <= 0 || builder.actualEntriesPerSegment() <= 0 || builder.entrySize() <= 0) {
            throw new IOException("Corrupt header for " + file);
        }
    }

    void newFile(File file) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder());
        bb.put(MAGIC);
        bb.putInt(this.actualSegments());
        bb.putInt(this.actualEntriesPerSegment());
        bb.putInt(this.entrySize());
        bb.put((byte)this.entryAndValueAlignment().ordinal());
        bb.putInt(this.replicas());
        bb.put((byte)(this.transactional ? 89 : 78));
        bb.put((byte)this.metaDataBytes);
        bb.flip();
        FileOutputStream fos = new FileOutputStream(file);
        fos.getChannel().write(bb);
        fos.close();
    }

    public SharedHashMapBuilder lockTimeOutMS(long lockTimeOutMS) {
        this.lockTimeOutMS = lockTimeOutMS;
        return this;
    }

    public long lockTimeOutMS() {
        return this.lockTimeOutMS;
    }

    public SharedHashMapBuilder errorListener(SharedMapErrorListener errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    public SharedMapErrorListener errorListener() {
        return this.errorListener;
    }

    public SharedHashMapBuilder putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    public boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public SharedHashMapBuilder removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    public boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    public boolean generatedKeyType() {
        return this.generatedKeyType;
    }

    public SharedHashMapBuilder generatedKeyType(boolean generatedKeyType) {
        this.generatedKeyType = generatedKeyType;
        return this;
    }

    public boolean generatedValueType() {
        return this.generatedValueType;
    }

    public SharedHashMapBuilder generatedValueType(boolean generatedValueType) {
        this.generatedValueType = generatedValueType;
        return this;
    }

    public boolean largeSegments() {
        return this.entries > 0x800000000L || this.largeSegments;
    }

    public SharedHashMapBuilder largeSegments(boolean largeSegments) {
        this.largeSegments = largeSegments;
        return this;
    }

    public SharedHashMapBuilder metaDataBytes(int metaDataBytes) {
        if ((metaDataBytes & 0xFF) != metaDataBytes) {
            throw new IllegalArgumentException("MetaDataBytes must be [0..255] was " + metaDataBytes);
        }
        this.metaDataBytes = metaDataBytes;
        return this;
    }

    public int metaDataBytes() {
        return this.metaDataBytes;
    }

    public SharedHashMapBuilder eventListener(SharedMapEventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    public SharedMapEventListener eventListener() {
        return this.eventListener;
    }

    public String toString() {
        return "SharedHashMapBuilder{actualSegments=" + this.actualSegments() + ", minSegments=" + this.minSegments() + ", actualEntriesPerSegment=" + this.actualEntriesPerSegment() + ", entrySize=" + this.entrySize() + ", entryAndValueAlignment=" + this.entryAndValueAlignment() + ", entries=" + this.entries() + ", replicas=" + this.replicas() + ", transactional=" + this.transactional() + ", lockTimeOutMS=" + this.lockTimeOutMS() + ", metaDataBytes=" + this.metaDataBytes() + ", eventListener=" + this.eventListener() + ", errorListener=" + this.errorListener() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", generatedKeyType=" + this.generatedKeyType() + ", generatedValueType=" + this.generatedValueType() + ", largeSegments=" + this.largeSegments() + ", canReplicate=" + this.canReplicate() + ", identifier=" + this.identifierToString() + ", tcpReplicatorBuilder=" + this.tcpReplicatorBuilder() + ", udpReplicatorBuilder=" + this.udpReplicatorBuilder() + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerfactory=" + this.bytesMarshallerFactory() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedHashMapBuilder that = (SharedHashMapBuilder)o;
        if (this.actualEntriesPerSegment != that.actualEntriesPerSegment) {
            return false;
        }
        if (this.actualSegments != that.actualSegments) {
            return false;
        }
        if (this.canReplicate != that.canReplicate) {
            return false;
        }
        if (this.entries != that.entries) {
            return false;
        }
        if (this.entrySize != that.entrySize) {
            return false;
        }
        if (this.generatedKeyType != that.generatedKeyType) {
            return false;
        }
        if (this.generatedValueType != that.generatedValueType) {
            return false;
        }
        if (this.identifier != that.identifier) {
            return false;
        }
        if (this.largeSegments != that.largeSegments) {
            return false;
        }
        if (this.lockTimeOutMS != that.lockTimeOutMS) {
            return false;
        }
        if (this.metaDataBytes != that.metaDataBytes) {
            return false;
        }
        if (this.minSegments != that.minSegments) {
            return false;
        }
        if (this.putReturnsNull != that.putReturnsNull) {
            return false;
        }
        if (this.removeReturnsNull != that.removeReturnsNull) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (this.transactional != that.transactional) {
            return false;
        }
        if (this.alignment != that.alignment) {
            return false;
        }
        if (this.errorListener != null ? !this.errorListener.equals(that.errorListener) : that.errorListener != null) {
            return false;
        }
        if (this.eventListener != null ? !this.eventListener.equals(that.eventListener) : that.eventListener != null) {
            return false;
        }
        if (this.tcpReplicatorBuilder != null ? !this.tcpReplicatorBuilder.equals((Object)that.tcpReplicatorBuilder) : that.tcpReplicatorBuilder != null) {
            return false;
        }
        if (this.timeProvider != null ? !this.timeProvider.equals(that.timeProvider) : that.timeProvider != null) {
            return false;
        }
        return !(this.udpReplicatorBuilder != null ? !this.udpReplicatorBuilder.equals(that.udpReplicatorBuilder) : that.udpReplicatorBuilder != null);
    }

    public int hashCode() {
        int result = this.minSegments;
        result = 31 * result + this.actualSegments;
        result = 31 * result + this.actualEntriesPerSegment;
        result = 31 * result + this.entrySize;
        result = 31 * result + (this.alignment != null ? this.alignment.hashCode() : 0);
        result = 31 * result + (int)(this.entries ^ this.entries >>> 32);
        result = 31 * result + this.replicas;
        result = 31 * result + (this.transactional ? 1 : 0);
        result = 31 * result + (int)(this.lockTimeOutMS ^ this.lockTimeOutMS >>> 32);
        result = 31 * result + this.metaDataBytes;
        result = 31 * result + (this.eventListener != null ? this.eventListener.hashCode() : 0);
        result = 31 * result + (this.errorListener != null ? this.errorListener.hashCode() : 0);
        result = 31 * result + (this.putReturnsNull ? 1 : 0);
        result = 31 * result + (this.removeReturnsNull ? 1 : 0);
        result = 31 * result + (this.generatedKeyType ? 1 : 0);
        result = 31 * result + (this.generatedValueType ? 1 : 0);
        result = 31 * result + (this.largeSegments ? 1 : 0);
        result = 31 * result + (this.canReplicate ? 1 : 0);
        result = 31 * result + this.identifier;
        result = 31 * result + (this.tcpReplicatorBuilder != null ? this.tcpReplicatorBuilder.hashCode() : 0);
        result = 31 * result + (this.timeProvider != null ? this.timeProvider.hashCode() : 0);
        result = 31 * result + (this.udpReplicatorBuilder != null ? this.udpReplicatorBuilder.hashCode() : 0);
        return result;
    }

    public boolean canReplicate() {
        return this.canReplicate || this.tcpReplicatorBuilder != null || this.udpReplicatorBuilder != null;
    }

    public SharedHashMapBuilder canReplicate(boolean canReplicate) {
        this.canReplicate = canReplicate;
        return this;
    }

    <K, V> void applyUdpReplication(VanillaSharedReplicatedHashMap<K, V> result, UdpReplicatorBuilder udpReplicatorBuilder) throws IOException {
        InetAddress address = udpReplicatorBuilder.address();
        if (address == null) {
            throw new IllegalArgumentException("address can not be null");
        }
        if (address.isMulticastAddress() && udpReplicatorBuilder.networkInterface() == null) {
            throw new IllegalArgumentException("MISSING: NetworkInterface, When using a multicast addresses, please provided a networkInterface");
        }
        UdpReplicator udpReplicator = new UdpReplicator(result, (UdpReplicatorBuilder)udpReplicatorBuilder.clone(), this.entrySize(), result.identifier(), 128);
        result.addCloseable((Closeable)udpReplicator);
    }

    <K, V> void applyTcpReplication(@NotNull VanillaSharedReplicatedHashMap<K, V> result, @NotNull TcpReplicatorBuilder tcpReplicatorBuilder) throws IOException {
        result.addCloseable((Closeable)new TcpReplicator(result, result, tcpReplicatorBuilder, this.entrySize()));
    }

    public SharedHashMapBuilder timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    public TimeProvider timeProvider() {
        return this.timeProvider;
    }

    public byte identifier() {
        if (this.identifier == -128) {
            throw new IllegalStateException("identifier is not set.");
        }
        return this.identifier;
    }

    private String identifierToString() {
        return this.identifier == -128 ? "identifier is not set" : this.identifier + "";
    }

    public SharedHashMapBuilder identifier(byte identifier) {
        this.identifier = identifier;
        return this;
    }

    public SharedHashMapBuilder tcpReplicatorBuilder(TcpReplicatorBuilder tcpReplicatorBuilder) {
        this.tcpReplicatorBuilder = tcpReplicatorBuilder;
        return this;
    }

    public TcpReplicatorBuilder tcpReplicatorBuilder() {
        return this.tcpReplicatorBuilder;
    }

    public UdpReplicatorBuilder udpReplicatorBuilder() {
        return this.udpReplicatorBuilder;
    }

    public SharedHashMapBuilder udpReplicatorBuilder(UdpReplicatorBuilder udpReplicatorBuilder) {
        this.udpReplicatorBuilder = udpReplicatorBuilder;
        return this;
    }

    public BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory == null ? (this.bytesMarshallerFactory = new VanillaBytesMarshallerFactory()) : this.bytesMarshallerFactory;
    }

    public SharedHashMapBuilder bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        return this;
    }

    public ObjectSerializer objectSerializer() {
        return this.objectSerializer == null ? (this.objectSerializer = BytesMarshallableSerializer.create((BytesMarshallerFactory)this.bytesMarshallerFactory(), (ObjectSerializer)JDKObjectSerializer.INSTANCE)) : this.objectSerializer;
    }

    public SharedHashMapBuilder objectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
        return this;
    }
}

