/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireType;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class LogAppenderConfig {
    private static final String[] KEYS = new String[]{"blockSize", "bufferCapacity"};
    private int blockSize;
    private long bufferCapacity;

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public long getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void setBufferCapacity(long bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public String[] keys() {
        return KEYS;
    }

    public ChronicleQueue build(String path, String wireType) throws IOException {
        WireType wireTypeEnum = wireType != null ? WireType.valueOf((String)wireType.toUpperCase()) : WireType.BINARY_LIGHT;
        return ChronicleQueueBuilder.single((String)path).wireType(wireTypeEnum).blockSize(this.blockSize).bufferCapacity(this.bufferCapacity).build();
    }

    public void setProperties(@NotNull Properties properties, @Nullable String prefix) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (prefix != null && !prefix.isEmpty()) {
                if (!name.startsWith(prefix)) continue;
                this.setProperty(name.substring(prefix.length()), value);
                continue;
            }
            this.setProperty(name, value);
        }
    }

    public void setProperty(@NotNull String propName, @NotNull String propValue) {
        try {
            PropertyDescriptor property = new PropertyDescriptor(propName, this.getClass());
            Method method = property.getWriteMethod();
            Class<?> type = method.getParameterTypes()[0];
            if (type != null && propValue != null && !propValue.isEmpty()) {
                if (type == Integer.TYPE) {
                    method.invoke((Object)this, Integer.parseInt(propValue));
                } else if (type == Long.TYPE) {
                    method.invoke((Object)this, Long.parseLong(propValue));
                } else if (type == Boolean.TYPE) {
                    method.invoke((Object)this, Boolean.parseBoolean(propValue));
                } else if (type == String.class) {
                    method.invoke((Object)this, propValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

