/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import net.openhft.chronicle.Chronicle;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public abstract class ChronicleLogAppenderConfig {
    public abstract String[] keys();

    public abstract Chronicle build(String var1) throws IOException;

    public void setProperties(@NotNull Properties properties, @Nullable String prefix) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (prefix != null && !prefix.isEmpty()) {
                if (!name.startsWith(prefix)) continue;
                this.setProperty(name.substring(prefix.length()), value);
                continue;
            }
            this.setProperty(name, value);
        }
    }

    public void setProperty(@NotNull String propName, @NotNull String propValue) {
        try {
            PropertyDescriptor property = new PropertyDescriptor(propName, this.getClass());
            Method method = property.getWriteMethod();
            Class<?> type = method.getParameterTypes()[0];
            if (type != null && propValue != null && !propValue.isEmpty()) {
                if (type == Integer.TYPE) {
                    method.invoke((Object)this, Integer.parseInt(propValue));
                } else if (type == Long.TYPE) {
                    method.invoke((Object)this, Long.parseLong(propValue));
                } else if (type == Boolean.TYPE) {
                    method.invoke((Object)this, Boolean.parseBoolean(propValue));
                } else if (type == String.class) {
                    method.invoke((Object)this, propValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

