/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.io.IOException;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.VanillaChronicleConfig;
import net.openhft.chronicle.tools.ChronicleTools;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.RandomDataOutput;
import net.openhft.lang.model.constraints.NotNull;

public final class ChronicleLog {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String TMPDIR = System.getProperty("java.io.tmpdir");
    public static final String COMMA = ", ";
    public static final String STR_FALSE = "false";
    public static final String STR_TRUE = "true";
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd-HH:mm:ss.SSS";
    public static final byte VERSION = 1;
    private static final int CASE_DIFF = -32;

    public static boolean fastEqualsIgnoreCase(@NotNull String upperCase, @NotNull CharSequence other) {
        int l = upperCase.length();
        if (l != other.length()) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char oC;
            char uC = upperCase.charAt(i);
            if (uC == (oC = other.charAt(i)) || uC == oC + -32) continue;
            return false;
        }
        return true;
    }

    public static void warmup() {
        boolean vanillaDone = VanillaWarmup.DONE;
        boolean indexedDone = IndexedWarmup.DONE;
    }

    private ChronicleLog() {
    }

    private static class IndexedWarmup {
        public static final boolean DONE;
        private static final int WARMUP_ITER = 1000;

        private IndexedWarmup() {
        }

        static {
            ChronicleConfig cc = ChronicleConfig.SMALL.clone();
            cc.dataBlockSize(64);
            cc.indexBlockSize(64);
            String basePath = TMPDIR + "/indexed-warmup-" + Math.random();
            ChronicleTools.deleteOnExit((String)basePath);
            try {
                IndexedChronicle chronicle = new IndexedChronicle(basePath, cc);
                ExcerptAppender appender = chronicle.createAppender();
                ExcerptTailer tailer = chronicle.createTailer();
                for (int i = 0; i < 1000; ++i) {
                    appender.startExcerpt();
                    appender.writeInt(i);
                    appender.finish();
                    boolean b = tailer.nextIndex() || tailer.nextIndex();
                    tailer.readInt();
                    tailer.finish();
                }
                chronicle.close();
                System.gc();
                DONE = true;
            }
            catch (IOException e) {
                throw new AssertionError();
            }
        }
    }

    private static class VanillaWarmup {
        public static final boolean DONE;
        private static final int WARMUP_ITER = 1000;

        private VanillaWarmup() {
        }

        static {
            VanillaChronicleConfig cc = new VanillaChronicleConfig();
            cc.dataBlockSize(64);
            cc.indexBlockSize(64L);
            String basePath = TMPDIR + "/vanilla-warmup-" + Math.random();
            ChronicleTools.deleteDirOnExit((String)basePath);
            try {
                VanillaChronicle chronicle = new VanillaChronicle(basePath, cc);
                VanillaChronicle.VanillaAppender appender = chronicle.createAppender();
                ExcerptTailer tailer = chronicle.createTailer();
                for (int i = 0; i < 1000; ++i) {
                    appender.startExcerpt();
                    appender.writeInt(i);
                    appender.finish();
                    boolean b = tailer.nextIndex() || tailer.nextIndex();
                    tailer.readInt();
                    tailer.finish();
                }
                chronicle.close();
                chronicle.clear();
                System.gc();
                DONE = true;
            }
            catch (IOException e) {
                throw new AssertionError();
            }
        }
    }

    public static enum Type {
        UNKNOWN,
        SLF4J,
        LOGBACK,
        LOG4J_1,
        LOG4J_2;

        private static final Type[] VALUES;

        public void writeTo(RandomDataOutput out) {
            out.writeByte(this.ordinal());
        }

        public static Type read(RandomDataInput in) {
            return VALUES[in.readByte()];
        }

        static {
            VALUES = Type.values();
        }
    }
}

