/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.tools;

import java.util.HashSet;
import java.util.Set;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.logger.ChronicleLogEvent;
import net.openhft.chronicle.logger.ChronicleLogReader;
import net.openhft.chronicle.logger.tools.ChroniTool;

public final class ChroniGrep {
    public static void main(String[] args) {
        try {
            boolean indexed = false;
            boolean binary = true;
            Grep grep = new Grep();
            for (int i = 0; i < args.length - 1; ++i) {
                if ("-t".equals(args[i])) {
                    binary = false;
                    continue;
                }
                if ("-i".equals(args[i])) {
                    indexed = true;
                    continue;
                }
                if (i == args.length - 1) continue;
                grep.add(args[i]);
            }
            if (args.length >= 1 && !grep.isEmpty()) {
                ChroniTool.process((Chronicle)(indexed ? new IndexedChronicle(args[args.length - 1]) : new VanillaChronicle(args[args.length - 1])), (ChronicleLogReader)(binary ? new BinaryGrep(grep) : new TextGrep(grep)), false, false);
            } else {
                System.err.format("\nUsage: ChroniGrep [-t|-i] regexp1 ... regexpN path", new Object[0]);
                System.err.format("\n  -t = text chronicle, default binary", new Object[0]);
                System.err.format("\n  -i = IndexedCronicle, default VanillaChronicle", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private ChroniGrep() {
    }

    private static final class TextGrep
    extends ChroniTool.TextProcessor {
        private final Grep grep;

        public TextGrep(Grep grep) {
            this.grep = grep;
        }

        public void process(ChronicleLogEvent event) {
            String msg = ChroniTool.asString(event);
            if (this.grep.matches(msg)) {
                System.out.println(msg);
            }
        }
    }

    private static final class BinaryGrep
    extends ChroniTool.BinaryProcessor {
        private final Grep grep;

        public BinaryGrep(Grep grep) {
            this.grep = grep;
        }

        public void process(ChronicleLogEvent event) {
            String msg = ChroniTool.asString(event);
            if (this.grep.matches(msg)) {
                System.out.println(msg);
            }
        }
    }

    private static class Grep {
        private Set<String> regexps = new HashSet<String>();

        public void add(String regexp) {
            this.regexps.add(regexp);
        }

        public boolean isEmpty() {
            return this.regexps.isEmpty();
        }

        boolean matches(String message) {
            for (String regexp : this.regexps) {
                if (!message.matches(regexp)) continue;
                return true;
            }
            return false;
        }
    }
}

