/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogManager;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.slf4j.ChronicleLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class ChronicleLoggerFactory
implements ILoggerFactory {
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private ChronicleLogManager manager = ChronicleLogManager.getInstance();

    public Logger getLogger(String name) {
        try {
            return this.doGetLogger(name);
        }
        catch (Exception e) {
            System.err.println("Unable to initialize chronicle-logger-slf4j " + "(" + name + ")" + "\n  " + e.getMessage());
            return NOPLogger.NOP_LOGGER;
        }
    }

    public synchronized void warmup() {
    }

    public synchronized void shutdown() {
        this.manager.clear();
        this.loggers.clear();
    }

    public synchronized void reload() {
        this.shutdown();
        this.manager.reload();
    }

    private synchronized Logger doGetLogger(String name) throws IOException {
        Object logger = this.loggers.get(name);
        if (logger == null) {
            ChronicleLogWriter writer = this.manager.createWriter(name);
            if (this.manager.isSimple(name)) {
                logger = new ChronicleLogger.Text(writer, name, ChronicleLogLevel.WARN);
            } else if (this.manager.isBinary(name)) {
                logger = new ChronicleLogger.Binary(writer, name, this.manager.cfg().getLevel(name));
            } else if (this.manager.isText(name)) {
                logger = new ChronicleLogger.Text(writer, name, this.manager.cfg().getLevel(name));
            }
            if (logger != null) {
                this.loggers.put(name, (Logger)logger);
            } else {
                System.err.println("Unable to get a logger for " + "(" + name + ")");
            }
        }
        return logger;
    }
}

