/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j;

import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.slf4j.ChronicleLogAppender;
import org.slf4j.helpers.MarkerIgnoringBase;

public class ChronicleLogger
extends MarkerIgnoringBase {
    private final ChronicleLogAppender writer;
    private final ChronicleLogLevel level;

    public ChronicleLogger(ChronicleLogAppender writer, String name) {
        this(writer, name, ChronicleLogLevel.INFO);
    }

    public ChronicleLogger(ChronicleLogAppender writer, String name, ChronicleLogLevel level) {
        this.writer = writer;
        this.name = name;
        this.level = level;
    }

    public ChronicleLogLevel getLevel() {
        return this.level;
    }

    public ChronicleLogAppender getWriter() {
        return this.writer;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.TRACE);
    }

    public void trace(String s) {
        this.append(ChronicleLogLevel.TRACE, s, new Object[0]);
    }

    public void trace(String s, Object o) {
        this.append(ChronicleLogLevel.TRACE, s, o);
    }

    public void trace(String s, Object o1, Object o2) {
        this.append(ChronicleLogLevel.TRACE, s, o1, o2);
    }

    public void trace(String s, Object ... objects) {
        this.append(ChronicleLogLevel.TRACE, s, objects);
    }

    public void trace(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.TRACE, s, throwable);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.DEBUG);
    }

    public void debug(String s) {
        this.append(ChronicleLogLevel.DEBUG, s, new Object[0]);
    }

    public void debug(String s, Object o) {
        this.append(ChronicleLogLevel.DEBUG, s, o);
    }

    public void debug(String s, Object o1, Object o2) {
        this.append(ChronicleLogLevel.DEBUG, s, o1, o2);
    }

    public void debug(String s, Object ... objects) {
        this.append(ChronicleLogLevel.DEBUG, s, objects);
    }

    public void debug(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.DEBUG, s, throwable);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.INFO);
    }

    public void info(String s) {
        this.append(ChronicleLogLevel.INFO, s, new Object[0]);
    }

    public void info(String s, Object o) {
        this.append(ChronicleLogLevel.INFO, s, o);
    }

    public void info(String s, Object o1, Object o2) {
        this.append(ChronicleLogLevel.INFO, s, o1, o2);
    }

    public void info(String s, Object ... objects) {
        this.append(ChronicleLogLevel.INFO, s, objects);
    }

    public void info(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.INFO, s, throwable);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.WARN);
    }

    public void warn(String s) {
        this.append(ChronicleLogLevel.WARN, s, new Object[0]);
    }

    public void warn(String s, Object o) {
        this.append(ChronicleLogLevel.WARN, s, o);
    }

    public void warn(String s, Object o1, Object o2) {
        this.append(ChronicleLogLevel.WARN, s, o1, o2);
    }

    public void warn(String s, Object ... objects) {
        this.append(ChronicleLogLevel.WARN, s, objects);
    }

    public void warn(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.WARN, s, throwable);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.ERROR);
    }

    public void error(String s) {
        this.append(ChronicleLogLevel.ERROR, s, new Object[0]);
    }

    public void error(String s, Object o) {
        this.append(ChronicleLogLevel.ERROR, s, o);
    }

    public void error(String s, Object o1, Object o2) {
        this.append(ChronicleLogLevel.ERROR, s, o1, o2);
    }

    public void error(String s, Object ... objects) {
        this.append(ChronicleLogLevel.ERROR, s, objects);
    }

    public void error(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.ERROR, s, throwable);
    }

    private boolean isLevelEnabled(ChronicleLogLevel level) {
        return level.isHigherOrEqualTo(this.level);
    }

    private void append(ChronicleLogLevel level, String message, Object arg1) {
        if (level.isHigherOrEqualTo(this.level)) {
            this.writer.log(level, this.name, message, arg1);
        }
    }

    private void append(ChronicleLogLevel level, String message, Object arg1, Object arg2) {
        if (level.isHigherOrEqualTo(this.level)) {
            this.writer.log(level, this.name, message, arg1, arg2);
        }
    }

    private void append(ChronicleLogLevel level, String message, Object ... args) {
        if (level.isHigherOrEqualTo(this.level)) {
            this.writer.log(level, this.name, message, args);
        }
    }

    private void append(ChronicleLogLevel level, String message, Throwable throwable) {
        if (level.isHigherOrEqualTo(this.level)) {
            this.writer.log(level, this.name, message, throwable);
        }
    }
}

