/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j2;

import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import org.slf4j.helpers.MarkerIgnoringBase;

public final class ChronicleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    protected final ChronicleLogLevel level;
    private final ChronicleLogWriter writer;

    ChronicleLogger(ChronicleLogWriter writer, String name, ChronicleLogLevel level) {
        this.writer = writer;
        this.name = name;
        this.level = level;
    }

    ChronicleLogLevel getLevel() {
        return this.level;
    }

    ChronicleLogWriter getWriter() {
        return this.writer;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.TRACE);
    }

    public void trace(String s) {
        this.append(ChronicleLogLevel.TRACE, s);
    }

    public void trace(String s, Object o1) {
        if (o1 instanceof Throwable) {
            this.append(ChronicleLogLevel.TRACE, s, (Throwable)o1);
        } else {
            this.append(ChronicleLogLevel.TRACE, s, null, o1);
        }
    }

    public void trace(String s, Object o1, Object o2) {
        if (o2 instanceof Throwable) {
            this.append(ChronicleLogLevel.TRACE, s, (Throwable)o2, o1);
        } else {
            this.append(ChronicleLogLevel.TRACE, s, null, o1, o2);
        }
    }

    public void trace(String s, Object ... objects) {
        this.append(ChronicleLogLevel.TRACE, s, null, objects);
    }

    public void trace(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.TRACE, s, throwable);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.DEBUG);
    }

    public void debug(String s) {
        this.append(ChronicleLogLevel.DEBUG, s);
    }

    public void debug(String s, Object o1) {
        if (o1 instanceof Throwable) {
            this.append(ChronicleLogLevel.DEBUG, s, (Throwable)o1);
        } else {
            this.append(ChronicleLogLevel.DEBUG, s, null, o1);
        }
    }

    public void debug(String s, Object o1, Object o2) {
        if (o2 instanceof Throwable) {
            this.append(ChronicleLogLevel.DEBUG, s, (Throwable)o2, o1);
        } else {
            this.append(ChronicleLogLevel.DEBUG, s, null, o1, o2);
        }
    }

    public void debug(String s, Object ... objects) {
        this.append(ChronicleLogLevel.DEBUG, s, null, objects);
    }

    public void debug(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.DEBUG, s, throwable);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.INFO);
    }

    public void info(String s) {
        this.append(ChronicleLogLevel.INFO, s);
    }

    public void info(String s, Object o1) {
        if (o1 instanceof Throwable) {
            this.append(ChronicleLogLevel.INFO, s, (Throwable)o1);
        } else {
            this.append(ChronicleLogLevel.INFO, s, null, o1);
        }
    }

    public void info(String s, Object o1, Object o2) {
        if (o2 instanceof Throwable) {
            this.append(ChronicleLogLevel.INFO, s, (Throwable)o2, o1);
        } else {
            this.append(ChronicleLogLevel.INFO, s, null, o1, o2);
        }
    }

    public void info(String s, Object ... objects) {
        this.append(ChronicleLogLevel.INFO, s, null, objects);
    }

    public void info(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.INFO, s, throwable);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.WARN);
    }

    public void warn(String s) {
        this.append(ChronicleLogLevel.WARN, s);
    }

    public void warn(String s, Object o1) {
        if (o1 instanceof Throwable) {
            this.append(ChronicleLogLevel.WARN, s, (Throwable)o1);
        } else {
            this.append(ChronicleLogLevel.WARN, s, null, o1);
        }
    }

    public void warn(String s, Object o1, Object o2) {
        if (o2 instanceof Throwable) {
            this.append(ChronicleLogLevel.WARN, s, (Throwable)o2, o1);
        } else {
            this.append(ChronicleLogLevel.WARN, s, null, o1, o2);
        }
    }

    public void warn(String s, Object ... objects) {
        this.append(ChronicleLogLevel.WARN, s, null, objects);
    }

    public void warn(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.WARN, s, throwable);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.ERROR);
    }

    public void error(String s) {
        this.append(ChronicleLogLevel.ERROR, s);
    }

    public void error(String s, Object o1) {
        if (o1 instanceof Throwable) {
            this.append(ChronicleLogLevel.ERROR, s, (Throwable)o1);
        } else {
            this.append(ChronicleLogLevel.ERROR, s, null, o1);
        }
    }

    public void error(String s, Object o1, Object o2) {
        if (o2 instanceof Throwable) {
            this.append(ChronicleLogLevel.ERROR, s, (Throwable)o2, o1);
        } else {
            this.append(ChronicleLogLevel.ERROR, s, null, o1, o2);
        }
    }

    public void error(String s, Object ... objects) {
        this.append(ChronicleLogLevel.ERROR, s, null, objects);
    }

    public void error(String s, Throwable throwable) {
        this.append(ChronicleLogLevel.ERROR, s, throwable);
    }

    private boolean isLevelEnabled(ChronicleLogLevel level) {
        return level.isHigherOrEqualTo(this.level);
    }

    protected void append(ChronicleLogLevel level, String message) {
        if (this.isLevelEnabled(level)) {
            this.writer.write(level, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, message, null, new Object[0]);
        }
    }

    protected void append(ChronicleLogLevel level, String message, Throwable throwable) {
        if (this.isLevelEnabled(level)) {
            this.writer.write(level, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, message, throwable, new Object[0]);
        }
    }

    protected void append(ChronicleLogLevel level, String message, Throwable throwable, Object ... args) {
        if (this.isLevelEnabled(level)) {
            this.writer.write(level, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, message, throwable, args);
        }
    }
}

