/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.spi.FilterReply;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.logger.ChronicleLog;
import net.openhft.chronicle.logger.ChronicleLogHelper;
import net.openhft.chronicle.logger.TimeStampFormatter;
import net.openhft.chronicle.logger.logback.AbstractChronicleAppender;
import net.openhft.lang.io.ByteStringAppender;

public abstract class TextChronicleAppender
extends AbstractChronicleAppender {
    private String dateFormat = "yyyy.MM.dd-HH:mm:ss.SSS";
    private TimeStampFormatter timeStampFormatter = TimeStampFormatter.fromDateFormat((String)this.dateFormat);
    private int stackTradeDepth = -1;

    protected TextChronicleAppender() {
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.timeStampFormatter = TimeStampFormatter.fromDateFormat((String)dateFormat);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setStackTradeDepth(int stackTradeDepth) {
        this.stackTradeDepth = stackTradeDepth;
    }

    public int getStackTradeDepth() {
        return this.stackTradeDepth;
    }

    public void doAppend(ILoggingEvent event) {
        ExcerptAppender appender;
        if (this.getFilterChainDecision(event) != FilterReply.DENY && (appender = this.getAppender()) != null) {
            appender.startExcerpt();
            this.timeStampFormatter.format(event.getTimeStamp(), (ByteStringAppender)appender);
            appender.append('|');
            TextChronicleAppender.toChronicleLogLevel(event.getLevel()).printTo((ByteStringAppender)appender);
            appender.append('|');
            appender.append((CharSequence)event.getThreadName());
            appender.append('|');
            appender.append((CharSequence)event.getLoggerName());
            appender.append('|');
            appender.append((CharSequence)event.getFormattedMessage());
            ThrowableProxy tp = (ThrowableProxy)event.getThrowableProxy();
            if (tp != null) {
                appender.append((CharSequence)" - ");
                ChronicleLogHelper.appendStackTraceAsString((ExcerptAppender)appender, (Throwable)tp.getThrowable(), (String)", ", (int)this.stackTradeDepth);
            }
            appender.append((CharSequence)ChronicleLog.NEWLINE);
            appender.finish();
        }
    }
}

