/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import java.io.IOException;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.DefaultChronicleLogWriter;
import net.openhft.chronicle.logger.LogAppenderConfig;
import net.openhft.chronicle.logger.log4j2.AbstractChronicleAppender;
import net.openhft.lang.model.constraints.NotNull;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Chronicle", category="Core", elementType="appender", printObject=true)
public class ChronicleAppender
extends AbstractChronicleAppender {
    private final AbstractChronicleAppender.ChronicleCfg config;

    public ChronicleAppender(String name, Filter filter, String path, String wireType, AbstractChronicleAppender.ChronicleCfg config) {
        super(name, filter, path, wireType);
        this.config = config != null ? config : new AbstractChronicleAppender.ChronicleCfg();
    }

    @PluginFactory
    public static ChronicleAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="path") String path, @PluginAttribute(value="wireType") String wireType, @PluginElement(value="chronicleCfg") AbstractChronicleAppender.ChronicleCfg chronicleConfig, @PluginElement(value="filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for ChronicleAppender");
            return null;
        }
        if (path == null) {
            LOGGER.error("No path provided for ChronicleAppender");
            return null;
        }
        return new ChronicleAppender(name, filter, path, wireType, chronicleConfig);
    }

    @Override
    public void doAppend(@NotNull LogEvent event, @NotNull ChronicleLogWriter writer) {
        writer.write(ChronicleAppender.toChronicleLogLevel(event.getLevel()), event.getTimeMillis(), event.getThreadName(), event.getLoggerName(), event.getMessage().getFormattedMessage(), event.getThrown(), new Object[0]);
    }

    @Override
    protected ChronicleLogWriter createWriter() throws IOException {
        return new DefaultChronicleLogWriter(this.config.build(this.getPath(), this.getWireType()));
    }

    protected LogAppenderConfig getChronicleConfig() {
        return this.config;
    }
}

