/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import java.io.IOException;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.LogAppenderConfig;
import net.openhft.lang.model.constraints.NotNull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

public abstract class AbstractChronicleAppender
extends AbstractAppender {
    private String path;
    private String wireType;
    private ChronicleLogWriter writer;

    AbstractChronicleAppender(String name, Filter filter, String path, String wireType) {
        super(name, filter, null, true);
        this.path = path;
        this.wireType = wireType;
        this.writer = null;
    }

    static ChronicleLogLevel toChronicleLogLevel(Level level) {
        if (level.intLevel() == Level.DEBUG.intLevel()) {
            return ChronicleLogLevel.DEBUG;
        }
        if (level.intLevel() == Level.TRACE.intLevel()) {
            return ChronicleLogLevel.TRACE;
        }
        if (level.intLevel() == Level.INFO.intLevel()) {
            return ChronicleLogLevel.INFO;
        }
        if (level.intLevel() == Level.WARN.intLevel()) {
            return ChronicleLogLevel.WARN;
        }
        if (level.intLevel() == Level.ERROR.intLevel()) {
            return ChronicleLogLevel.ERROR;
        }
        throw new IllegalArgumentException(level.intLevel() + " not a valid level value");
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getWireType() {
        return this.wireType;
    }

    public void setWireType(String wireType) {
        this.wireType = wireType;
    }

    protected abstract ChronicleLogWriter createWriter() throws IOException;

    protected abstract void doAppend(@NotNull LogEvent var1, @NotNull ChronicleLogWriter var2);

    public void start() {
        if (this.getPath() == null) {
            LOGGER.error("Appender " + this.getName() + " has configuration errors and is not started!");
        } else {
            try {
                this.writer = this.createWriter();
            }
            catch (IOException e) {
                this.writer = null;
                LOGGER.error("Appender " + this.getName() + " " + e.getMessage());
            }
            super.start();
        }
    }

    public void stop() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                LOGGER.error("Appender " + this.getName() + " " + e.getMessage());
            }
        }
        super.stop();
    }

    public void append(LogEvent event) {
        if (this.writer != null) {
            this.doAppend(event, this.writer);
        }
    }

    @Plugin(name="chronicleCfg", category="Core")
    public static final class ChronicleCfg
    extends LogAppenderConfig {
        ChronicleCfg() {
        }

        @PluginFactory
        public static ChronicleCfg create(@PluginAttribute(value="blockSize") String blockSize, @PluginAttribute(value="bufferCapacity") String bufferCapacity) {
            ChronicleCfg cfg = new ChronicleCfg();
            cfg.setProperty("blockSize", blockSize);
            cfg.setProperty("bufferCapacity", bufferCapacity);
            return cfg;
        }
    }
}

