/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import java.io.IOException;
import net.openhft.chronicle.logger.ChronicleLogAppenderConfig;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.ChronicleLogWriters;
import net.openhft.chronicle.logger.IndexedLogAppenderConfig;
import net.openhft.chronicle.logger.log4j2.AbstractChronicleAppender;
import net.openhft.chronicle.logger.log4j2.AbstractTextChronicleAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="TextIndexedChronicle", category="Core", elementType="appender", printObject=true)
public class TextIndexedChronicleAppender
extends AbstractTextChronicleAppender {
    private final IndexedLogAppenderConfig config;

    public TextIndexedChronicleAppender(String name, Filter filter, String path, IndexedLogAppenderConfig config) {
        super(name, filter, path);
        this.config = config != null ? config : new IndexedLogAppenderConfig();
    }

    protected ChronicleLogWriter createWriter() throws IOException {
        return ChronicleLogWriters.text((ChronicleLogAppenderConfig)this.config, (String)super.getPath(), (String)super.getDateFormat(), (Integer)super.getStackTraceDepth());
    }

    protected IndexedLogAppenderConfig getChronicleConfig() {
        return this.config;
    }

    @PluginFactory
    public static TextIndexedChronicleAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="path") String path, @PluginAttribute(value="dateFormat") String dateFormat, @PluginAttribute(value="stackTraceDepth") String stackTraceDepth, @PluginElement(value="indexedChronicleConfig") AbstractChronicleAppender.IndexedChronicleCfg chronicleConfig, @PluginElement(value="filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for TextIndexedChronicleAppender");
            return null;
        }
        if (path == null) {
            LOGGER.error("No path provided for TextIndexedChronicleAppender");
            return null;
        }
        TextIndexedChronicleAppender appender = new TextIndexedChronicleAppender(name, filter, path, chronicleConfig);
        if (dateFormat != null) {
            appender.setDateFormat(dateFormat);
        }
        if (stackTraceDepth != null) {
            appender.setStackTraceDepth(Integer.parseInt(stackTraceDepth));
        }
        return appender;
    }
}

