/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.logger.ChronicleLog;
import net.openhft.chronicle.logger.log4j2.AbstractChronicleAppender;
import net.openhft.lang.io.RandomDataOutput;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;

public abstract class BinaryChronicleAppender
extends AbstractChronicleAppender {
    private boolean includeCallerData = true;
    private boolean includeMDC = true;
    private boolean formatMessage = false;

    protected BinaryChronicleAppender(String name, Filter filter, String path) {
        super(name, filter, path);
    }

    public void setIncludeCallerData(boolean logCallerData) {
        this.includeCallerData = logCallerData;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeMappedDiagnosticContext(boolean logMDC) {
        this.includeMDC = logMDC;
    }

    public boolean isIncludeMappedDiagnosticContext() {
        return this.includeMDC;
    }

    public void setFormatMessage(boolean formatMessage) {
        this.formatMessage = formatMessage;
    }

    public boolean isFormatMessage() {
        return this.formatMessage;
    }

    public void append(LogEvent event) {
        ExcerptAppender appender = this.getAppender();
        if (appender != null) {
            appender.startExcerpt();
            appender.writeByte(1);
            ChronicleLog.Type.LOG4J_2.writeTo((RandomDataOutput)appender);
            appender.writeLong(event.getTimeMillis());
            BinaryChronicleAppender.toChronicleLogLevel(event.getLevel()).writeTo((RandomDataOutput)appender);
            appender.writeUTF(event.getThreadName());
            appender.writeUTF(event.getLoggerName());
            if (!this.formatMessage) {
                Message message = event.getMessage();
                appender.writeUTF(event.getMessage().getFormat());
                Object[] args = message.getParameters();
                int argsLen = null != args ? args.length : 0;
                appender.writeStopBit((long)argsLen);
                for (int i = 0; i < argsLen; ++i) {
                    appender.writeObject(args[i]);
                }
            } else {
                appender.writeUTF(event.getMessage().getFormattedMessage());
                appender.writeStopBit(0L);
            }
            if (event.getThrown() != null) {
                appender.writeBoolean(true);
                appender.writeObject((Object)event.getThrown());
            } else {
                appender.writeBoolean(false);
            }
            appender.finish();
        }
    }
}

