/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.IndexedLogAppenderConfig;
import net.openhft.chronicle.logger.VanillaLogAppenderConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

public abstract class AbstractChronicleAppender
extends AbstractAppender {
    private String path;
    protected Chronicle chronicle;

    protected AbstractChronicleAppender(String name, Filter filter, String path) {
        super(name, filter, null, true);
        this.path = path;
        this.chronicle = null;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    protected abstract Chronicle createChronicle() throws IOException;

    protected abstract ExcerptAppender getAppender();

    public void start() {
        if (this.getPath() == null) {
            LOGGER.error("Appender " + this.getName() + " has configuration errors and is not started!");
        } else {
            try {
                this.chronicle = this.createChronicle();
            }
            catch (IOException e) {
                this.chronicle = null;
                LOGGER.error("Appender " + this.getName() + " " + e.getMessage());
            }
            super.start();
        }
    }

    public void stop() {
        if (this.chronicle != null) {
            try {
                this.chronicle.close();
            }
            catch (IOException e) {
                LOGGER.error("Appender " + this.getName() + " " + e.getMessage());
            }
        }
        super.stop();
    }

    public static ChronicleLogLevel toChronicleLogLevel(Level level) {
        if (level.intLevel() == Level.DEBUG.intLevel()) {
            return ChronicleLogLevel.DEBUG;
        }
        if (level.intLevel() == Level.TRACE.intLevel()) {
            return ChronicleLogLevel.TRACE;
        }
        if (level.intLevel() == Level.INFO.intLevel()) {
            return ChronicleLogLevel.INFO;
        }
        if (level.intLevel() == Level.WARN.intLevel()) {
            return ChronicleLogLevel.WARN;
        }
        if (level.intLevel() == Level.ERROR.intLevel()) {
            return ChronicleLogLevel.ERROR;
        }
        throw new IllegalArgumentException(level.intLevel() + " not a valid level value");
    }

    @Plugin(name="vanillaChronicleConfig", category="Core")
    public static final class VanillaChronicleCfg
    extends VanillaLogAppenderConfig {
        protected VanillaChronicleCfg() {
        }

        @PluginFactory
        public static VanillaChronicleCfg create(@PluginAttribute(value="dataCacheCapacity") String dataCacheCapacity, @PluginAttribute(value="cycleLength") String cycleLength, @PluginAttribute(value="cleanupOnClose") String cleanupOnClose, @PluginAttribute(value="synchronous") String synchronous, @PluginAttribute(value="defaultMessageSize") String defaultMessageSize, @PluginAttribute(value="useCheckedExcerpt") String useCheckedExcerpt, @PluginAttribute(value="entriesPerCycle") String entriesPerCycle, @PluginAttribute(value="indexCacheCapacity") String indexCacheCapacity, @PluginAttribute(value="indexBlockSize") String indexBlockSize) {
            VanillaChronicleCfg cfg = new VanillaChronicleCfg();
            cfg.setProperty("dataCacheCapacity", dataCacheCapacity);
            cfg.setProperty("cycleLength", cycleLength);
            cfg.setProperty("cleanupOnClose", cleanupOnClose);
            cfg.setProperty("synchronous", synchronous);
            cfg.setProperty("defaultMessageSize", defaultMessageSize);
            cfg.setProperty("useCheckedExcerpt", useCheckedExcerpt);
            cfg.setProperty("entriesPerCycle", entriesPerCycle);
            cfg.setProperty("indexBlockSize", indexBlockSize);
            cfg.setProperty("indexCacheCapacity", indexCacheCapacity);
            return cfg;
        }
    }

    @Plugin(name="indexedChronicleConfig", category="Core")
    public static final class IndexedChronicleCfg
    extends IndexedLogAppenderConfig {
        protected IndexedChronicleCfg() {
        }

        @PluginFactory
        public static IndexedChronicleCfg create(@PluginAttribute(value="indexFileCapacity") String indexFileCapacity, @PluginAttribute(value="indexFileExcerpts") String indexFileExcerpts, @PluginAttribute(value="indexBlockSize") String indexBlockSize, @PluginAttribute(value="useUnsafe") String useUnsafe, @PluginAttribute(value="synchronousMode") String synchronousMode, @PluginAttribute(value="cacheLineSize") String cacheLineSize, @PluginAttribute(value="messageCapacity") String messageCapacity, @PluginAttribute(value="minimiseFootprint") String minimiseFootprint, @PluginAttribute(value="useCheckedExcerpt") String useCheckedExcerpt, @PluginAttribute(value="dataBlockSize") String dataBlockSize) {
            IndexedChronicleCfg cfg = new IndexedChronicleCfg();
            cfg.setProperty("indexFileCapacity", indexFileCapacity);
            cfg.setProperty("useUnsafe", useUnsafe);
            cfg.setProperty("indexBlockSize", indexBlockSize);
            cfg.setProperty("synchronousMode", synchronousMode);
            cfg.setProperty("cacheLineSize", cacheLineSize);
            cfg.setProperty("messageCapacity", messageCapacity);
            cfg.setProperty("minimiseFootprint", minimiseFootprint);
            cfg.setProperty("useCheckedExcerpt", useCheckedExcerpt);
            cfg.setProperty("dataBlockSize", dataBlockSize);
            cfg.setProperty("indexFileExcerpts", indexFileExcerpts);
            return cfg;
        }
    }
}

