/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jul;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.openhft.chronicle.logger.ChronicleLogLevel;

public class ChronicleHelper {
    private static final Map<Level, ChronicleLogLevel> julToCHronicleLevelMap = new HashMap<Level, ChronicleLogLevel>();
    private static final Map<ChronicleLogLevel, Level> chronicleToJulLevelMap;

    public static ChronicleLogLevel getLogLevel(LogRecord julRecord) {
        return ChronicleHelper.getLogLevel(julRecord.getLevel());
    }

    public static ChronicleLogLevel getLogLevel(Level julLevel) {
        ChronicleLogLevel level = julToCHronicleLevelMap.get(julLevel);
        return level != null ? level : ChronicleLogLevel.DEBUG;
    }

    public static Level getLogLevel(ChronicleLogLevel chronicleLevel) {
        Level level = chronicleToJulLevelMap.get(chronicleLevel);
        return level != null ? level : Level.FINE;
    }

    static {
        julToCHronicleLevelMap.put(Level.ALL, ChronicleLogLevel.TRACE);
        julToCHronicleLevelMap.put(Level.FINEST, ChronicleLogLevel.TRACE);
        julToCHronicleLevelMap.put(Level.FINER, ChronicleLogLevel.TRACE);
        julToCHronicleLevelMap.put(Level.FINE, ChronicleLogLevel.DEBUG);
        julToCHronicleLevelMap.put(Level.CONFIG, ChronicleLogLevel.DEBUG);
        julToCHronicleLevelMap.put(Level.INFO, ChronicleLogLevel.INFO);
        julToCHronicleLevelMap.put(Level.WARNING, ChronicleLogLevel.WARN);
        julToCHronicleLevelMap.put(Level.SEVERE, ChronicleLogLevel.ERROR);
        chronicleToJulLevelMap = new HashMap<ChronicleLogLevel, Level>();
        chronicleToJulLevelMap.put(ChronicleLogLevel.TRACE, Level.FINER);
        chronicleToJulLevelMap.put(ChronicleLogLevel.DEBUG, Level.FINE);
        chronicleToJulLevelMap.put(ChronicleLogLevel.INFO, Level.INFO);
        chronicleToJulLevelMap.put(ChronicleLogLevel.WARN, Level.WARNING);
        chronicleToJulLevelMap.put(ChronicleLogLevel.ERROR, Level.SEVERE);
    }
}

